/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IModuleToRootsMapper;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ISoftwareSystemDirectoryProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class FileExclusionPage
extends StandardWizardPage {
    private final IModuleToRootsMapper m_mapper;
    private final ISoftwareSystemDirectoryProvider m_directoryProvider;
    private org.eclipse.swt.widgets.List m_includedFilesListWidget;
    private org.eclipse.swt.widgets.List m_excludedFilesListWidget;
    private Button m_includeButton;
    private Button m_excludeButton;
    private final Set<String> m_excludedFilesSet = new LinkedHashSet<String>();

    FileExclusionPage(String pageName, IModuleToRootsMapper mapper, ISoftwareSystemDirectoryProvider dp) {
        super(pageName, "Select source files to be excluded from the project");
        assert (mapper != null) : "Parameter 'mapper' of method 'FileExclusionPage' must not be null";
        assert (dp != null) : "Parameter 'dp' of method 'FileExclusionPage' must not be null";
        this.m_mapper = mapper;
        this.m_directoryProvider = dp;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.SYSTEM_CREATION_SOURCE_FILE_EXCLUSION_PAGE;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected void createContent(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("Source files included in project:");
        label1.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_includedFilesListWidget = new org.eclipse.swt.widgets.List(composite, 770);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.minimumHeight = 60;
        gd1.minimumWidth = 200;
        this.m_includedFilesListWidget.setLayoutData((Object)gd1);
        this.m_includedFilesListWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileExclusionPage.this.m_excludeButton.setEnabled(FileExclusionPage.this.m_includedFilesListWidget.getSelectionCount() > 0);
            }
        });
        this.m_excludeButton = new Button(composite, 0);
        this.m_excludeButton.setEnabled(false);
        this.m_excludeButton.setText("Exclude from Project");
        this.m_excludeButton.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_excludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileExclusionPage.this.exclude(FileExclusionPage.this.m_includedFilesListWidget.getSelection());
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Source files excluded from project:");
        label2.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_excludedFilesListWidget = new org.eclipse.swt.widgets.List(composite, 770);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.minimumHeight = 60;
        gd2.minimumWidth = 200;
        this.m_excludedFilesListWidget.setLayoutData((Object)gd2);
        this.m_excludedFilesListWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileExclusionPage.this.m_includeButton.setEnabled(FileExclusionPage.this.m_excludedFilesListWidget.getSelectionCount() > 0);
            }
        });
        this.m_includeButton = new Button(composite, 0);
        this.m_includeButton.setEnabled(false);
        this.m_includeButton.setText("Add to Project");
        this.m_includeButton.setLayoutData((Object)new GridData(0, 0, false, false));
        this.m_includeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileExclusionPage.this.include(FileExclusionPage.this.m_excludedFilesListWidget.getSelection());
            }
        });
        this.setPageComplete(true);
    }

    private void updateSelection() {
        this.m_includeButton.setEnabled(this.m_excludedFilesListWidget.getSelectionCount() > 0);
        this.m_excludeButton.setEnabled(this.m_includedFilesListWidget.getSelectionCount() > 0);
    }

    private void exclude(String[] excludes) {
        Arrays.stream(excludes).forEach(excluded -> {
            this.m_includedFilesListWidget.remove(excluded);
            this.m_excludedFilesSet.add((String)excluded);
        });
        ArrayList<String> excludedFiles = new ArrayList<String>(this.m_excludedFilesSet);
        Collections.sort(excludedFiles);
        this.m_excludedFilesListWidget.setRedraw(false);
        this.m_excludedFilesListWidget.removeAll();
        excludedFiles.forEach(f -> this.m_excludedFilesListWidget.add(f));
        this.m_excludedFilesListWidget.setRedraw(true);
        this.updateSelection();
    }

    private void include(String[] includes) {
        List<String> existingItems = Arrays.asList(this.m_includedFilesListWidget.getItems());
        ArrayList<String> includedFiles = new ArrayList<String>(existingItems.size() + includes.length);
        includedFiles.addAll(existingItems);
        Arrays.stream(includes).forEach(included -> {
            includedFiles.add((String)included);
            this.m_excludedFilesListWidget.remove(included);
            this.m_excludedFilesSet.remove(included);
        });
        Collections.sort(includedFiles);
        this.m_includedFilesListWidget.setRedraw(false);
        this.m_includedFilesListWidget.removeAll();
        includedFiles.forEach(f -> this.m_includedFilesListWidget.add(f));
        this.m_includedFilesListWidget.setRedraw(true);
        this.updateSelection();
    }

    Collection<String> getExcludedFiles() {
        return this.m_excludedFilesSet;
    }

    public void setVisible(boolean visible) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        super.setVisible(visible);
        TFile rootDir = this.m_directoryProvider.getSoftwareSystemDirectory();
        if (visible) {
            for (String moduleName : this.m_mapper.getModuleNames()) {
                for (DirectoryBean dir : this.m_mapper.getRootDirectoriesFor(moduleName)) {
                    for (SourceFileBean sb : dir.getAllSourceFiles()) {
                        if (this.m_excludedFilesSet.contains(sb.getFileName())) continue;
                        String path = FileUtility.calculateRelativePath((TFile)sb.getFile(), (TFile)rootDir);
                        sourceFiles.add(path);
                    }
                }
            }
        }
        Collections.sort(sourceFiles);
        this.m_includedFilesListWidget.removeAll();
        this.m_excludedFilesListWidget.removeAll();
        sourceFiles.forEach(s -> this.m_includedFilesListWidget.add(s));
        this.m_excludedFilesSet.forEach(s -> this.m_excludedFilesListWidget.add(s));
    }
}

