/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerDefinitionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CustomCheckbox;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class CompilerPropertiesPage
extends CompilerDefinitionWizardPage {
    private final Installation m_installation;
    private ValidatingTextWidget m_name;
    private ValidatingTextWidget m_description;
    private Combo m_pointerSizeCombo;
    private Combo m_longSizeCombo;
    private Combo m_wcharSizeCombo;
    private CustomCheckbox m_charIsUnsignedButton;
    private CustomCheckbox m_vlaButton;

    public CompilerPropertiesPage(String pageName, Installation installation, CompilerDefinitionModel model) {
        super(pageName, "Enter Basic Compiler Properties", model);
        assert (installation != null) : "Parameter 'installation' of method 'CompilerPropertiesPage' must not be null";
        this.m_installation = installation;
    }

    protected void createContent(Composite composite) {
        ICPlusPlusInstallationProvider ext = (ICPlusPlusInstallationProvider)this.m_installation.getExtension(ICPlusPlusInstallationProvider.class);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Compiler Definition Name:");
        this.m_name = new ValidatingTextWidget(composite, ext.getDefinitionNameValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                CompilerPropertiesPage.this.m_model.setName(text);
                CompilerPropertiesPage.this.validate();
            }
        }, null, 0);
        this.m_name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("Description:");
        this.m_description = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.isEmpty()) {
                    result.addError("Description cannot be empty");
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                CompilerPropertiesPage.this.m_model.setDescription(text);
                CompilerPropertiesPage.this.validate();
            }
        }, null, 0);
        this.m_description.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label longSizeLabel = new Label(composite, 0);
        longSizeLabel.setText("sizeof(long) in bytes:");
        String[] longSizes = new String[]{"4", "8"};
        this.m_longSizeCombo = new Combo(composite, 8);
        this.m_longSizeCombo.setItems(longSizes);
        this.m_longSizeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setLongSize(Integer.parseInt(CompilerPropertiesPage.this.m_longSizeCombo.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setLongSize(Integer.parseInt(CompilerPropertiesPage.this.m_longSizeCombo.getText()));
            }
        });
        Label pointerSizeLabel = new Label(composite, 0);
        pointerSizeLabel.setText("sizeof(void*) in bytes:");
        this.m_pointerSizeCombo = new Combo(composite, 8);
        this.m_pointerSizeCombo.setItems(longSizes);
        this.m_pointerSizeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setPointerSize(Integer.parseInt(CompilerPropertiesPage.this.m_pointerSizeCombo.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setPointerSize(Integer.parseInt(CompilerPropertiesPage.this.m_pointerSizeCombo.getText()));
            }
        });
        String[] intSizes = new String[]{"2", "4"};
        Label wcharSizeLabel = new Label(composite, 0);
        wcharSizeLabel.setText("sizeof(wchar_t) in bytes:");
        this.m_wcharSizeCombo = new Combo(composite, 8);
        this.m_wcharSizeCombo.setItems(intSizes);
        this.m_wcharSizeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setWcharSize(Integer.parseInt(CompilerPropertiesPage.this.m_wcharSizeCombo.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompilerPropertiesPage.this.m_model.setWcharSize(Integer.parseInt(CompilerPropertiesPage.this.m_wcharSizeCombo.getText()));
            }
        });
        this.m_charIsUnsignedButton = new CustomCheckbox(composite, "char is unsigned:", true, arg_0 -> ((CompilerDefinitionModel)this.m_model).setUnsignedCharacters(arg_0));
        this.m_vlaButton = new CustomCheckbox(composite, "Variable length arrays are supported:", true, arg_0 -> ((CompilerDefinitionModel)this.m_model).setVla(arg_0));
    }

    private void validate() {
        this.setPageComplete(this.m_model.getName().length() > 0 && this.m_model.getDescription().length() > 0);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_name.setText(this.m_model.getName());
            this.m_description.setText(this.m_model.getDescription());
            this.m_pointerSizeCombo.setText(Integer.toString(this.m_model.getPointerSize()));
            this.m_longSizeCombo.setText(Integer.toString(this.m_model.getLongSize()));
            this.m_wcharSizeCombo.setText(Integer.toString(this.m_model.getWcharSize()));
            this.m_charIsUnsignedButton.setSelection(this.m_model.isUnsignedCharacters());
            this.m_vlaButton.setSelection(this.m_model.isVla());
        }
        super.setVisible(visible);
    }
}

