/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.views.componentconstruction;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ComponentConstructionViewLayout
extends DrawableViewLayout {
    private static final String LEVEL = "Level";

    protected DrawableViewLayout.NodeAllocation getDefaultNodeAllocation() {
        return DrawableViewLayout.NodeAllocation.NONE;
    }

    protected Dimension layout(List<IDrawableNode> nodes, DrawableViewLayout.NodeAllocation nodeAllocation) {
        double x;
        Dimension size;
        double headerGap;
        double sourceGap;
        assert (nodes != null) : "Parameter 'nodes' of method 'layout' must not be null";
        ArrayList<IDrawableNode> headerNodes = new ArrayList<IDrawableNode>();
        ArrayList<IDrawableNode> sourceNodes = new ArrayList<IDrawableNode>();
        int nodeHeight = nodes.get((int)0).getPreferredSize().height + 8;
        int maxHeaderWidth = 0;
        int maxSourceWidth = 0;
        int width = 0;
        int height = 0;
        int sources = 0;
        int headers = 0;
        for (IDrawableNode node : nodes) {
            if ((Integer)node.getData(LEVEL) == 1) {
                sourceNodes.add(node);
                maxSourceWidth = Math.max(maxSourceWidth, node.getPreferredSize().width + 8);
                ++sources;
                continue;
            }
            headerNodes.add(node);
            maxHeaderWidth = Math.max(maxHeaderWidth, node.getPreferredSize().width + 8);
            ++headers;
        }
        Collections.sort(headerNodes, (a, b) -> a.getTextForNode().compareTo(b.getTextForNode()));
        Collections.sort(sourceNodes, (a, b) -> a.getTextForNode().compareTo(b.getTextForNode()));
        if (sources > headers) {
            height = (sources * 2 - 1) * nodeHeight;
            sourceGap = 2 * nodeHeight;
            headerGap = (double)(height - headers * nodeHeight) / ((double)headers - 1.0) + (double)nodeHeight;
        } else {
            height = (headers * 2 - 1) * nodeHeight;
            headerGap = 2 * nodeHeight;
            sourceGap = (double)(height - sources * nodeHeight) / ((double)sources - 1.0) + (double)nodeHeight;
        }
        width = 2 * maxSourceWidth + 2 * maxHeaderWidth + 32;
        double y = (double)(nodeHeight + 8) / 2.0;
        for (IDrawableNode node : headerNodes) {
            size = node.getPreferredSize();
            x = (double)(maxHeaderWidth - (size.width + 8)) / 2.0;
            node.setBounds(new Rectangle((int)x, (int)y, size.width + 8, size.height + 8));
            y += headerGap;
        }
        y = (double)(nodeHeight + 8) / 2.0;
        for (IDrawableNode node : sourceNodes) {
            size = node.getPreferredSize();
            x = (double)(width - maxSourceWidth) + (double)(maxSourceWidth - (size.width + 8)) / 2.0;
            node.setBounds(new Rectangle((int)x, (int)y, size.width + 8, size.height + 8));
            y += sourceGap;
        }
        return new Dimension(width, height + nodeHeight + 8);
    }

    protected void finishNodeCreation(NodeAdapter nodeAdapter, IDrawableNode node) {
        assert (nodeAdapter != null) : "Parameter 'nodeAdapter' of method 'finishNodeCreation' must not be null";
        assert (node != null) : "Parameter 'node' of method 'finishNodeCreation' must not be null";
        node.setData(LEVEL, (Object)nodeAdapter.getLevel());
        node.enableToolTip(false);
    }
}

