/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.visualstudio;

import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.VsProjectFileBasedModuleDelta;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class VSProjectFileBasedModuleConfigurationPage
extends StandardWizardPage {
    private Combo m_comboConfiguration;
    private Combo m_comboPlatform;
    private final VsProjectFileBasedModuleDelta m_moduleDelta;

    public VSProjectFileBasedModuleConfigurationPage(VsProjectFileBasedModuleDelta moduleDelta) {
        super("Select Configuration", "Select Configuration");
        this.m_moduleDelta = moduleDelta;
    }

    protected void createContent(Composite composite) {
        Label configurationLabel = new Label(composite, 0);
        configurationLabel.setText("Select Configuration|Platform:");
        this.m_comboConfiguration = new Combo(composite, 12);
        this.m_comboConfiguration.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_comboConfiguration.setEnabled(false);
        this.m_comboConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VSProjectFileBasedModuleConfigurationPage.this.setConfigurationAndPlatform();
            }
        });
        this.m_comboPlatform = new Combo(composite, 12);
        this.m_comboPlatform.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_comboPlatform.setEnabled(false);
        this.m_comboPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VSProjectFileBasedModuleConfigurationPage.this.setConfigurationAndPlatform();
            }
        });
        this.applyData();
    }

    private void setConfigurationAndPlatform() {
        this.m_moduleDelta.setConfiguration(new SolutionFileInfo.ConfigurationAndPlatform(this.m_comboConfiguration.getText(), this.m_comboPlatform.getText()));
        this.applyData();
    }

    private void applyData() {
        if (this.m_moduleDelta.getConfiguration() == null) {
            this.m_comboConfiguration.removeAll();
            this.setPageComplete(this.isPageComplete());
            return;
        }
        if (this.m_comboConfiguration == null) {
            return;
        }
        this.m_comboConfiguration.removeAll();
        this.m_comboPlatform.removeAll();
        if (this.m_moduleDelta.getImportDto() != null) {
            ArrayList configurations = new ArrayList(this.m_moduleDelta.getImportDto().getConfigurations().keySet());
            Collections.sort(configurations);
            HashSet<String> configurationNames = new HashSet<String>();
            HashSet<String> platformNames = new HashSet<String>();
            for (SolutionFileInfo.ConfigurationAndPlatform configuration : configurations) {
                configurationNames.add(configuration.getConfiguration());
                platformNames.add(configuration.getPlatform());
            }
            ArrayList configNames = new ArrayList(configurationNames);
            Collections.sort(configNames);
            ArrayList platforms = new ArrayList(platformNames);
            Collections.sort(platforms);
            for (String config : configNames) {
                this.m_comboConfiguration.add(config);
            }
            for (String platform : platforms) {
                this.m_comboPlatform.add(platform);
            }
        }
        if (this.m_comboConfiguration.getItemCount() > 0 && this.m_comboPlatform.getItemCount() > 0) {
            SwtUtility.selectElementOfCombo((Combo)this.m_comboConfiguration, (String)this.m_moduleDelta.getConfiguration().getConfiguration());
            SwtUtility.selectElementOfCombo((Combo)this.m_comboPlatform, (String)this.m_moduleDelta.getConfiguration().getPlatform());
            CPlusPlusVsProjectImportDto.ProjectConfiguration configuration = (CPlusPlusVsProjectImportDto.ProjectConfiguration)this.m_moduleDelta.getImportDto().getConfigurations().get(this.m_moduleDelta.getConfiguration());
            if (configuration == null) {
                this.m_comboConfiguration.setEnabled(false);
                this.m_comboPlatform.setEnabled(false);
            } else {
                this.m_comboConfiguration.setEnabled(true);
                this.m_comboPlatform.setEnabled(true);
            }
        } else {
            this.m_comboConfiguration.setEnabled(false);
            this.m_comboPlatform.setEnabled(false);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.m_moduleDelta != null && this.m_moduleDelta.getConfiguration() != null;
    }

    public void projectFileDtoUpdated() {
        this.applyData();
    }

    protected int getNumberOfColumns() {
        return 3;
    }
}

