/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateCompilerDefinitionCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateNewManualSystemCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.SystemAndModuleCreationData;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CreateSystemCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.CPlusPlusManualWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WarningWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public class NewCPlusPlusSystemWizard
extends CPlusPlusManualWizard {
    public NewCPlusPlusSystemWizard(String title) {
        super(title);
    }

    @Override
    protected List<TFile> getSystemIncludeDirectories() {
        String cdefName = this.getSelectedCompilerDefinition();
        if (cdefName == null) {
            return this.getModel().getAllSystemIncludeDirectories();
        }
        return super.getSystemIncludeDirectories();
    }

    @Override
    protected String getCompilerDefinitionName() {
        return this.getSelectedCompilerDefinition();
    }

    public void addPages() {
        if (((ICPlusPlusInstallationProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(ICPlusPlusInstallationProvider.class)).getActiveCompilerDefinition() != null) {
            this.addCompilerDefinitionPages();
            this.addBasicDataPage();
            this.addModuleDefinitionPages();
        } else {
            this.addPage((SonargraphWizardPage)new WarningWizardPage("No Active Compiler Definition", "Before a C++ software system can be created an active compiler definition must be configured on the preference pages."));
        }
    }

    @Override
    protected Command createCommand(ISoftwareSystemProvider provider) {
        return new CreateNewManualSystemCommand(provider, (CreateNewManualSystemCommand.IInteraction)new Interaction(this.getBasicDataPage()));
    }

    @Override
    protected IProjectAnalyzer createProjectAnalyzer(IWorkerContext workerContext, ICppImportExtension ext, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirectories) {
        return ext.analyzeProject(workerContext, this.getRootDirectory(), systemIncludeDirectories, extraIncludeDirectories);
    }

    @Override
    public TFile getRootDirectory() {
        return this.getBasicDataPage().getDirectory();
    }

    private class Interaction
    extends CreateSystemCommandInteraction
    implements CreateNewManualSystemCommand.IInteraction {
        private Interaction(SystemDirectoryWizardPage basicDataPage) {
            super(basicDataPage);
        }

        public void processModuleCreationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public void processOperationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public void collect(CreateCompilerDefinitionCommand.CreateCompilerDefinitionData data) {
            if (NewCPlusPlusSystemWizard.this.getSelectedCompilerDefinition() == null) {
                data.setModel(NewCPlusPlusSystemWizard.this.getModel());
            }
        }

        public boolean collect(SystemAndModuleCreationData data) {
            return NewCPlusPlusSystemWizard.this.collect(data);
        }
    }
}

