/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.windows.VisualStudioInstallationsDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.UpdateVisualStudioInstallationsCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IVisualStudioInstallationsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.LocationBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;

public final class VisualStudioInstallationsPreferencePage
extends StandardPreferencePage
implements org.eclipse.swt.events.SelectionListener {
    private List<VisualStudioInstallationsDetector.Location> m_originalLocations;
    private final List<VisualStudioInstallationsDetector.Location> m_locations = new ArrayList<VisualStudioInstallationsDetector.Location>();
    private final List<VisualStudioInstallationsDetector.Location> m_selection = new ArrayList<VisualStudioInstallationsDetector.Location>();
    private PropertyTableViewer<VisualStudioInstallationsDetector.Location> m_locationsTable;
    private Button m_add;
    private Button m_delete;
    private OperationResult m_result;

    public VisualStudioInstallationsPreferencePage() {
        this.noDefaultButton();
        this.m_result = null;
    }

    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setSize(600, 400);
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        this.m_locationsTable = new PropertyTableViewer(container, (BeanPropertyReader.BeanAdapter)new LocationBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_locationsTable.addColumn("Path", "path", "path", null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_locationsTable.addColumn("Version", "version", "version", null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_locationsTable.addColumn("Status", "status", "status", null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_locationsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonRow = new Composite(container, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_add.addSelectionListener((org.eclipse.swt.events.SelectionListener)this);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((org.eclipse.swt.events.SelectionListener)this);
        this.m_delete.setEnabled(false);
        this.resetLocations();
        this.m_locationsTable.showData(this.m_locations);
        this.m_locationsTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new SelectionListener());
        this.m_locationsTable.getTableViewer().setSelection((ISelection)new Selection());
        this.m_locationsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    private void resetLocations() {
        IVisualStudioInstallationsProvider provider = (IVisualStudioInstallationsProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IVisualStudioInstallationsProvider.class);
        this.m_originalLocations = provider.getInstallationLocations();
        this.m_locations.clear();
        this.m_locations.addAll(this.m_originalLocations);
    }

    protected ISettingsDelta getDelta() {
        return new Delta();
    }

    protected OperationResult getOperationResult() {
        return this.m_result;
    }

    protected void cancel() {
        this.m_locations.clear();
        this.m_locations.addAll(this.m_originalLocations);
        this.m_locationsTable.showData(this.m_locations);
        this.m_result = null;
    }

    protected void internPerformOk() {
        UpdateVisualStudioInstallationsCommand command = new UpdateVisualStudioInstallationsCommand(WorkbenchRegistry.getInstance().getProvider(), (UpdateVisualStudioInstallationsCommand.IInteraction)new Interaction());
        UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (exception != null) {
                    VisualStudioInstallationsPreferencePage.this.m_locationsTable.showData(VisualStudioInstallationsPreferencePage.this.m_locations);
                }
            }
        });
    }

    private void addLocation() {
        String dirName;
        DirectoryDialog dirDialog = new DirectoryDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
        dirDialog.setText("Select Visual Studio Installation Root Folder");
        TFile startDir = new TFile("C:\\Program Files (x86)\\Microsoft Visual Studio");
        if (!startDir.isDirectory()) {
            startDir = new TFile("D:\\Program Files (x86)\\Microsoft Visual Studio");
        }
        if (startDir.isDirectory()) {
            dirDialog.setFilterPath(startDir.getPath());
        }
        if ((dirName = dirDialog.open()) == null) {
            return;
        }
        TFile newPath = new TFile(dirName);
        if (!newPath.isDirectory()) {
            UserInterfaceAdapter.getInstance().warning("Directory for Visual Studio Installation", "Selected directory is not a valid existing directory!");
            return;
        }
        IVisualStudioInstallationsProvider provider = (IVisualStudioInstallationsProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IVisualStudioInstallationsProvider.class);
        OperationResult result = new OperationResult("Determining version of Visual Studio installation");
        String version = provider.determineVersion(newPath, result);
        if (result.isFailure()) {
            UserInterfaceAdapter.getInstance().warning("Directory for Visual Studio Installation", "Selected directory is not a valid Visual Studio location:\n" + Joiner.join((Collection)result.getErrorMessages()));
            return;
        }
        VisualStudioInstallationsDetector.Location loc = new VisualStudioInstallationsDetector.Location(version, newPath);
        if (!this.m_locations.contains(loc) || this.m_locations.stream().anyMatch(l -> l.getVersion().equals(version))) {
            this.m_locations.add(loc);
            this.m_locationsTable.showData(this.m_locations);
        }
    }

    private void removeLocations() {
        this.m_locations.removeAll(this.m_selection);
        this.m_selection.clear();
        this.m_locationsTable.showData(this.m_locations);
        this.m_locationsTable.getTableViewer().setSelection((ISelection)new Selection());
    }

    public void widgetSelected(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.m_add) {
            this.addLocation();
        } else if (src == this.m_delete) {
            this.removeLocations();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class Delta
    implements ISettingsDelta {
        private Delta() {
        }

        public boolean isModified() {
            return !VisualStudioInstallationsPreferencePage.this.m_locations.equals(VisualStudioInstallationsPreferencePage.this.m_originalLocations);
        }

        public void reset() {
            VisualStudioInstallationsPreferencePage.this.cancel();
        }

        public void dispose() {
        }
    }

    private class Interaction
    implements UpdateVisualStudioInstallationsCommand.IInteraction {
        private Interaction() {
        }

        public boolean fillData(UpdateVisualStudioInstallationsCommand.CommandData data) {
            if (!VisualStudioInstallationsPreferencePage.this.getDelta().isModified()) {
                return false;
            }
            ArrayList<VisualStudioInstallationsDetector.Location> added = new ArrayList<VisualStudioInstallationsDetector.Location>();
            ArrayList<VisualStudioInstallationsDetector.Location> removed = new ArrayList<VisualStudioInstallationsDetector.Location>();
            for (VisualStudioInstallationsDetector.Location loc : VisualStudioInstallationsPreferencePage.this.m_locations) {
                if (VisualStudioInstallationsPreferencePage.this.m_originalLocations.contains(loc)) continue;
                added.add(loc);
            }
            data.setAddedLocations(added);
            for (VisualStudioInstallationsDetector.Location loc : VisualStudioInstallationsPreferencePage.this.m_originalLocations) {
                if (VisualStudioInstallationsPreferencePage.this.m_locations.contains(loc)) continue;
                removed.add(loc);
            }
            data.setRemovedLocations(removed);
            return true;
        }

        public void processOperationResult(OperationResult result) {
            VisualStudioInstallationsPreferencePage.this.m_result = result;
            VisualStudioInstallationsPreferencePage.this.resetLocations();
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }

    private class Selection
    implements IStructuredSelection {
        private Selection() {
        }

        public boolean isEmpty() {
            return VisualStudioInstallationsPreferencePage.this.m_selection.isEmpty();
        }

        public Object getFirstElement() {
            return VisualStudioInstallationsPreferencePage.this.m_selection.get(0);
        }

        public Iterator<VisualStudioInstallationsDetector.Location> iterator() {
            return VisualStudioInstallationsPreferencePage.this.m_selection.iterator();
        }

        public int size() {
            return VisualStudioInstallationsPreferencePage.this.m_selection.size();
        }

        public Object[] toArray() {
            return VisualStudioInstallationsPreferencePage.this.m_selection.toArray();
        }

        public List<VisualStudioInstallationsDetector.Location> toList() {
            return Collections.unmodifiableList(VisualStudioInstallationsPreferencePage.this.m_selection);
        }
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            VisualStudioInstallationsPreferencePage.this.m_selection.clear();
            Iterator iter = event.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                VisualStudioInstallationsPreferencePage.this.m_selection.add((VisualStudioInstallationsDetector.Location)iter.next());
            }
            VisualStudioInstallationsPreferencePage.this.m_delete.setEnabled(!VisualStudioInstallationsPreferencePage.this.m_selection.isEmpty());
        }
    }
}

