/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.SearchPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsCallback;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSearchPath;
import com.hello2morrow.sonargraph.core.model.system.settings.StandardOperation;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitionActivateCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitionCreateCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitionDeleteCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitionReadRelevantCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitionUpdateCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionSearchPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GeneratedInstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromBundle;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromFile;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.CopyNameDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidatingTabItemWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.MapBackedCombo;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.CompilerDefinitionGroovyTemplateTabItem;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.DefinitionTabItem;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.HeaderItem;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.system.settings.CompilerDefinitionLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompilerDefinitionPreferencePage
extends StandardPreferencePage
implements ISettingsCallback {
    public static final String ID = "com.hello2morrow.sonargraph.ui.standalone.cplusplus.compilerdefinition.InstallationDefinitionPage";
    private static final String NAME_DIALOG_TITLE = "Enter Name for Compiler Definition";
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerDefinitionPreferencePage.class);
    private static final String SUBTITLE = "A compiler definition contains the include directories for your native compiler and further options, " + StringUtility.LINE_SEPARATOR + "so that the C,C++ EDG front-end simulates the native compiler." + StringUtility.LINE_SEPARATOR + "The active compiler definition is applied across all C,C++ software systems. Additional compiler options can be defined per module." + StringUtility.LINE_SEPARATOR + "Pre-installed compiler definitions cannot be modified. They can be used as templates to create new definitions." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR;
    private MapBackedCombo<InstCompilerDefinition> m_comboExistingDefinitions;
    private Button m_buttonActivate;
    private Button m_buttonNewDefinition;
    private Button m_buttonCopyDefinition;
    private Button m_buttonDeleteDefinition;
    private Combo m_comboPaths;
    private ArrayList<DefinitionTabItem<?>> m_tabDefinitionDetails;
    private StandardOperation m_operation;
    private InstCompilerDefinitionDelta m_currentDelta;
    private String m_previousSelectedDefinitionName;
    private String m_activeDefinitionId;
    private SelectionAdapter m_selectionAdapterExisting;
    private SelectionAdapter m_selectionAdapterActivate;
    private SelectionAdapter m_selectionAdapterNew;
    private SelectionAdapter m_selectionAdapterDelete;
    private SelectionAdapter m_selectionAdapterCopy;
    private SelectionAdapter m_selectionAdapterPath;
    private OperationResult m_operationResult;
    private CompilerDefinitionLabelProvider m_compilerDefinitionLabelProvider;
    private final CPlusPlusInstallationSettings m_installationSettings;

    public CompilerDefinitionPreferencePage() {
        this.noDefaultAndApplyButton();
        ISoftwareSystemProvider controller = WorkbenchRegistry.getInstance().getProvider();
        this.m_installationSettings = (CPlusPlusInstallationSettings)controller.getInstallation().getUniqueChild(CPlusPlusInstallationSettings.class);
        InstCompilerDefinition activeDefinition = CompilerDefinitionPreferencePage.getActiveDefinition();
        if (activeDefinition != null) {
            this.m_activeDefinitionId = activeDefinition.getName();
            this.m_currentDelta = this.createDelta(activeDefinition, false);
            this.m_previousSelectedDefinitionName = this.m_activeDefinitionId;
        } else {
            List instCompilerDefs = this.m_installationSettings.getChildren(InstCompilerDefinition.class);
            if (instCompilerDefs.size() > 0) {
                InstCompilerDefinition firstDef = (InstCompilerDefinition)instCompilerDefs.get(0);
                this.m_currentDelta = this.createDelta(firstDef, false);
                this.m_previousSelectedDefinitionName = firstDef.getName();
            }
        }
        this.m_operation = StandardOperation.EDIT;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ISoftwareSystemProvider controller = WorkbenchRegistry.getInstance().getProvider();
            InstallationCompilerDefinitionReadRelevantCommand command = new InstallationCompilerDefinitionReadRelevantCommand(controller);
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            if (command.getResult().isFailure()) {
                UserInterfaceAdapter.getInstance().process((OperationResult)command.getResult());
            }
            String definitionToSelect = this.m_currentDelta != null ? this.m_currentDelta.getOriginal().getName() : null;
            this.refreshDefinitionsAndApplyData(definitionToSelect);
        }
        super.setVisible(visible);
    }

    public IDialogId getDialogId() {
        return CPlusPlusDialogId.COMPILER_DEFINITION_PREFERENCE_PAGE;
    }

    public void dispose() {
        if (EventManager.getInstance().isAttached(SearchPathModifiedEvent.class, (Object)this)) {
            EventManager.getInstance().detach(SearchPathModifiedEvent.class, (Object)this);
        }
        this.disposeCurrentDelta();
        this.m_buttonActivate.removeSelectionListener((SelectionListener)this.m_selectionAdapterActivate);
        this.m_buttonNewDefinition.removeSelectionListener((SelectionListener)this.m_selectionAdapterNew);
        this.m_buttonCopyDefinition.removeSelectionListener((SelectionListener)this.m_selectionAdapterCopy);
        this.m_buttonDeleteDefinition.removeSelectionListener((SelectionListener)this.m_selectionAdapterDelete);
        this.removeComboListeners();
        super.dispose();
    }

    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        SwtUtility.createLabelWrapping((Composite)container, (String)SUBTITLE, (int)2, (int)this.getWidth());
        this.createTopPart(container);
        Group group = this.createGeneralInfoPart(container);
        this.createSectionPart((Composite)group);
        super.createButtonsPart(container, false);
        this.createListeners();
        this.m_buttonActivate.addSelectionListener((SelectionListener)this.m_selectionAdapterActivate);
        this.m_buttonNewDefinition.addSelectionListener((SelectionListener)this.m_selectionAdapterNew);
        this.m_buttonCopyDefinition.addSelectionListener((SelectionListener)this.m_selectionAdapterCopy);
        this.m_buttonDeleteDefinition.addSelectionListener((SelectionListener)this.m_selectionAdapterDelete);
        this.addComboListeners();
        return container;
    }

    private void createTopPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("C,C++ compiler definitions");
        GridLayout layout = SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false);
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 1, true, false);
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        Label labelSelect = new Label((Composite)group, 0);
        labelSelect.setText("Select existing definition");
        this.m_compilerDefinitionLabelProvider = new CompilerDefinitionLabelProvider(this.m_activeDefinitionId);
        this.m_comboExistingDefinitions = new MapBackedCombo((Composite)group, 780, (MapBackedCombo.ILabelProvider)this.m_compilerDefinitionLabelProvider, true);
        GridData data = new GridData(4, 1, true, false);
        this.m_comboExistingDefinitions.setLayoutData((Object)data);
        Composite buttonGroupContext = new Composite((Composite)group, 0);
        GridData gridData2 = new GridData(3, 2, true, false, 2, 1);
        buttonGroupContext.setLayoutData((Object)gridData2);
        GridLayout buttonGroupContextLayout = SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)4);
        buttonGroupContext.setLayout((Layout)buttonGroupContextLayout);
        this.m_buttonActivate = SwtUtility.createButtonForGridLayoutStandardSize((Composite)buttonGroupContext, (String)"Activate");
        this.m_buttonNewDefinition = SwtUtility.createButtonForGridLayoutStandardSize((Composite)buttonGroupContext, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.new", new Object[0]));
        this.m_buttonCopyDefinition = SwtUtility.createButtonForGridLayoutStandardSize((Composite)buttonGroupContext, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.copy", new Object[0]));
        this.m_buttonDeleteDefinition = SwtUtility.createButtonForGridLayoutStandardSize((Composite)buttonGroupContext, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.delete", new Object[0]));
    }

    private Group createGeneralInfoPart(Composite container) {
        Group group = new Group(container, 0);
        group.setText("Definition details");
        group.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        SwtUtility.createOneCellLabel((Composite)group, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.path", new Object[0]), (int)1);
        this.m_comboPaths = new Combo((Composite)group, 780);
        GridData gridDataPaths = new GridData(4, 1, true, false);
        gridDataPaths.widthHint = 200;
        this.m_comboPaths.setLayoutData((Object)gridDataPaths);
        return group;
    }

    private void createSectionPart(Composite container) {
        TabFolder tabFolder = new TabFolder(container, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        tabFolder.setLayoutData((Object)gridData);
        this.m_tabDefinitionDetails = new ArrayList();
        this.m_tabDefinitionDetails.add(new HeaderItem(tabFolder, this));
        this.m_tabDefinitionDetails.add(new CompilerDefinitionGroovyTemplateTabItem("C Options", "C Options", "Compiler options for C files (Groovy Template).", tabFolder, this){

            @Override
            protected String getTemplateText(InstCompilerDefinitionBuilder builder) {
                return builder.getSectionText("C Options");
            }
        });
        this.m_tabDefinitionDetails.add(new CompilerDefinitionGroovyTemplateTabItem("CPlusPlus Options", "C++ Options", "Compiler options for C++ files (Groovy Template).", tabFolder, this){

            @Override
            protected String getTemplateText(InstCompilerDefinitionBuilder builder) {
                return builder.getSectionText("CPlusPlus Options");
            }
        });
        this.m_tabDefinitionDetails.add(new CompilerDefinitionGroovyTemplateTabItem("Common Options", "Common Options", "Common options for C,C++ files (Groovy Template).", tabFolder, this){

            @Override
            protected String getTemplateText(InstCompilerDefinitionBuilder builder) {
                return builder.getSectionText("Common Options");
            }
        });
        this.m_tabDefinitionDetails.add(new CompilerDefinitionGroovyTemplateTabItem("Option Translations", "Option Translations", "Option translations, e.g. a => b (Groovy Template)", tabFolder, this){

            @Override
            protected String getTemplateText(InstCompilerDefinitionBuilder builder) {
                return builder.getTemplateListText("Option Translations");
            }
        });
        for (DefinitionTabItem<?> item : this.m_tabDefinitionDetails) {
            item.createWidgets();
        }
    }

    private void createListeners() {
        this.m_selectionAdapterExisting = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String label = ((Combo)event.getSource()).getText().trim();
                InstCompilerDefinition definition = (InstCompilerDefinition)CompilerDefinitionPreferencePage.this.m_comboExistingDefinitions.getItemForLabel(label);
                if (!$assertionsDisabled && definition == null) {
                    throw new AssertionError((Object)"Selected compiler definition must exist in combo!");
                }
                LOGGER.debug("Selected definition: " + definition.getName());
                if (!$assertionsDisabled && CompilerDefinitionPreferencePage.this.m_currentDelta.getOriginal() == null) {
                    throw new AssertionError((Object)"Original of delta must not be null");
                }
                if (!CompilerDefinitionPreferencePage.this.m_currentDelta.getOriginal().getName().equals(CompilerDefinitionPreferencePage.this.m_previousSelectedDefinitionName)) {
                    CompilerDefinitionPreferencePage.this.m_previousSelectedDefinitionName = CompilerDefinitionPreferencePage.this.m_currentDelta.getOriginal().getName();
                }
                CompilerDefinitionPreferencePage.this.disposeCurrentDelta();
                CompilerDefinitionPreferencePage.this.m_currentDelta = CompilerDefinitionPreferencePage.this.createDelta(definition, false);
                CompilerDefinitionPreferencePage.this.applyCurrentDeltaToDetailWidgets();
            }
        };
        this.m_selectionAdapterActivate = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstCompilerDefinition definition = CompilerDefinitionPreferencePage.this.m_currentDelta.getOriginal();
                InstallationCompilerDefinitionActivateCommand command = new InstallationCompilerDefinitionActivateCommand(WorkbenchRegistry.getInstance().getProvider(), definition);
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
                CompilerDefinitionPreferencePage.this.refreshDefinitionsAndApplyData(definition.getName());
            }
        };
        this.m_selectionAdapterNew = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerDefinitionPreferencePage.this.handleNewDefinitionCreation();
            }
        };
        this.m_selectionAdapterCopy = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerDefinitionPreferencePage.this.handleCopyDefinition();
            }
        };
        this.m_selectionAdapterDelete = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CompilerDefinitionPreferencePage.this.handleDeleteDefinition();
            }
        };
        this.m_selectionAdapterPath = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!$assertionsDisabled && e == null) {
                    throw new AssertionError((Object)"Parameter 'e' of method 'widgetSelected' must not be null");
                }
                if (!$assertionsDisabled && !(CompilerDefinitionPreferencePage.this.m_currentDelta.getModified() instanceof InstCompilerDefinitionFromFile)) {
                    throw new AssertionError((Object)("Modifications are only allowed for definitions of type '" + String.valueOf(InstCompilerDefinitionFromFile.class) + "'"));
                }
                String path = ((Combo)e.getSource()).getText();
                InstCompilerDefinitionFromFile definition = (InstCompilerDefinitionFromFile)CompilerDefinitionPreferencePage.this.m_currentDelta.getModified();
                if (definition.getFile() == null || !path.equals(definition.getFile().getParentFile().getNormalizedAbsolutePath())) {
                    definition.setPath(path);
                    CompilerDefinitionPreferencePage.this.notifyModification(true);
                    CompilerDefinitionPreferencePage.this.applyCurrentDeltaToDetailWidgets();
                }
            }
        };
        EventManager.getInstance().attach((EventHandler)new EventHandler<SearchPathModifiedEvent>(SearchPathModifiedEvent.class, (Object)this){

            public void handleEvent(SearchPathModifiedEvent event) {
                InstCompilerDefinition activeDefinition = CompilerDefinitionPreferencePage.getActiveDefinition();
                CompilerDefinitionPreferencePage.this.m_activeDefinitionId = activeDefinition != null && activeDefinition.getName().length() > 0 ? activeDefinition.getName() : null;
                CompilerDefinitionPreferencePage.this.disposeCurrentDelta();
                CompilerDefinitionPreferencePage.this.m_currentDelta = CompilerDefinitionPreferencePage.this.m_activeDefinitionId != null ? CompilerDefinitionPreferencePage.this.createDelta((InstCompilerDefinition)CompilerDefinitionPreferencePage.this.m_installationSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(CompilerDefinitionPreferencePage.this.m_activeDefinitionId), InstCompilerDefinition.class), false) : CompilerDefinitionPreferencePage.this.createDelta((InstCompilerDefinition)CompilerDefinitionPreferencePage.this.m_installationSettings.getFirstChild(InstCompilerDefinition.class), false);
                CompilerDefinitionPreferencePage.this.initWidgetsWithData();
                CompilerDefinitionPreferencePage.this.m_comboExistingDefinitions.selectElement((Object)CompilerDefinitionPreferencePage.this.m_currentDelta.getOriginal());
            }
        });
    }

    private void addComboListeners() {
        this.m_comboExistingDefinitions.addSelectionListener((SelectionListener)this.m_selectionAdapterExisting);
        this.m_comboPaths.addSelectionListener((SelectionListener)this.m_selectionAdapterPath);
    }

    private void removeComboListeners() {
        this.m_comboExistingDefinitions.removeSelectionListener((SelectionListener)this.m_selectionAdapterExisting);
        this.m_comboPaths.removeSelectionListener((SelectionListener)this.m_selectionAdapterPath);
    }

    private void initWidgetsWithData() {
        this.fillExistingDefinitions();
        this.applyCurrentDeltaToDetailWidgets();
        this.getApplyButton().setEnabled(false);
        this.getCancelButton().setEnabled(false);
    }

    private void fillExistingDefinitions() {
        this.m_comboExistingDefinitions.removeAll();
        this.m_compilerDefinitionLabelProvider.setActiveDefinitionId(this.m_activeDefinitionId);
        this.m_comboExistingDefinitions.setInput((Collection)this.m_installationSettings.getChildren(InstCompilerDefinition.class));
    }

    private void applyCurrentDeltaToDetailWidgets() {
        this.removeComboListeners();
        if (this.m_currentDelta.getOriginal() instanceof InstCompilerDefinitionFromBundle) {
            this.m_comboPaths.removeAll();
            this.m_comboPaths.add("Pre-installed compiler definition");
            this.m_comboPaths.select(0);
            this.m_comboPaths.setEnabled(false);
        } else if (this.m_currentDelta.getOriginal() instanceof GeneratedInstCompilerDefinition) {
            this.m_comboPaths.removeAll();
            this.m_comboPaths.add("Generated compiler definition");
            this.m_comboPaths.select(0);
            this.m_comboPaths.setEnabled(false);
        } else {
            this.fillComboPaths();
            InstCompilerDefinitionFromFile definitionFromFile = (InstCompilerDefinitionFromFile)this.m_currentDelta.getModified();
            if (this.m_operation == StandardOperation.NEW || definitionFromFile == null || definitionFromFile.getFile() == null) {
                this.m_comboPaths.select(0);
            } else {
                SwtUtility.selectElementOfCombo((Combo)this.m_comboPaths, (String)definitionFromFile.getFile().getParentFile().getNormalizedAbsolutePath());
            }
        }
        if (this.m_operation != StandardOperation.NEW) {
            this.m_comboPaths.setEnabled(false);
        }
        for (DefinitionTabItem<?> item : this.m_tabDefinitionDetails) {
            item.setDelta(this.m_currentDelta);
        }
        if (this.m_operation == StandardOperation.NEW) {
            this.m_buttonDeleteDefinition.setEnabled(false);
            this.enableEditWidgets(true);
        } else {
            boolean editable = this.m_currentDelta.isEditable();
            this.m_buttonDeleteDefinition.setEnabled(editable && !this.m_currentDelta.isActive());
            this.enableEditWidgets(editable);
        }
        this.addComboListeners();
        this.notifyModification(this.m_currentDelta.isModified() || this.m_currentDelta.getModified().getName().equals("IDENTIFIER_FOR_NEW_COMPILER_DEFINITION"));
    }

    private void fillComboPaths() {
        this.m_comboPaths.removeAll();
        ISoftwareSystemProvider controller = WorkbenchRegistry.getInstance().getProvider();
        InstallationSearchPath searchPath = (InstallationSearchPath)((CPlusPlusInstallationSettings)controller.getInstallation().getUniqueChild(CPlusPlusInstallationSettings.class)).getUniqueChild(CompilerDefinitionSearchPath.class);
        for (TFile dir : searchPath.createEffectiveSearchPath().getDirectories()) {
            this.m_comboPaths.add(dir.getNormalizedAbsolutePath());
        }
    }

    private void enableEditWidgets(boolean isEnabled) {
        for (ValidatingTabItemWidget validatingTabItemWidget : this.m_tabDefinitionDetails) {
            validatingTabItemWidget.setEnabled(isEnabled);
        }
    }

    private void disposeCurrentDelta() {
        if (this.m_currentDelta == null) {
            return;
        }
        this.m_currentDelta.dispose();
        this.m_currentDelta = null;
    }

    private InstCompilerDefinitionDelta createDelta(InstCompilerDefinition definition, boolean createModifiableDelta) {
        InstCompilerDefinitionDelta delta = InstallationCompilerDefinitionUpdateCommand.createDelta((InstCompilerDefinition)definition, (ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider(), (boolean)createModifiableDelta);
        delta.getModified().validate(false);
        return delta;
    }

    private void prepareWidgetsForNewOrCopiedDef() {
        this.enableTopWidgets(false);
        this.m_comboExistingDefinitions.setEnabled(false);
        this.m_comboPaths.setEnabled(true);
        this.m_comboPaths.select(0);
        this.m_comboPaths.setText(this.m_comboPaths.getItem(0));
        this.getCancelButton().setEnabled(true);
    }

    private void handleNewDefinitionCreation() {
        NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), NAME_DIALOG_TITLE, "Name", InstallationCompilerDefinitionCreateCommand.getNameValidator((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider()), false);
        if (dialog.open() == 1) {
            return;
        }
        this.m_operation = StandardOperation.NEW;
        this.m_previousSelectedDefinitionName = this.m_currentDelta.getOriginal().getName();
        for (DefinitionTabItem<?> tabItem : this.m_tabDefinitionDetails) {
            tabItem.clear();
        }
        boolean isPreviousPreInstalled = this.m_currentDelta.getOriginal() instanceof InstCompilerDefinitionFromBundle || this.m_currentDelta.getOriginal() instanceof GeneratedInstCompilerDefinition;
        this.disposeCurrentDelta();
        this.m_currentDelta = this.createDelta(null, true);
        InstCompilerDefinitionFromFile definition = (InstCompilerDefinitionFromFile)this.m_currentDelta.getModified();
        definition.setCompiler(dialog.getName());
        if (isPreviousPreInstalled) {
            this.fillComboPaths();
        }
        definition.setPath(this.m_comboPaths.getItem(0));
        this.prepareWidgetsForNewOrCopiedDef();
        this.applyCurrentDeltaToDetailWidgets();
        this.m_comboExistingDefinitions.removeAll();
        this.m_comboExistingDefinitions.setText(dialog.getName());
    }

    private void handleCopyDefinition() {
        CopyNameDialog dialog = new CopyNameDialog(this.getShell(), NAME_DIALOG_TITLE, InstallationCompilerDefinitionCreateCommand.getNameValidator((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider()), this.m_currentDelta.getModified().getName());
        dialog.setName("CopyOf" + this.m_currentDelta.getModified().getName());
        if (dialog.open() == 1) {
            return;
        }
        this.m_operation = StandardOperation.NEW;
        this.m_previousSelectedDefinitionName = this.m_currentDelta.getOriginal().getName();
        InstCompilerDefinition source = this.m_currentDelta.getOriginal();
        boolean isPreviousPreInstalled = source instanceof InstCompilerDefinitionFromBundle;
        boolean isPreviousGenerated = source instanceof GeneratedInstCompilerDefinition;
        this.disposeCurrentDelta();
        if (isPreviousPreInstalled || isPreviousGenerated) {
            this.fillComboPaths();
        }
        this.m_currentDelta = this.createDelta(null, true);
        InstCompilerDefinitionFromFile definition = (InstCompilerDefinitionFromFile)this.m_currentDelta.getModified();
        definition.setPath(this.m_comboPaths.getItem(0));
        InstCompilerDefinitionBuilder.copyDetails((InstCompilerDefinition)source, (InstCompilerDefinition)this.m_currentDelta.getModified());
        this.m_currentDelta.setActive(false);
        definition.setCompiler(dialog.getName());
        this.prepareWidgetsForNewOrCopiedDef();
        this.applyCurrentDeltaToDetailWidgets();
        this.m_comboExistingDefinitions.removeAll();
        this.m_comboExistingDefinitions.setText(dialog.getName());
    }

    private void handleDeleteDefinition() {
        UserInterfaceAdapter.Feedback answer;
        StringBuilder question = new StringBuilder();
        question.append("Do you really want to delete installation profile ").append(this.m_currentDelta.getOriginal().getName()).append("?").append(StringUtility.LINE_SEPARATOR).append("This action is executed immediately and cannot be undone.");
        if (this.m_currentDelta.getOriginal().getName().equals(this.m_activeDefinitionId)) {
            question.append(StringUtility.LINE_SEPARATOR).append(StringUtility.LINE_SEPARATOR).append("Note: Deleting the active definition will set the default definition for your platform as active.");
        }
        if ((answer = UserInterfaceAdapter.getInstance().question(question.toString(), false)) == UserInterfaceAdapter.Feedback.CANCELLED || answer == UserInterfaceAdapter.Feedback.DISAGREED) {
            return;
        }
        this.m_operation = StandardOperation.DELETE;
        this.m_currentDelta.setModified(null);
        InstallationCompilerDefinitionDeleteCommand command = new InstallationCompilerDefinitionDeleteCommand(WorkbenchRegistry.getInstance().getProvider(), this.m_currentDelta.getOriginal());
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
        if (command.getResult().containsError()) {
            UserInterfaceAdapter.getInstance().process(command.getResult());
            this.m_operationResult = command.getResult();
        }
        this.refreshDefinitionsAndApplyData(this.m_previousSelectedDefinitionName);
    }

    private void enableTopWidgets(boolean isEnabled) {
        assert (this.m_currentDelta != null) : "current delta must not be null";
        this.m_buttonActivate.setEnabled(!this.m_currentDelta.isActive() && isEnabled);
        this.m_buttonNewDefinition.setEnabled(isEnabled);
        this.m_buttonCopyDefinition.setEnabled(isEnabled);
        this.m_buttonDeleteDefinition.setEnabled(this.m_currentDelta.isEditable() && isEnabled);
        this.m_comboExistingDefinitions.setEnabled(isEnabled);
    }

    protected ISettingsDelta getDelta() {
        return this.m_currentDelta;
    }

    protected OperationResult getOperationResult() {
        return this.m_operationResult;
    }

    protected void cancel() {
        if (this.m_currentDelta != null && !this.isModified() && !this.m_currentDelta.getModified().getName().equals("IDENTIFIER_FOR_NEW_COMPILER_DEFINITION")) {
            this.enableTopWidgets(true);
            return;
        }
        if (this.m_operation == StandardOperation.EDIT) {
            String currentDefinition = this.m_currentDelta.getOriginal().getName();
            this.disposeCurrentDelta();
            InstCompilerDefinition definition = (InstCompilerDefinition)this.m_installationSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(currentDefinition), InstCompilerDefinition.class);
            this.m_currentDelta = this.createDelta(definition, false);
        } else {
            InstCompilerDefinition definition = (InstCompilerDefinition)this.m_installationSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(this.m_previousSelectedDefinitionName), InstCompilerDefinition.class);
            this.m_currentDelta = this.createDelta(definition, false);
        }
        this.m_operation = StandardOperation.EDIT;
        this.m_operationResult = null;
        this.fillExistingDefinitions();
        this.m_comboExistingDefinitions.selectElement((Object)this.m_currentDelta.getOriginal());
        this.applyCurrentDeltaToDetailWidgets();
        this.enableTopWidgets(true);
    }

    private boolean isModified() {
        if (this.m_currentDelta == null) {
            return false;
        }
        return this.m_currentDelta.isModified();
    }

    protected void internPerformOk() {
        if (!this.isModified() || this.m_currentDelta.getModified() == null) {
            return;
        }
        OperationResult result = new OperationResult("Save modified C,C++ compiler definitions");
        String definitionNameToSelect = null;
        definitionNameToSelect = this.m_currentDelta.getModified().getCompiler();
        if (this.m_operation == StandardOperation.NEW) {
            InstallationCompilerDefinitionCreateCommand command = new InstallationCompilerDefinitionCreateCommand(WorkbenchRegistry.getInstance().getProvider(), this.m_currentDelta);
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            result.addMessagesFrom(command.getResult());
        } else if (this.m_operation == StandardOperation.EDIT) {
            InstallationCompilerDefinitionUpdateCommand command = new InstallationCompilerDefinitionUpdateCommand(WorkbenchRegistry.getInstance().getProvider(), this.m_currentDelta);
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            result.addMessagesFrom(command.getResult());
        } else assert (false) : "operation '" + this.m_operation.getStandardName() + "' not supported";
        if (result.containsError()) {
            UserInterfaceAdapter.getInstance().process(result);
            this.m_operationResult = result;
            return;
        }
        this.refreshDefinitionsAndApplyData(definitionNameToSelect);
    }

    private void refreshDefinitionsAndApplyData(String definitionNameToSelect) {
        InstCompilerDefinition definition;
        InstCompilerDefinition activeDefinition = CompilerDefinitionPreferencePage.getActiveDefinition();
        if (activeDefinition != null) {
            this.m_activeDefinitionId = activeDefinition.getName();
        }
        if (definitionNameToSelect != null) {
            definition = (InstCompilerDefinition)this.m_installationSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(definitionNameToSelect), InstCompilerDefinition.class);
            this.m_currentDelta = definition != null ? this.createDelta(definition, false) : null;
        } else if (activeDefinition != null) {
            this.m_currentDelta = this.createDelta(activeDefinition, !(activeDefinition instanceof GeneratedInstCompilerDefinition) && !(activeDefinition instanceof InstCompilerDefinitionFromBundle));
        }
        if (definitionNameToSelect == null && activeDefinition == null || this.m_currentDelta == null) {
            definition = (InstCompilerDefinition)this.m_installationSettings.getFirstChild(InstCompilerDefinition.class);
            this.m_currentDelta = definition != null ? this.createDelta(definition, false) : null;
        }
        if (this.m_currentDelta != null) {
            this.m_operation = StandardOperation.EDIT;
            this.initWidgetsWithData();
            this.m_comboExistingDefinitions.selectElement((Object)this.m_currentDelta.getOriginal());
            this.enableTopWidgets(true);
        } else {
            this.m_buttonActivate.setEnabled(false);
            this.m_buttonNewDefinition.setEnabled(true);
            this.m_buttonCopyDefinition.setEnabled(false);
            this.m_buttonDeleteDefinition.setEnabled(false);
            this.m_comboExistingDefinitions.setEnabled(true);
            this.enableEditWidgets(false);
        }
    }

    private static InstCompilerDefinition getActiveDefinition() {
        ICPlusPlusInstallationProvider settingsProvider = (ICPlusPlusInstallationProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(ICPlusPlusInstallationProvider.class);
        InstCompilerDefinition definition = settingsProvider.getActiveCompilerDefinition();
        return definition;
    }

    public boolean isDeltaValid() {
        if (this.m_currentDelta == null) {
            return true;
        }
        if (this.m_operation == StandardOperation.DELETE) {
            return true;
        }
        InstCompilerDefinition definition = this.m_currentDelta.getModified();
        return !definition.validate(false).isFailure();
    }

    public void notifyModification(boolean isModified) {
        this.enableTopWidgets(!isModified);
        this.getCancelButton().setEnabled(isModified);
        this.getApplyButton().setEnabled(isModified);
    }
}

