/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.visualstudio;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateVsProjectFileBasedCPlusPlusModuleCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.VsProjectFileBasedModuleDelta;
import com.hello2morrow.sonargraph.ui.standalone.wizard.visualstudio.VSProjectFileBasedModuleConfigurationPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class VSProjectFileBasedModuleWizardPage
extends StandardWizardPage
implements ValidatingPathWidget.IConsumer {
    private final TFile m_basePath;
    private ValidatingPathWidget m_validatingPathWidget;
    private IPathValidator m_pathValidator;
    private final ITextValidator m_nameValidator;
    private ValidatingTextWidget m_validatingNameTextWidget;
    private ValidatingTextWidget m_validatingDescriptionTextWidget;
    private final VsProjectFileBasedModuleDelta m_moduleDelta;

    VSProjectFileBasedModuleWizardPage(ITextValidator nameValidator, TFile basePath, VsProjectFileBasedModuleDelta moduleDelta) {
        super("Specify the Visual Studio 2010 Project File", "Specify the Visual Studio 2010 Project File");
        assert (basePath != null) : "Parameter 'basePath' of method 'CPlusPlusVsProjectModuleDialog' must not be null";
        this.m_basePath = basePath;
        this.m_nameValidator = nameValidator;
        this.m_moduleDelta = moduleDelta;
        this.setPageComplete(false);
        this.setModuleNameValid(this.m_moduleDelta.getModuleName());
    }

    public boolean isPageComplete() {
        boolean isComplete = this.m_moduleDelta.isModuleNameValid() && this.m_moduleDelta.getImportDto() != null && this.m_moduleDelta.getProjectFile() != null && this.m_moduleDelta.getProjectFile().exists();
        return isComplete;
    }

    public void setPath(TFile input, boolean inputModified) {
        if (!inputModified || this.m_pathValidator.isValid(null, input).isFailure()) {
            return;
        }
        this.m_moduleDelta.setProjectFile(input);
        CPlusPlusVsProjectImportDto importDto = this.m_moduleDelta.getImportDto();
        if (!(importDto.getConfigurations() == null || importDto.getConfigurations().isEmpty() || this.m_moduleDelta.getConfiguration() != null && importDto.getConfigurations().containsKey(this.m_moduleDelta.getConfiguration()))) {
            ArrayList configurations = new ArrayList(importDto.getConfigurations().keySet());
            Collections.sort(configurations);
            this.m_moduleDelta.setConfiguration((SolutionFileInfo.ConfigurationAndPlatform)configurations.get(0));
        }
        if (this.m_moduleDelta.getModule() != null) {
            this.m_validatingNameTextWidget.setEnabled(false);
            this.m_validatingNameTextWidget.setText(this.m_moduleDelta.getImportDto().getProjectName());
            this.m_validatingNameTextWidget.setEnabled(true);
        } else {
            this.m_validatingNameTextWidget.setText(this.m_moduleDelta.getImportDto().getProjectName());
        }
        ((VSProjectFileBasedModuleConfigurationPage)this.getNextPage()).projectFileDtoUpdated();
        this.setPageComplete(this.isPageComplete());
    }

    protected void createContent(Composite composite) {
        Label path = new Label(composite, 0);
        path.setText("File (" + CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension() + "):");
        this.m_pathValidator = CreateVsProjectFileBasedCPlusPlusModuleCommand.getVisualStudioProjectFileValidator((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider(), (VsProjectFileBasedModuleDelta)this.m_moduleDelta);
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, (ValidatingPathWidget.IConsumer)this, this.m_pathValidator, 10, null, true, this.m_basePath);
        GridData pathFieldLayoutData = new GridData(768);
        pathFieldLayoutData.horizontalSpan = 2;
        this.m_validatingPathWidget.setLayoutData((Object)pathFieldLayoutData);
        this.m_validatingPathWidget.setFilterExtensions(new String[]{"*" + CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension()});
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name:");
        this.m_validatingNameTextWidget = new ValidatingTextWidget(composite, this.m_nameValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String name, boolean inputModified) {
                VSProjectFileBasedModuleWizardPage.this.setModuleNameValid(name);
                VSProjectFileBasedModuleWizardPage.this.setPageComplete(VSProjectFileBasedModuleWizardPage.this.isPageComplete());
            }
        }, this.m_moduleDelta.getModuleName(), 0);
        this.m_validatingNameTextWidget.setEditable(false);
        GridData nameFieldLayoutData = new GridData(768);
        nameFieldLayoutData.horizontalSpan = 2;
        this.m_validatingNameTextWidget.setLayoutData((Object)nameFieldLayoutData);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("Description:");
        this.m_validatingDescriptionTextWidget = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                VSProjectFileBasedModuleWizardPage.this.m_moduleDelta.setDescription(text);
                VSProjectFileBasedModuleWizardPage.this.setPageComplete(VSProjectFileBasedModuleWizardPage.this.isPageComplete());
            }
        }, this.m_moduleDelta.getDescription(), 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.m_validatingDescriptionTextWidget.setLayoutData((Object)layoutData);
        if (this.m_moduleDelta.getModule() != null) {
            this.m_validatingPathWidget.setPath(FileUtility.calculateRelativePath((TFile)this.m_moduleDelta.getProjectFile(), (TFile)this.m_basePath));
            this.m_validatingPathWidget.setModifiable(false);
            this.m_validatingDescriptionTextWidget.setFocus();
        } else {
            this.m_validatingNameTextWidget.setFocus();
        }
    }

    private void setModuleNameValid(String name) {
        this.m_moduleDelta.setModuleNameValid(name != null);
    }

    protected int getNumberOfColumns() {
        return 3;
    }
}

