/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.shared;

import com.hello2morrow.sonargraph.core.foundation.common.ModuleNameValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ICommandDataProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IModuleToRootsMapper;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public final class ModuleAssignmentPage
extends StandardWizardPage
implements IModuleToRootsMapper {
    private final ICommandDataProvider m_dataProvider;
    private final List<String> m_moduleNames = new ArrayList<String>();
    private final List<String> m_existingModuleNames = new ArrayList<String>();
    private final Map<DirectoryBean, String> m_assignmentMap = new LinkedHashMap<DirectoryBean, String>();
    private TableViewer m_tableViewer;
    private ModuleComboEditorSupport m_editingSupport;

    public ModuleAssignmentPage(String pageName, String title, ICommandDataProvider dataProvider) {
        super(pageName, title);
        this.m_dataProvider = dataProvider;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.ASSIGN_ROOT_DIRECTORIES_TO_MODULES_WIZARD_PAGE;
    }

    public void initExistingModuleNames() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No software system available!";
        List modules = ((Workspace)provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
        this.m_existingModuleNames.addAll(modules.stream().map(m -> m.getShortName()).collect(Collectors.toList()));
    }

    protected void createContent(Composite composite) {
        this.m_tableViewer = new TableViewer(composite, 2816);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        this.m_tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_editingSupport = new ModuleComboEditorSupport();
        TableViewerColumn rootColumn = new TableViewerColumn(this.m_tableViewer, 0);
        rootColumn.getColumn().setText("Root Directory");
        rootColumn.getColumn().setWidth(400);
        rootColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DirectoryBean dir = (DirectoryBean)element;
                return dir.getDirectory().getPath();
            }
        });
        TableViewerColumn moduleColumn = new TableViewerColumn(this.m_tableViewer, 0);
        moduleColumn.getColumn().setText("Assigned Module");
        moduleColumn.getColumn().setWidth(200);
        moduleColumn.setEditingSupport((EditingSupport)this.m_editingSupport);
        moduleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DirectoryBean dir = (DirectoryBean)element;
                String module = ModuleAssignmentPage.this.m_assignmentMap.get(dir);
                return module == null ? "" : module;
            }
        });
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            HashSet<DirectoryBean> previousDirectoryBeans = new HashSet<DirectoryBean>(this.m_assignmentMap.keySet());
            List<DirectoryBean> rootDirectoriesForModules = this.m_dataProvider.getRootDirectoriesForModules();
            for (DirectoryBean root : rootDirectoriesForModules) {
                Object modName;
                String oldVal = this.m_assignmentMap.get(root);
                previousDirectoryBeans.remove(root);
                if (oldVal != null && oldVal.length() > 0) continue;
                String superRootPath = null;
                DirectoryBean superRoot = root;
                while (superRoot.getParent() != null && superRoot.getParent().getDirectory() != null) {
                    superRoot = superRoot.getParent();
                }
                superRootPath = FileUtility.convertPathToUniversalForm((String)superRoot.getDirectory().getPath());
                if (superRoot != root) {
                    modName = FileUtility.convertPathToUniversalForm((String)root.getDirectory().getPath()).substring(superRootPath.length() + 1);
                    int slashPos = ((String)modName).indexOf(47);
                    if (slashPos > 0) {
                        modName = ((String)modName).substring(0, slashPos);
                    }
                } else {
                    modName = root.getDirectory().getName();
                }
                modName = ((String)modName).replace(' ', '_');
                String baseName = modName;
                int counter = 1;
                while (this.m_existingModuleNames.contains(modName)) {
                    modName = baseName + "_" + counter;
                    ++counter;
                }
                this.m_assignmentMap.put(root, (String)modName);
                if (this.m_moduleNames.contains(modName)) continue;
                this.m_moduleNames.add((String)modName);
            }
            if (!previousDirectoryBeans.isEmpty()) {
                for (DirectoryBean next : previousDirectoryBeans) {
                    this.m_assignmentMap.remove(next);
                }
            }
            this.m_editingSupport.updateInput();
            this.m_tableViewer.setInput(rootDirectoriesForModules);
            this.setPageComplete(this.m_assignmentMap.size() == rootDirectoriesForModules.size());
        } else {
            this.m_tableViewer.setInput(null);
        }
        super.setVisible(visible);
    }

    @Override
    public Collection<String> getModuleNames() {
        return new TreeSet<String>(this.m_assignmentMap.values());
    }

    @Override
    public List<DirectoryBean> getRootDirectoriesFor(String module) {
        ArrayList<DirectoryBean> result = new ArrayList<DirectoryBean>();
        for (Map.Entry<DirectoryBean, String> entry : this.m_assignmentMap.entrySet()) {
            if (!entry.getValue().equals(module)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private final class ModuleComboEditorSupport
    extends EditingSupport {
        private final ComboBoxViewerCellEditor m_editor;
        private final ModuleNameValidator m_validator;

        public ModuleComboEditorSupport() {
            super((ColumnViewer)ModuleAssignmentPage.this.m_tableViewer);
            this.m_validator = new ModuleNameValidator();
            this.m_editor = new ComboBoxViewerCellEditor((Composite)ModuleAssignmentPage.this.m_tableViewer.getTable());
            this.m_editor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.updateInput();
            this.m_editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    String str;
                    if (value != null && !ModuleComboEditorSupport.this.validateModuleName(str = ((String)value).trim())) {
                        return ModuleAssignmentPage.this.getErrorMessage();
                    }
                    return null;
                }
            });
        }

        private void updateInput() {
            this.m_editor.setInput(ModuleAssignmentPage.this.m_moduleNames);
        }

        private boolean validateModuleName(String s) {
            if (!this.m_validator.isValid(s)) {
                ModuleAssignmentPage.this.setErrorMessage("Module name does not begin with a letter or contains invalid characters");
                return false;
            }
            if (ModuleAssignmentPage.this.m_existingModuleNames.contains(s)) {
                ModuleAssignmentPage.this.setErrorMessage("Name already taken by an existing module");
                return false;
            }
            ModuleAssignmentPage.this.setErrorMessage(null);
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.m_editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            CCombo combo;
            Object value = cellEditor.getValue();
            if (value == null && !this.validateModuleName((String)(value = (combo = (CCombo)this.m_editor.getViewer().getControl()).getText()))) {
                value = null;
            }
            if (cellEditor.isValueValid()) {
                this.setValue(cell.getElement(), value);
            } else {
                ModuleAssignmentPage.this.setErrorMessage(cellEditor.getErrorMessage());
            }
        }

        protected Object getValue(Object element) {
            return ModuleAssignmentPage.this.m_assignmentMap.get(element);
        }

        protected void setValue(Object element, Object value) {
            String moduleName;
            String string = moduleName = value == null ? "" : ((String)value).trim();
            if (moduleName.length() == 0) {
                ModuleAssignmentPage.this.m_assignmentMap.remove(element);
                ModuleAssignmentPage.this.setPageComplete(false);
            } else {
                if (!ModuleAssignmentPage.this.m_moduleNames.contains(moduleName)) {
                    ModuleAssignmentPage.this.m_moduleNames.add(moduleName);
                    this.m_editor.getViewer().refresh();
                }
                ModuleAssignmentPage.this.m_assignmentMap.put((DirectoryBean)element, moduleName);
                ModuleAssignmentPage.this.setPageComplete(ModuleAssignmentPage.this.m_assignmentMap.size() == ModuleAssignmentPage.this.m_dataProvider.getRootDirectoriesForModules().size());
            }
            ModuleAssignmentPage.this.m_tableViewer.update(element, null);
        }
    }
}

