/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.RegexValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerDefinitionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CustomCheckbox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class CompilerCompatibilityPage
extends CompilerDefinitionWizardPage {
    private CustomCheckbox m_microsoftButton;
    private CustomCheckbox m_gnuButton;
    private CustomCheckbox m_clangButton;
    private ValidatingTextWidget m_microsoftVersion;
    private ValidatingTextWidget m_gnuVersion;
    private ValidatingTextWidget m_clangVersion;

    public CompilerCompatibilityPage(String pageName, CompilerDefinitionModel model) {
        super(pageName, "Compiler Compatibility", model);
    }

    protected void createContent(Composite composite) {
        this.m_microsoftButton = new CustomCheckbox(composite, "Enable Microsoft compatibility:", true, b -> {
            this.m_model.setMicrosoftMode(b.booleanValue());
            this.m_microsoftVersion.setText(this.m_model.getMicrosoftVersion());
            this.setPageComplete(this.isPageComplete());
        });
        new Label(composite, 0).setText("Value of _MSC_VER:");
        this.m_microsoftVersion = new ValidatingTextWidget(composite, (ITextValidator)new RegexValidator("[1-9][0-9][0-9][0-9]?"){

            public ValidationResult isValid(String currentInput, String newInput) {
                if (!CompilerCompatibilityPage.this.m_microsoftButton.getSelection()) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
                return super.isValid(currentInput, newInput);
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                CompilerCompatibilityPage.this.m_model.setMicrosoftVersion(input);
                CompilerCompatibilityPage.this.setPageComplete(CompilerCompatibilityPage.this.isPageComplete());
            }
        });
        this.m_gnuButton = new CustomCheckbox(composite, "Enable Gnu compatibility:", true, b -> {
            this.m_model.setGnuMode(b.booleanValue());
            this.m_gnuVersion.setText(this.m_model.getGnuVersion());
            this.setPageComplete(this.isPageComplete());
        });
        new Label(composite, 0).setText("Gcc version (e.g. '3.8.1'):");
        this.m_gnuVersion = new ValidatingTextWidget(composite, (ITextValidator)new RegexValidator("[1-9]+\\.[0-9]+\\.[0-9]+"){

            public ValidationResult isValid(String currentInput, String newInput) {
                if (!CompilerCompatibilityPage.this.m_gnuButton.getSelection()) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
                return super.isValid(currentInput, newInput);
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                CompilerCompatibilityPage.this.m_model.setGnuVersion(input);
                CompilerCompatibilityPage.this.setPageComplete(CompilerCompatibilityPage.this.isPageComplete());
            }
        });
        this.m_clangButton = new CustomCheckbox(composite, "Enable CLang compatibility:", true, b -> {
            this.m_model.setClangMode(b.booleanValue());
            this.m_clangVersion.setText(this.m_model.getClangVersion());
            this.setPageComplete(this.isPageComplete());
        });
        new Label(composite, 0).setText("CLang version (e.g. '7.0.1'):");
        this.m_clangVersion = new ValidatingTextWidget(composite, (ITextValidator)new RegexValidator("[1-9]+\\.[0-9]+\\.[0-9]+"){

            public ValidationResult isValid(String currentInput, String newInput) {
                if (!CompilerCompatibilityPage.this.m_clangButton.getSelection()) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
                return super.isValid(currentInput, newInput);
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                CompilerCompatibilityPage.this.m_model.setClangVersion(input);
                CompilerCompatibilityPage.this.setPageComplete(CompilerCompatibilityPage.this.isPageComplete());
            }
        });
    }

    public boolean isPageComplete() {
        return this.m_microsoftVersion.isValid() && this.m_gnuVersion.isValid() && this.m_clangVersion.isValid();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_microsoftButton.setSelection(this.m_model.isMicrosoftMode());
            this.m_microsoftVersion.setText(this.m_model.getMicrosoftVersion());
            this.m_gnuButton.setSelection(this.m_model.isGnuMode());
            this.m_gnuVersion.setText(this.m_model.getGnuVersion());
            this.m_clangButton.setSelection(this.m_model.isClangMode());
            this.setPageComplete(this.isPageComplete());
        }
        super.setVisible(visible);
    }
}

