/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.capturing;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

final class CapturingExplanationPage
extends StandardWizardPage
implements IDirectoryBeanProvider {
    private final IDirectoryBeanProvider m_directoryBeanProvider;
    private StyledText m_text;
    private List<DirectoryBean> m_roots;

    CapturingExplanationPage(String pageName, String title, IDirectoryBeanProvider dp) {
        super(pageName, title);
        assert (dp != null) : "Parameter 'dp' of method 'CapturingExplanationPage' must not be null";
        this.m_directoryBeanProvider = dp;
    }

    protected void createContent(Composite composite) {
        this.m_text = new StyledText(composite, 8);
        String text = "The command capturing process works for systems built with 'make'. You will have to do a complete rebuild\nof your system while passing a special shell to the 'make' command. The special shell will create raw\nfiles named 'h2m-capture.txt' for each 'Makefile' that executes compile commands during the make process.\nThese files contain a complete list of the compile commands and are used to extract the right options for \nthe C,C++ parser. If you change options or add or remove files from your build you have to repeat the\ncapturing process and execute 'Update C,C++ Modules from Capturing' from the 'System' menu. Please note\nthat your top level 'Makefile'\n must be either in the same directory as the Sonargraph system or in a\nsub-directory of that directory.\n\nHere are the commands you need to execute on the level of your top-level 'Makefile':\n\nSG_DIR=<replace with Sonargraph installation directory>\n$SG_DIR/bin/h2mcs clean\nmake clean\nmake <optional-targets> SHELL=$SG_DIR/bin/h2mcs\n\nAfter executing those commands you should find 'h2m-capture.txt' files in the relevant project directories\n'make clean' can be replaced with another command you use to force a complete rebuild of your system. On\nWindows platforms the capturing process currently only works in combination with Cygwin.";
        this.m_text.setText("The command capturing process works for systems built with 'make'. You will have to do a complete rebuild\nof your system while passing a special shell to the 'make' command. The special shell will create raw\nfiles named 'h2m-capture.txt' for each 'Makefile' that executes compile commands during the make process.\nThese files contain a complete list of the compile commands and are used to extract the right options for \nthe C,C++ parser. If you change options or add or remove files from your build you have to repeat the\ncapturing process and execute 'Update C,C++ Modules from Capturing' from the 'System' menu. Please note\nthat your top level 'Makefile'\n must be either in the same directory as the Sonargraph system or in a\nsub-directory of that directory.\n\nHere are the commands you need to execute on the level of your top-level 'Makefile':\n\nSG_DIR=<replace with Sonargraph installation directory>\n$SG_DIR/bin/h2mcs clean\nmake clean\nmake <optional-targets> SHELL=$SG_DIR/bin/h2mcs\n\nAfter executing those commands you should find 'h2m-capture.txt' files in the relevant project directories\n'make clean' can be replaced with another command you use to force a complete rebuild of your system. On\nWindows platforms the capturing process currently only works in combination with Cygwin.");
        this.m_text.setEditable(false);
        StyleRange sr = new StyleRange();
        sr.start = text.indexOf("SG_DIR=");
        sr.length = text.indexOf("After") - sr.start;
        sr.font = UiResourceManager.getInstance().getDefaultMonospaceFont(false);
        this.m_text.setStyleRange(sr);
        this.m_text.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button collectFiles = new Button(composite, 8);
        collectFiles.setText("Collect Capturing Files");
        collectFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CapturingExplanationPage.this.collectFiles();
            }
        });
        this.setPageComplete(false);
    }

    private void collectFiles() {
        OperationResult result = new OperationResult("Collecting Capturing Files");
        this.m_roots = this.m_directoryBeanProvider.getRoots(result);
        if (result.isFailure()) {
            this.setPageComplete(false);
            UserInterfaceAdapter.getInstance().process(result);
        } else {
            boolean done = this.m_roots != null && !this.m_roots.isEmpty();
            this.setPageComplete(done);
            if (done) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage("Could not find any capturing files");
            }
        }
    }

    @Override
    public List<DirectoryBean> getRoots(OperationResult result) {
        return this.m_roots;
    }

    @Override
    public TFile getFile() {
        return this.m_directoryBeanProvider.getFile();
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.IMPORT_MODULE_CPP_CAPTURING_FILES;
    }
}

