/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.command.system.settings.InstSpecDirSearchPathValidator;
import com.hello2morrow.sonargraph.core.model.event.ConfigurationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSearchPath;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.CppSearchPathProviderManager;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.CppSearchPathSaveCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.InstallationCompilerDefinitonReadAllCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.SearchPathEditInstSpecDirCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionSearchPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.SearchPathContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.settings.SearchPathControl;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CppSearchPathPreferencePage
extends StandardPreferencePage
implements SearchPathControl.ISearchPathControlCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppSearchPathPreferencePage.class);
    public static final String ID = "com.hello2morrow.sonargraph.ui.standalone.cplusplus.compilerdefinition.SearchPathPreferences";
    private final Map<TFile, List<TFile>> m_originalInstSpecificDefs;
    private Map<TFile, List<TFile>> m_instSpecificDefs;
    private TFile m_instSpecificDir;
    private TFile m_originalInstSpecDir;
    private Map<TFile, List<TFile>> m_originalSearchPathDefs;
    private SearchPathControl m_searchPathControl;
    private final ISearchPathProviderManager m_searchPathProviderManager;
    private TreeViewer m_InstallationSpecificTreeView;
    private Button m_buttonEditInstSpecDir;
    private OperationResult m_operationResult;
    private SearchPathDelta m_delta;

    public CppSearchPathPreferencePage() {
        this.noDefaultAndApplyButton();
        this.m_searchPathProviderManager = new CppSearchPathProviderManager(WorkbenchRegistry.getInstance().getProvider());
        this.m_originalInstSpecificDefs = new HashMap<TFile, List<TFile>>();
        this.initializeData();
    }

    public IDialogId getDialogId() {
        return CPlusPlusDialogId.COMPILER_DEFINITION_SEARCHPATH_PREFERENCE_PAGE;
    }

    private void initializeData() {
        InstallationCompilerDefinitonReadAllCommand command = new InstallationCompilerDefinitonReadAllCommand(WorkbenchRegistry.getInstance().getProvider());
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
        this.processReadAllCommandResult(command);
    }

    private void processReadAllCommandResult(InstallationCompilerDefinitonReadAllCommand command) {
        this.m_originalSearchPathDefs = new LinkedHashMap<TFile, List<TFile>>(command.getCompilerContexts());
        this.m_originalSearchPathDefs.remove(null);
        InstallationSearchPath searchPath = this.getCppSearchPath();
        this.m_instSpecificDir = this.m_originalInstSpecDir = searchPath.getInstSpecificDir();
        assert (this.m_instSpecificDir != null);
        InstSpecDirSearchPathValidator validator = (InstSpecDirSearchPathValidator)this.m_searchPathProviderManager.getValidator();
        validator.setInstSpecDir(this.m_originalInstSpecDir, false);
        List<TFile> instSpecDefinitions = this.m_originalSearchPathDefs.remove(this.m_originalInstSpecDir);
        if (instSpecDefinitions == null) {
            instSpecDefinitions = new ArrayList<TFile>();
        }
        this.m_originalInstSpecificDefs.put(this.m_originalInstSpecDir, instSpecDefinitions);
        this.m_instSpecificDefs = this.copyMap(this.m_originalInstSpecificDefs);
        this.m_delta = new SearchPathDelta(this.m_originalSearchPathDefs);
    }

    public void dispose() {
        if (EventManager.getInstance().isAttached(ConfigurationModifiedEvent.class, (Object)this)) {
            EventManager.getInstance().detach(ConfigurationModifiedEvent.class, (Object)this);
        }
        super.dispose();
    }

    private InstallationSearchPath getCppSearchPath() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)installation.getUniqueChild(CPlusPlusInstallationSettings.class);
        assert (instSettings != null) : "Child of type '" + CPlusPlusInstallationSettings.class.getName() + "' must exist in Installation";
        InstallationSearchPath searchPath = (InstallationSearchPath)instSettings.getUniqueChild(CompilerDefinitionSearchPath.class);
        return searchPath;
    }

    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setSize(600, 400);
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        SwtUtility.createLabelWrapping((Composite)container, (String)("This dialog allows you to define directories that will be scanned for compiler definitions. " + StringUtility.LINE_SEPARATOR + "Definitions found in the search path are meant to be exchangeable between different machines and should therefore contain machine-independent compiler settings." + StringUtility.LINE_SEPARATOR + "All definitions contained in the directories are listed, but only the first found in the search path will be applied."), (int)2, (int)500);
        this.m_searchPathControl = new SearchPathControl(this.m_searchPathProviderManager, (SearchPathControl.ISearchPathControlCallback)this);
        this.m_searchPathControl.createContent(container, 350, 0);
        SwtUtility.createFillerForGridLayoutCell((Composite)container);
        SwtUtility.createFillerForGridLayoutCell((Composite)container);
        SwtUtility.createOneCellLabelAligned((Composite)container, (String)("Set the directory where machine specific compiler definitions are loaded from." + StringUtility.LINE_SEPARATOR + "These options override those loaded from the search path:"), (int)1, (int)0x1000000);
        SwtUtility.createFillerForGridLayoutCell((Composite)container);
        this.m_InstallationSpecificTreeView = this.createTreeView(container, 100);
        this.m_InstallationSpecificTreeView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CppSearchPathPreferencePage.this.m_buttonEditInstSpecDir.setEnabled(SearchPathControl.isSingleDirectorySelected((TreeViewer)CppSearchPathPreferencePage.this.m_InstallationSpecificTreeView));
            }
        });
        this.m_buttonEditInstSpecDir = SwtUtility.createButtonForGridLayoutStandardSize((Composite)container, (String)"Edit...");
        this.m_buttonEditInstSpecDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
                dirDialog.setFilterPath(CppSearchPathPreferencePage.this.m_instSpecificDir.getNormalizedAbsolutePath());
                String fileName = dirDialog.open();
                if (fileName == null) {
                    return;
                }
                TFile newPath = new TFile(fileName);
                if (!newPath.isDirectory() || !newPath.exists()) {
                    UserInterfaceAdapter.getInstance().warning("Directory for Installation Specific C++ Compiler Definitions", "Selected directory is not a valid existing directory!");
                    LOGGER.warn("Selected directory is not a valid existing directory!");
                    return;
                }
                if (newPath.equals((Object)CppSearchPathPreferencePage.this.m_instSpecificDir)) {
                    LOGGER.debug("Path did not change - nothing to be done.");
                    return;
                }
                SearchPathEditInstSpecDirCommand command = new SearchPathEditInstSpecDirCommand(WorkbenchRegistry.getInstance().getProvider(), new SearchPathEditInstSpecDirCommand.ISearchPathEditInstSpecDirInteraction(){

                    public void warning(String message, String detailMessage) {
                        UserInterfaceAdapter.getInstance().warning(message, detailMessage);
                    }
                }, CppSearchPathPreferencePage.this.m_searchPathProviderManager, CppSearchPathPreferencePage.this.m_delta, CppSearchPathPreferencePage.this.m_instSpecificDir, newPath);
                CppSearchPathPreferencePage.this.m_instSpecificDir = newPath;
                InstSpecDirSearchPathValidator validator = (InstSpecDirSearchPathValidator)CppSearchPathPreferencePage.this.m_searchPathProviderManager.getValidator();
                validator.setInstSpecDir(CppSearchPathPreferencePage.this.m_instSpecificDir, true);
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
                if (command.getResult().isFailure()) {
                    UserInterfaceAdapter.getInstance().process(command.getResult());
                    return;
                }
                CppSearchPathPreferencePage.this.applyNewInstSpecificDefinitionsToMap(command.getDefinitions());
                CppSearchPathPreferencePage.this.m_InstallationSpecificTreeView.setInput(CppSearchPathPreferencePage.this.copyMap(CppSearchPathPreferencePage.this.m_instSpecificDefs));
            }
        });
        this.createButtonsPart(container, false);
        this.subscribeToCompilerDefinitionEvents();
        this.applyCompilerDefinitionsToControls();
        return container;
    }

    private void applyNewInstSpecificDefinitionsToMap(List<TFile> definitions) {
        this.m_instSpecificDefs.clear();
        this.m_instSpecificDefs.put(this.m_instSpecificDir, definitions);
    }

    protected void cancel() {
        if (!this.isModified()) {
            return;
        }
        UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question("Do you want to cancel and lose the changes made?", false);
        if (feedback == UserInterfaceAdapter.Feedback.CONFIRMED) {
            this.m_delta.reset();
            this.m_instSpecificDir = this.m_originalInstSpecDir;
            this.applyCompilerDefinitionsToControls();
        }
    }

    public boolean performCancel() {
        if (!this.isModified()) {
            return true;
        }
        UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question("Changes have been made that have not yet been persisted. Do you want to save these changes?", false);
        if (feedback == UserInterfaceAdapter.Feedback.CONFIRMED) {
            this.performApply();
        }
        return true;
    }

    protected void internPerformOk() {
        if (!this.isModified()) {
            return;
        }
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        ICPlusPlusInstallationProvider instSettingsProvider = (ICPlusPlusInstallationProvider)installation.getExtension(ICPlusPlusInstallationProvider.class);
        CppSearchPathSaveCommand command = new CppSearchPathSaveCommand(WorkbenchRegistry.getInstance().getProvider(), new CppSearchPathSaveCommand.ICppSearchPathSaveInteraction(){

            public void unableToSaveInformation(String message, String detailMessage) {
                UserInterfaceAdapter.getInstance().information(message, detailMessage);
            }

            public boolean saveWithWarnings(String message) {
                return UserInterfaceAdapter.getInstance().question(message, true) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        }, this.m_searchPathProviderManager, instSettingsProvider, this.m_delta, this.m_originalInstSpecDir, this.m_instSpecificDir);
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
        this.m_operationResult = command.getResult();
        if (this.m_operationResult.isFailure()) {
            UserInterfaceAdapter.getInstance().process(this.m_operationResult);
        } else {
            this.m_originalSearchPathDefs = command.hasBeenCancelled() ? this.m_delta.getOriginalMap() : this.m_delta.getNewMap();
        }
        this.m_originalInstSpecificDefs.clear();
        this.initializeData();
        this.applyCompilerDefinitionsToControls();
    }

    public boolean okToLeave() {
        if (this.isModified()) {
            UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question("There are unsaved changes that need to be saved and that might be lost if you change other preferences." + StringUtility.LINE_SEPARATOR + "Do you want to save before leaving this preference page?", false);
            if (feedback == UserInterfaceAdapter.Feedback.DISAGREED) {
                return true;
            }
            this.performApply();
            if (this.m_operationResult.isFailure()) {
                return false;
            }
        }
        return true;
    }

    private boolean isModified() {
        return this.m_searchPathControl.isEdited() || !this.m_originalInstSpecDir.equals((Object)this.m_instSpecificDir);
    }

    public void searchPathChanged(SearchPathDelta delta) {
        this.m_delta = delta;
        this.m_searchPathControl.setInput(this.copyMap(this.m_delta.getNewMap()), this.m_delta);
    }

    protected ISettingsDelta getDelta() {
        return this.m_delta;
    }

    protected OperationResult getOperationResult() {
        return this.m_operationResult;
    }

    private Map<TFile, List<TFile>> copyMap(Map<TFile, List<TFile>> map) {
        LinkedHashMap<TFile, List<TFile>> copy = new LinkedHashMap<TFile, List<TFile>>(map.size());
        for (Map.Entry<TFile, List<TFile>> entry : map.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    private void subscribeToCompilerDefinitionEvents() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<ConfigurationModifiedEvent>(ConfigurationModifiedEvent.class, (Object)this){

            public void handleEvent(ConfigurationModifiedEvent event) {
                if (!event.getLanguage().equals((Object)CPlusPlusLanguage.INSTANCE)) {
                    return;
                }
                if (event.getChanges().contains(ConfigurationModifiedEvent.Change.CONFIGURATION_CHANGED)) {
                    final InstallationCompilerDefinitonReadAllCommand command = new InstallationCompilerDefinitonReadAllCommand(WorkbenchRegistry.getInstance().getProvider());
                    UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

                        public void consume(CommandException exception) {
                            super.consume(exception);
                            if (exception == null) {
                                CppSearchPathPreferencePage.this.processReadAllCommandResult(command);
                                CppSearchPathPreferencePage.this.applyCompilerDefinitionsToControls();
                            }
                        }
                    });
                }
            }
        });
    }

    private void applyCompilerDefinitionsToControls() {
        if (this.m_InstallationSpecificTreeView != null) {
            if (this.m_InstallationSpecificTreeView.getControl().isDisposed()) {
                return;
            }
            this.m_InstallationSpecificTreeView.setInput(this.copyMap(this.m_originalInstSpecificDefs));
        }
        if (this.m_searchPathControl != null) {
            this.m_searchPathControl.setInput(this.copyMap(this.m_delta.getNewMap()), this.m_delta);
        }
    }

    private TreeViewer createTreeView(Composite container, int heightHint) {
        TreeViewer pathTree = new TreeViewer(container, 68354);
        SearchPathContentAndLabelProvider labelAndContentProvider = new SearchPathContentAndLabelProvider();
        pathTree.setContentProvider((IContentProvider)labelAndContentProvider);
        pathTree.setLabelProvider((IBaseLabelProvider)labelAndContentProvider);
        pathTree.setAutoExpandLevel(2);
        GridData gridDataOptions = new GridData(4, 4, true, true);
        gridDataOptions.widthHint = 350;
        gridDataOptions.heightHint = heightHint;
        pathTree.getTree().setLayoutData((Object)gridDataOptions);
        return pathTree;
    }
}

