/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.UpdateSystemBasedOnCapturingFilesCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICaptureExtension;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.StandardCommandInteractionWithResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class UpdateSystemFromCapturingCommandHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CPlusPlusCommandId.UPDATE_CAPTURING_BASED_SYSTEM;
    }

    public boolean isAvailable() {
        return super.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && WorkbenchRegistry.getInstance().isLanguageUsed((Language)CPlusPlusLanguage.INSTANCE);
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        ISoftwareSystemProvider provider;
        if (this.isAvailable(menuItem) && (provider = WorkbenchRegistry.getInstance().getProvider()).hasSoftwareSystem()) {
            return ((ICaptureExtension)provider.getInstallation().getExtension(ICaptureExtension.class)).canUpdateCapturingData(provider);
        }
        return false;
    }

    @Execute
    public void execute() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        StandardCommandInteractionWithResult interaction = new StandardCommandInteractionWithResult();
        UserInterfaceAdapter.getInstance().run((Command)new UpdateSystemBasedOnCapturingFilesCommand(provider, (ICommandInteractionWithResult)interaction));
    }
}

