/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusReportParsingProblemCommand;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.feedback.ReportParsingProblemDialog;
import com.hello2morrow.sonargraph.ui.standalone.commandhandler.ReportParsingInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.Shell;

public final class CPlusPlusReportParsingProblemHandler
extends CommandHandlerWithCorrespondingCommand {
    @Execute
    public void execute() {
        TFile logFile = CPlusPlusReportParsingProblemCommand.getLogFile();
        TFile diagnosticDir = CPlusPlusReportParsingProblemCommand.getDiagnosticsDir((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        OperationResultWithOutcome diagnosticFiles = CPlusPlusReportParsingProblemCommand.getDiagnosticsFiles((TFile)diagnosticDir);
        if (diagnosticFiles.isFailure()) {
            UserInterfaceAdapter.getInstance().process((OperationResult)diagnosticFiles);
            return;
        }
        if (((List)diagnosticFiles.getOutcome()).isEmpty()) {
            UserInterfaceAdapter.getInstance().information("No Diagnostic Files Present", "No files found indicating any C,C++ parsing problems.");
            return;
        }
        CPlusPlusReportParsingProblemDialog dialog = new CPlusPlusReportParsingProblemDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), logFile, (List)diagnosticFiles.getOutcome());
        if (dialog.open() == 0) {
            ReportParsingInteraction interaction = new ReportParsingInteraction((ReportParsingProblemDialog)dialog, logFile, diagnosticDir);
            CPlusPlusReportParsingProblemCommand command = new CPlusPlusReportParsingProblemCommand(WorkbenchRegistry.getInstance().getProvider(), (SendFeedbackCommand.IInteraction)interaction, new StandaloneProxySettingsProvider().getProxySettings(false));
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        return this.isAvailable(menuItem);
    }

    public ICommandId getCorrespondingCommandId() {
        return CPlusPlusCommandId.REPORT_PARSING_PROBLEM;
    }

    private class CPlusPlusReportParsingProblemDialog
    extends ReportParsingProblemDialog {
        public CPlusPlusReportParsingProblemDialog(Shell parentShell, TFile logFile, List<TFile> diagnosticFiles) {
            super(parentShell, logFile, diagnosticFiles);
        }

        protected String getBundleId() {
            return "com.hello2morrow.sonargraph.language.provider.cplusplus";
        }

        protected String getDefaultSubject() {
            return "C,C++ Parsing Problems";
        }
    }
}

