/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ProgressBarBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.IProjectAnalyzerProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class ScanSourcesForIncludesPage
extends StandardWizardPage {
    private final IProjectAnalyzerProvider m_analyzerProvider;
    private Label m_progressLabel;
    private ProgressBar m_progressBar;
    private Text m_directoryField;
    private Button m_cancelButton;
    private Button m_scanButton;
    private ProgressBarBasedWorkerContext m_workerContext;

    public ScanSourcesForIncludesPage(String pageName, IProjectAnalyzerProvider provider) {
        super(pageName, "Scanning C,C++ Sources For Include References");
        assert (provider != null) : "Parameter 'provider' of method 'ScanSourcesForIncludesPage' must not be null";
        this.m_analyzerProvider = provider;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.SCAN_FOR_INCLUDES_WIZARD_PAGE;
    }

    protected void createContent(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("C,C++ System Root Directory:");
        label1.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_directoryField = new Text(composite, 4);
        this.m_directoryField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_directoryField.setEditable(false);
        Label verticalGap = new Label(composite, 0);
        verticalGap.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_progressLabel = new Label(composite, 0);
        this.m_progressLabel.setText("Scan Progress:");
        this.m_progressBar = new ProgressBar(composite, 65792);
        this.m_progressBar.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        verticalGap = new Label(composite, 0);
        verticalGap.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_scanButton = new Button(composite, 8);
        this.m_scanButton.setText("Scan System");
        this.m_scanButton.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        this.m_scanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScanSourcesForIncludesPage.this.m_workerContext = new ProgressBarBasedWorkerContext(ScanSourcesForIncludesPage.this.m_progressBar, 20);
                ScanSourcesForIncludesPage.this.m_cancelButton.setEnabled(true);
                IProjectAnalyzer analyzer = ScanSourcesForIncludesPage.this.m_analyzerProvider.createProjectAnalyzer((IWorkerContext)ScanSourcesForIncludesPage.this.m_workerContext);
                if (!(ScanSourcesForIncludesPage.this.m_cancelButton.isDisposed() || ScanSourcesForIncludesPage.this.m_scanButton.isDisposed() || ScanSourcesForIncludesPage.this.m_progressBar.isDisposed())) {
                    ScanSourcesForIncludesPage.this.m_cancelButton.setEnabled(false);
                    ScanSourcesForIncludesPage.this.m_scanButton.setEnabled(analyzer == null);
                    ScanSourcesForIncludesPage.this.setPageComplete(analyzer != null);
                    ScanSourcesForIncludesPage.this.m_progressBar.setSelection(analyzer == null ? 0 : 100);
                    if (analyzer == null && !ScanSourcesForIncludesPage.this.m_workerContext.hasBeenCanceled()) {
                        ScanSourcesForIncludesPage.this.setErrorMessage("Could not find any C,C++ sources under the root directory");
                    } else {
                        ScanSourcesForIncludesPage.this.setErrorMessage(null);
                    }
                }
                ScanSourcesForIncludesPage.this.m_workerContext = null;
            }
        });
        this.m_cancelButton = new Button(composite, 8);
        this.m_cancelButton.setText("Cancel");
        this.m_cancelButton.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        this.m_cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScanSourcesForIncludesPage.this.m_workerContext != null && !ScanSourcesForIncludesPage.this.m_workerContext.hasBeenCanceled()) {
                    ScanSourcesForIncludesPage.this.m_workerContext.cancel();
                }
            }
        });
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.m_analyzerProvider.hasValidProjectAnalyzer()) {
                this.m_scanButton.setEnabled(false);
                this.m_cancelButton.setEnabled(false);
                this.m_progressBar.setSelection(100);
                this.setPageComplete(true);
            } else {
                this.m_progressBar.setSelection(0);
                this.m_scanButton.setEnabled(true);
                this.m_cancelButton.setEnabled(false);
                this.m_directoryField.setText(this.m_analyzerProvider.getRootDirectory().getNormalizedAbsolutePath());
                this.m_directoryField.setSelection(0, 0);
            }
        }
    }
}

