/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateManualCPlusPlusModuleCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.SystemAndModuleCreationData;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.CPlusPlusManualWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WarningWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class NewCPlusPlusModuleManualWizard
extends CPlusPlusManualWizard {
    private final ISoftwareSystemProvider m_softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();

    public NewCPlusPlusModuleManualWizard() {
        super("New C++ Module");
    }

    public void addPages() {
        InstCompilerDefinition activeCompilerDefinition = ((ICPlusPlusInstallationProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(ICPlusPlusInstallationProvider.class)).getActiveCompilerDefinition();
        if (activeCompilerDefinition == null) {
            this.addPage((SonargraphWizardPage)new WarningWizardPage("No Active Compiler Definition", "Before a C++ module can be created an active compiler definition must be configured on the preference pages."));
        } else if (activeCompilerDefinition.getIncludeDirectories().isEmpty()) {
            this.addPage((SonargraphWizardPage)new WarningWizardPage("Missing Include Directories", "The active compiler definition '" + activeCompilerDefinition.getName() + "' does not contain any include directories.\nPlease correct this first on the corresponding preference page."));
        } else {
            this.addModuleDefinitionPages();
            this.getModuleAssignmentPage().initExistingModuleNames();
        }
    }

    @Override
    protected Command createCommand(ISoftwareSystemProvider provider) {
        return new CreateManualCPlusPlusModuleCommand(this.m_softwareSystemProvider, (CreateManualCPlusPlusModuleCommand.IInteraction)new Interaction());
    }

    @Override
    protected String getCompilerDefinitionName() {
        return this.getInstallationProvider().getActiveCompilerDefinition().getName();
    }

    @Override
    protected IProjectAnalyzer createProjectAnalyzer(IWorkerContext workerContext, ICppImportExtension ext, List<TFile> systemIncludeDirectories, List<TFile> extraIncludeDirectories) {
        return ext.analyzeProject(workerContext, this.m_softwareSystemProvider.getSoftwareSystem(), this.getCompilerDefinitionName(), systemIncludeDirectories, extraIncludeDirectories);
    }

    @Override
    public TFile getRootDirectory() {
        return this.m_softwareSystemProvider.getSoftwareSystem().getDirectoryFile();
    }

    private class Interaction
    extends SaveCommandInteraction
    implements CreateManualCPlusPlusModuleCommand.IInteraction {
        private Interaction() {
            super(true);
        }

        public void processModuleCreationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean collect(SystemAndModuleCreationData data) {
            return NewCPlusPlusModuleManualWizard.this.collect(data);
        }
    }
}

