/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CxxConfigFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerDefinitionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SelectCxxConfigFilePage
extends CompilerDefinitionWizardPage {
    public static final String DIR = "DIR";
    private ValidatingPathWidget m_pathWidget;
    private final ICppImportExtension m_importer;
    private String m_basePath;

    public SelectCxxConfigFilePage(String pageName, Installation installation, CompilerDefinitionModel model) {
        super(pageName, "Select Sotograph Compiler Definition File (optional)", model);
        assert (installation != null) : "Parameter 'installation' of method 'SelectCxxconfFilePage' must not be null";
        this.m_importer = (ICppImportExtension)installation.getExtension(ICppImportExtension.class);
        this.m_basePath = this.getPreference(DIR);
    }

    protected void createContent(Composite parent) {
        Composite compositeWrapper = new Composite(parent, 0);
        compositeWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        compositeWrapper.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithMargin());
        Label explanationLabel = new Label(compositeWrapper, 64);
        explanationLabel.setText("Path to Sotograph compiler definition file");
        explanationLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.m_pathWidget = new ValidatingPathWidget(compositeWrapper, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    TFile selectedFile = input.getNormalizedFile();
                    OperationResultWithOutcome result = SelectCxxConfigFilePage.this.m_importer.importCxxConfigFile(selectedFile);
                    SelectCxxConfigFilePage.this.m_basePath = input.getParentFile().getAbsolutePath();
                    SelectCxxConfigFilePage.this.putPreference(SelectCxxConfigFilePage.DIR, SelectCxxConfigFilePage.this.m_basePath);
                    if (result.isSuccess()) {
                        CxxConfigFile configFile = (CxxConfigFile)result.getOutcome();
                        SelectCxxConfigFilePage.this.m_model.init(configFile);
                    } else {
                        UserInterfaceAdapter.getInstance().error("Error", (String)result.getErrorMessages().get(0));
                    }
                }
            }
        }, (IPathValidator)new StandardFilePathValidator((IFileType)CPlusPlusFileType.CXX_CONF, true, true), 5, null, false);
        this.m_pathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    public void setVisible(boolean visible) {
        if (visible && this.m_basePath != null) {
            this.m_pathWidget.setBasePath(new TFile(this.m_basePath));
        }
        super.setVisible(visible);
    }
}

