/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.views.parserlog;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.views.CppViewId;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.views.parserlog.ParserIssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public final class ParserLogView
extends WorkbenchView {
    private PropertyTableViewer<Issue> m_elementsTableViewer;
    private final ParserIssueBeanAdapter m_issueBeanAdapter = new ParserIssueBeanAdapter();
    private final IssueFilter m_filter = new IssueFilter((IStandardEnumeration[])new CPlusPlusIssueId[]{CPlusPlusIssueId.CPP_PARSER_ERROR, CPlusPlusIssueId.INTERNAL_ERROR});
    private final SelectionListener m_listener = new SelectionListener();

    public IViewId getViewId() {
        return CppViewId.PARSER_LOG_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected void createViewContent(Composite viewContentArea) {
        this.m_elementsTableViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)this.m_issueBeanAdapter, "fileName", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_elementsTableViewer.addColumn("File Name", "fileName", "fileName", "fileNameImage", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementsTableViewer.addColumn("Line", "line", "line", null, 50, PropertyTableViewer.ColumnType.NUMBER);
        this.m_elementsTableViewer.addColumn("Severity", "severity", "severity", null, 50, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementsTableViewer.addColumn("Message", "message", "message", null, 500, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementsTableViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this.m_listener);
    }

    private void show() {
        assert (this.m_filter != null) : "'m_filter' of method 'show' must not be null";
        assert (this.m_elementsTableViewer != null) : "'m_propertyTableViewer' of method 'show' must not be null";
        this.m_elementsTableViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this.m_listener);
        this.m_elementsTableViewer.setRedraw(false);
        ArrayList allIssues = new ArrayList();
        if (this.getSoftwareSystem() != null) {
            allIssues.addAll(this.getSoftwareSystem().getCurrentModel().getIssueList((IIssueFilter)this.m_filter, true).getIssues());
        }
        this.m_elementsTableViewer.showData(allIssues);
        this.m_elementsTableViewer.setRedraw(true);
        this.m_elementsTableViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this.m_listener);
    }

    public List<Control> getControlsForInteraction() {
        return new ArrayList<Table>(Arrays.asList(this.m_elementsTableViewer.getTable()));
    }

    public List<Element> getSelectedElements() {
        assert (this.m_elementsTableViewer != null) : "'m_elementsTableViewer' of method 'getSelected' must not be null";
        IStructuredSelection selection = this.m_elementsTableViewer.getSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        for (Object next : selection.toList()) {
            if (!(next instanceof Element)) continue;
            selected.add((Element)next);
        }
        return selected;
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.show();
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        super.softwareSystemModified(modification, restoredFromHistory);
        this.show();
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.show();
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ParserLogView.this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)event.getSelection());
        }
    }
}

