/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.system.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.EditManualModuleSettingsCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleOrSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsDelta;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.MapBackedCombo;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.ElementSelectionWidget;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.system.settings.CompilerDefinitionLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompilerOptionsDialog
extends StandardDialog
implements SettingsDelta.IChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerOptionsDialog.class);
    private MapBackedCombo<InstCompilerDefinition> m_comboDefinitions;
    private Button m_buttonResolve;
    private ValidatingTextWidget m_textOptions;
    private Text m_textResultingOptions;
    private SelectionListener m_definitionSelectionAdapter;
    private SelectionListener m_resolveOptionsAdapter;
    private Map<String, InstCompilerDefinition> m_definitions;
    private Map<String, SettingsDelta> m_settingsDeltaMap;
    private SettingsDelta m_systemSettingsDelta;
    private SettingsDelta m_currentSettingsDelta;
    private InstCompilerDefinition m_currentDefinition;
    private Label m_labelDefinitionDescription;
    private ValidatingTextWidget m_sourceFileExtensions;
    private Label m_basePathLabel;
    private ValidatingPathWidget m_basePathForIncludes;
    private ElementSelectionWidget m_moduleSelectionWidget;
    private final String m_activeDefinitionName;
    private final boolean m_isReadOnly;

    public CompilerOptionsDialog(Shell parentShell, String activeDefinitionName, boolean isReadOnly) {
        super(parentShell, "C++ Compiler Options" + (isReadOnly ? " - Read Only" : ""));
        this.m_activeDefinitionName = activeDefinitionName;
        this.m_isReadOnly = isReadOnly;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.COMPILER_OPTIONS_DIALOG;
    }

    public void setDeltaMap(Map<String, SettingsDelta> moduleSettingsDeltaMap) {
        assert (moduleSettingsDeltaMap != null) : "Parameter 'moduleSettingsDeltaMap' of method 'CompilerOptionsDialog' must not be null";
        this.m_settingsDeltaMap = moduleSettingsDeltaMap;
        if (!this.m_settingsDeltaMap.isEmpty()) {
            this.m_currentSettingsDelta = this.m_systemSettingsDelta = moduleSettingsDeltaMap.values().iterator().next();
        }
    }

    protected void fillDialogArea(Composite parent) {
        assert (this.m_settingsDeltaMap != null) : "'m_moduleSettingsDeltaMap' in method 'fillDialogArea' must not be null";
        if (this.m_settingsDeltaMap.isEmpty()) {
            Label introLabel = new Label(parent, 0);
            introLabel.setText("There are currently no manual C++ modules to configure.");
            return;
        }
        ScrolledComposite m_scrolledComposite = new ScrolledComposite(parent, 768);
        m_scrolledComposite.setExpandHorizontal(true);
        m_scrolledComposite.setExpandVertical(true);
        m_scrolledComposite.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithMargin());
        m_scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sashForm = new SashForm((Composite)m_scrolledComposite, 256);
        m_scrolledComposite.setContent((Control)sashForm);
        sashForm.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createModuleSelectionWidgets((Composite)sashForm);
        Composite details = new Composite((Composite)sashForm, 0);
        details.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        details.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createBasicOptionWidgets(details);
        Group compilerOptionsGroup = this.createCompilerSelectionWidgets(details);
        this.createCompilerDetailsWidgets((Composite)compilerOptionsGroup);
        sashForm.setWeights(new int[]{25, 75});
    }

    private void createBasicOptionWidgets(Composite content) {
        Group group = new Group(content, 0);
        group.setText("Basic Options");
        group.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2));
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_basePathLabel = new Label((Composite)group, 0);
        this.m_basePathLabel.setText("Base directory for include options (-I), relative to system:");
        TFile systemBaseDir = this.getSystemBaseDir();
        this.m_basePathForIncludes = new ValidatingPathWidget((Composite)group, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    LOGGER.debug("Input received: " + input.getPath());
                    CompilerOptionsDialog.this.m_currentSettingsDelta.setBasePathForIncludes(input);
                    CompilerOptionsDialog.this.resolveOptionsText();
                }
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ), 2, systemBaseDir.getParentFile(), true, systemBaseDir.getParentFile());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.m_basePathForIncludes.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText("Source file extensions (comma separated, e.g. '.cpp, .c')");
        this.m_sourceFileExtensions = new ValidatingTextWidget((Composite)group, (ITextValidator)new CppSourceFileExtensions.Validator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (input != null) {
                    CompilerOptionsDialog.this.m_currentSettingsDelta.setCppSourceFileExtensions(input);
                }
            }
        });
        this.m_sourceFileExtensions.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.m_isReadOnly) {
            this.m_basePathForIncludes.setEnabled(false);
            this.m_sourceFileExtensions.setEnabled(false);
        }
    }

    private Group createCompilerSelectionWidgets(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Compiler Options");
        group.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumWidth = 425;
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        SwtUtility.createOneCellLabel((Composite)group, (String)"Select Compiler:", (int)128);
        this.m_comboDefinitions = new MapBackedCombo((Composite)group, 780, (MapBackedCombo.ILabelProvider)new CompilerDefinitionLabelProvider(this.m_activeDefinitionName != null ? this.m_activeDefinitionName : ""), true);
        this.m_comboDefinitions.setLayoutData((Object)new GridData(4, 1, true, false));
        SwtUtility.createOneCellLabel((Composite)group, (String)"Description:", (int)128);
        this.m_labelDefinitionDescription = SwtUtility.createOneCellLabel((Composite)group, (String)"", (int)128);
        this.m_labelDefinitionDescription.setLayoutData((Object)new GridData(4, 1, true, false));
        this.m_definitionSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo source = (Combo)event.getSource();
                String label = source.getItem(source.getSelectionIndex());
                InstCompilerDefinition definition = (InstCompilerDefinition)CompilerOptionsDialog.this.m_comboDefinitions.getItemForLabel(label);
                if (!$assertionsDisabled && definition == null) {
                    throw new AssertionError((Object)("Selected definition '" + label + "' could not be resolved!"));
                }
                CompilerOptionsDialog.this.applyCurrentDefinition(definition);
            }
        };
        return group;
    }

    private void createModuleSelectionWidgets(Composite content) {
        Group groupModules = new Group(content, 0);
        groupModules.setText("Select Module");
        groupModules.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithMargin());
        groupModules.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_moduleSelectionWidget = new ElementSelectionWidget((Composite)groupModules, 65536);
        this.m_moduleSelectionWidget.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 200;
        this.m_moduleSelectionWidget.setLayoutData((Object)gridData);
        this.m_moduleSelectionWidget.getTreeViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_moduleSelectionWidget.addSelectionListener(new ElementSelectionWidget.IListener(){

            public void elementSelected(NamedElement element) {
                LOGGER.debug("Selected element: " + element.getName());
                CompilerOptionsDialog.this.m_currentSettingsDelta = CompilerOptionsDialog.this.m_settingsDeltaMap.values().stream().filter(d -> d.getOriginal() == element).findFirst().orElse(null);
                if (!$assertionsDisabled && CompilerOptionsDialog.this.m_currentSettingsDelta == null) {
                    throw new AssertionError();
                }
                CompilerOptionsDialog.this.showCurrentDelta();
            }
        });
    }

    private void createCompilerDetailsWidgets(Composite parent) {
        Composite detailsComposite = new Composite(parent, 0);
        detailsComposite.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        detailsComposite.setLayoutData((Object)gridData);
        SwtUtility.createFillerForGridLayoutCell((Composite)detailsComposite, (int)2, (int)1);
        SashForm form = new SashForm(detailsComposite, 256);
        form.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        Group optionsGroup = new Group((Composite)form, 0);
        optionsGroup.setText("Compiler Options (Groovy Template)");
        optionsGroup.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithMargin());
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_textOptions = new ValidatingTextWidget((Composite)optionsGroup, new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                ValidationResult result = new ValidationResult(true);
                if (newInput == null) {
                    return result;
                }
                CompilerOptionsDialog.this.m_currentSettingsDelta.setCompilerOptionsText(CompilerOptionsDialog.this.m_currentDefinition.getName(), StringUtility.harmonizeNewLineBreaks((String)newInput));
                ModuleOrSystemCompilerOptions options = CompilerOptionsDialog.this.m_currentSettingsDelta.getCompilerOptions(CompilerOptionsDialog.this.m_currentDefinition.getName());
                return new ModuleOrSystemCompilerOptions.Validator().isValid(options, false);
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
            }
        }, null, false, true, 0);
        this.m_textOptions.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_buttonResolve = new Button((Composite)optionsGroup, 0);
        this.m_buttonResolve.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.resolvetemplate", new Object[0]));
        this.m_buttonResolve.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_textResultingOptions = SwtUtility.createTextFieldInGroup((Composite)form, (String)"Resulting Options", (int)200, (int)250, (int)1, (int)1);
        this.m_textResultingOptions.setEditable(false);
        this.m_resolveOptionsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerOptionsDialog.this.resolveOptionsText();
            }
        };
        if (this.m_isReadOnly) {
            this.m_textOptions.setEnabled(false);
            this.m_buttonResolve.setEnabled(false);
        }
    }

    private void removeSelectionListeners() {
        this.m_comboDefinitions.removeSelectionListener(this.m_definitionSelectionAdapter);
        this.m_textOptions.setEnabled(false);
        this.m_buttonResolve.removeSelectionListener(this.m_resolveOptionsAdapter);
    }

    private void addSelectionListeners() {
        this.m_comboDefinitions.addSelectionListener(this.m_definitionSelectionAdapter);
        this.m_textOptions.setEnabled(!this.m_isReadOnly);
        this.m_buttonResolve.addSelectionListener(this.m_resolveOptionsAdapter);
    }

    protected void applyData() {
        if (this.m_settingsDeltaMap.isEmpty()) {
            return;
        }
        this.removeSelectionListeners();
        this.m_moduleSelectionWidget.setInput(this.createSelectionLabelsMap());
        this.m_definitions = this.getCompilerDefinitions();
        this.m_comboDefinitions.setInput(this.m_definitions.values());
        this.addSelectionListeners();
        String definitionName = "Any Compiler";
        InstCompilerDefinition definition = this.m_definitions.get("Any Compiler");
        this.m_comboDefinitions.selectElement((Object)definition);
        this.applyCurrentDefinition(definition);
    }

    private void applyCurrentDefinition(InstCompilerDefinition definition) {
        this.m_currentDefinition = this.m_definitions.get(definition.getName());
        this.m_labelDefinitionDescription.setText(this.m_currentDefinition.getDescription());
        this.showCurrentDelta();
    }

    private void showCurrentDelta() {
        this.removeSelectionListeners();
        CppSourceFileExtensions cppExt = (CppSourceFileExtensions)this.m_currentSettingsDelta.getModified().getUniqueChild(CppSourceFileExtensions.class);
        if (cppExt == null) {
            cppExt = (CppSourceFileExtensions)this.m_systemSettingsDelta.getModified().getUniqueChild(CppSourceFileExtensions.class);
        }
        if (cppExt != null) {
            this.m_sourceFileExtensions.setText(cppExt.toString());
        } else {
            this.m_sourceFileExtensions.setText(new CppSourceFileExtensions(null).toString());
        }
        BasePathForIncludes bpi = (BasePathForIncludes)this.m_currentSettingsDelta.getModified().getUniqueChild(BasePathForIncludes.class);
        this.m_basePathForIncludes.setEnabled(bpi != null);
        this.m_basePathLabel.setVisible(bpi != null);
        this.m_basePathForIncludes.setVisible(bpi != null);
        if (bpi != null) {
            this.m_basePathForIncludes.setPath(((BasePathForIncludes)this.m_currentSettingsDelta.getModified().getUniqueChild(BasePathForIncludes.class)).getName());
        }
        this.addSelectionListeners();
        this.resolveOptionsText();
    }

    private Map<String, InstCompilerDefinition> getCompilerDefinitions() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        ICPlusPlusInstallationProvider settingsProvider = (ICPlusPlusInstallationProvider)installation.getExtension(ICPlusPlusInstallationProvider.class);
        return settingsProvider.listRelevantDefinitions(true);
    }

    private void resolveOptionsText() {
        String definitionId = this.m_currentDefinition.getName();
        this.m_textOptions.setText(this.m_currentSettingsDelta.getCompilerOptionsText(definitionId));
        this.m_textResultingOptions.setText(this.m_currentSettingsDelta.getResolvedCompilerOptionsText(definitionId));
    }

    public boolean hasValidData() {
        if (this.m_activeDefinitionName == null) {
            return true;
        }
        for (SettingsDelta delta : this.m_settingsDeltaMap.values()) {
            ModuleOrSystemCompilerOptions options = (ModuleOrSystemCompilerOptions)delta.getModified().getUniqueChild((NamedElement.IFilter)new NameFilter(this.m_activeDefinitionName), ModuleOrSystemCompilerOptions.class);
            if (options == null) {
                return false;
            }
            Result result = options.validate(false, null);
            if (!result.isFailure()) continue;
            return false;
        }
        return true;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected Point getPreferredSize() {
        return new Point(800, 600);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (!this.m_settingsDeltaMap.isEmpty()) {
            this.removeSelectionListeners();
        }
        super.widgetDisposed(event);
    }

    private Map<NamedElement, String> createSelectionLabelsMap() {
        LinkedHashMap<NamedElement, String> moduleToLabelsMap = new LinkedHashMap<NamedElement, String>();
        for (Map.Entry<String, SettingsDelta> entry : this.m_settingsDeltaMap.entrySet()) {
            StringBuilder label = new StringBuilder(entry.getKey());
            if (entry.getValue().isModified()) {
                label.append("(*)");
            }
            moduleToLabelsMap.put(entry.getValue().getOriginal(), label.toString());
        }
        return moduleToLabelsMap;
    }

    private TFile getSystemBaseDir() {
        TFile systemBaseDir = ((Files)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getUniqueExistingChild(Files.class)).getSoftwareSystemFile().getFile().getParentFile();
        return systemBaseDir;
    }

    protected void okPressed() {
        EditManualModuleSettingsCommand command = new EditManualModuleSettingsCommand(WorkbenchRegistry.getInstance().getProvider(), new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

            public void process(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }

            public INavigationState getNavigationState() {
                return ViewNavigationManager.getInstance().getCurrentNavigationState();
            }
        }, this.m_settingsDeltaMap);
        UserInterfaceAdapter.getInstance().run((Command)command);
        super.okPressed();
    }

    protected void cancelPressed() {
        boolean unsavedModificationExists = this.isModified();
        if (unsavedModificationExists && UserInterfaceAdapter.Feedback.CONFIRMED != UserInterfaceAdapter.getInstance().question("There are unsaved modifications, do you really want to cancel?", false)) {
            return;
        }
        for (SettingsDelta delta : this.m_settingsDeltaMap.values()) {
            delta.dispose();
        }
        super.cancelPressed();
    }

    public void notifyChange(boolean isModified) {
        this.getButton(0).setEnabled(this.hasValidData() && this.isModified());
        this.m_moduleSelectionWidget.disableListeners();
        this.m_moduleSelectionWidget.setInput(this.createSelectionLabelsMap());
        this.m_moduleSelectionWidget.enableListeners();
    }

    private boolean isModified() {
        for (SettingsDelta delta : this.m_settingsDeltaMap.values()) {
            if (!delta.isModified()) continue;
            return true;
        }
        return false;
    }
}

