/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.settings.ConfigurationLevel;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsCallback;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionDelta;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidatingTabItemWidget;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.DefinitionTabItem;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

abstract class CompilerDefinitionGroovyTemplateTabItem
extends DefinitionTabItem<GroovyTemplateElement> {
    private static final int HEIGTH_HINT = 200;
    private static final int WIDTH_HINT = 200;
    private final String m_introText;
    private final String m_sectionName;
    private Text m_textTemplate;
    private Text m_textResolved;
    private Text m_textError;
    private Button m_buttonResolve;
    private SelectionAdapter m_resolveTemplateAdapter;
    private ModifyListener m_modifyListenerTemplate;

    public CompilerDefinitionGroovyTemplateTabItem(String sectionName, String title, String introText, TabFolder parent, ISettingsCallback callback) {
        super(title, parent, new GroovyTemplateValidator(), null, callback);
        assert (sectionName != null && sectionName.length() > 0) : "Parameter 'sectionName' of method 'GroovyTemplateItem' must not be empty";
        assert (introText != null && introText.length() > 0) : "Parameter 'introText' of method 'GroovyTemplateItem' must not be empty";
        this.m_sectionName = sectionName;
        this.m_introText = introText;
    }

    public Composite createTabItemContent(TabFolder folder) {
        Composite container = new Composite((Composite)folder, 0);
        GridLayout gridLayoutContainer = new GridLayout(1, true);
        gridLayoutContainer.marginTop = 4;
        gridLayoutContainer.marginBottom = 4;
        gridLayoutContainer.verticalSpacing = 0;
        gridLayoutContainer.marginWidth = 4;
        container.setLayout((Layout)gridLayoutContainer);
        container.setBackground(folder.getBackground());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sash = new SashForm(container, 256);
        sash.setSashWidth(5);
        GridLayout gridLayoutSash = new GridLayout(1, true);
        gridLayoutSash.marginTop = 4;
        gridLayoutSash.marginBottom = 0;
        gridLayoutSash.horizontalSpacing = 4;
        gridLayoutSash.verticalSpacing = 0;
        gridLayoutSash.marginWidth = 4;
        sash.setLayout((Layout)gridLayoutSash);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite left = new Composite((Composite)sash, 0);
        left.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        Label intro = new Label(left, 0);
        intro.setText(this.m_introText);
        this.m_textTemplate = SwtUtility.createTextFieldForGridLayout((Composite)left, (boolean)true, (int)0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        this.m_textTemplate.setLayoutData((Object)gridData);
        this.m_modifyListenerTemplate = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                InstCompilerDefinition modified = CompilerDefinitionGroovyTemplateTabItem.this.getDelta().getModified();
                if (modified == null) {
                    return;
                }
                InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(modified);
                builder.processOptions(CompilerDefinitionGroovyTemplateTabItem.this.m_sectionName, ((Text)event.getSource()).getText());
                CompilerDefinitionGroovyTemplateTabItem.this.notifyChanges();
            }
        };
        this.m_buttonResolve = new Button(left, 0);
        this.m_buttonResolve.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.resolvetemplate", new Object[0]));
        this.m_buttonResolve.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_resolveTemplateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilerDefinitionGroovyTemplateTabItem.this.resolveTemplateText();
            }
        };
        Composite right = new Composite((Composite)sash, 0);
        right.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        Label resolved = new Label(right, 0);
        resolved.setText("Resolved Template");
        this.m_textResolved = new Text(right, 2826);
        this.m_textResolved.setLayoutData((Object)GridDataFactory.copyData((GridData)gridData));
        this.m_textResolved.setEditable(false);
        Composite bottom = new Composite(container, 0);
        bottom.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        bottom.setLayoutData((Object)new GridData(4, 4, true, true));
        Label error = new Label(bottom, 0);
        error.setText("Error Info");
        this.m_textError = new Text(bottom, 2826);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 50;
        this.m_textError.setLayoutData((Object)layoutData);
        this.addListeners();
        return container;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_buttonResolve.setEnabled(isEnabled);
        this.m_textTemplate.setEditable(isEnabled);
    }

    protected void resolveTemplateText() {
        ValidationResult result;
        GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)this.getDelta().getModified(), this.m_sectionName, this.m_textTemplate.getText());
        String resolvedTemplateText = template.getResolvedText();
        if (template.getErrorMessage() != null) {
            String wrapString = StringUtility.wrapString((String)template.getErrorMessage(), (int)70, (char[])new char[]{':'});
            this.m_textError.setText(wrapString);
            this.m_textResolved.setText("");
        }
        if ((result = this.validate(template)).isFailure()) {
            if (template.getErrorMessage() == null) {
                this.m_textError.setText(StringUtility.concat((Collection)result.getErrors(), (String)StringUtility.LINE_SEPARATOR));
                this.m_textResolved.setText(resolvedTemplateText);
            }
        } else {
            this.m_textResolved.setText(resolvedTemplateText);
            this.m_textError.setText("");
        }
    }

    protected Text getTemplateTextField() {
        return this.m_textTemplate;
    }

    @Override
    protected final void applyDeltaToWidgets(InstCompilerDefinitionDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'applyDeltaToWidgets' must not be null";
        InstCompilerDefinition modified = delta.getModified();
        if (modified == null) {
            return;
        }
        InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(modified);
        String text = this.getTemplateText(builder);
        this.getTemplateTextField().setText(text);
        this.resolveTemplateText();
    }

    protected abstract String getTemplateText(InstCompilerDefinitionBuilder var1);

    @Override
    public void clearWidgets() {
        this.m_textTemplate.setText("");
        this.m_textResolved.setText("");
    }

    @Override
    public void addListeners() {
        this.m_buttonResolve.addSelectionListener((SelectionListener)this.m_resolveTemplateAdapter);
        this.m_textTemplate.addModifyListener(this.m_modifyListenerTemplate);
    }

    @Override
    public void removeListeners() {
        if (!this.m_buttonResolve.isDisposed()) {
            this.m_buttonResolve.removeSelectionListener((SelectionListener)this.m_resolveTemplateAdapter);
        }
        if (!this.m_textTemplate.isDisposed()) {
            this.m_textTemplate.removeModifyListener(this.m_modifyListenerTemplate);
        }
    }

    private static class GroovyTemplateValidator
    implements ValidatingTabItemWidget.IValidator<GroovyTemplateElement> {
        private GroovyTemplateValidator() {
        }

        public ValidationResult validate(GroovyTemplateElement template) {
            InstCompilerDefinition definition;
            CompilerOptions options;
            assert (template != null) : "Parameter 'template' of method 'validate' must not be null";
            ValidationResult result = new ValidationResult(true);
            if (template.getErrorMessage() != null) {
                result.addError("Groovy template contains errors");
            }
            if ((options = (CompilerOptions)(definition = (InstCompilerDefinition)template.getParent(InstCompilerDefinition.class, new Class[0])).getUniqueChild((NamedElement.IFilter)new NameFilter(template.getName()), CompilerOptions.class)) == null) {
                return result;
            }
            Result optionsResult = options.validate(false, ConfigurationLevel.INSTALLATION);
            if (!optionsResult.getErrorMessage().isEmpty()) {
                result.addError(optionsResult.getErrorMessage());
            }
            return result;
        }
    }
}

