/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.AssignUnboundComponentsToModuleCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.IComponentAssignmentProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NamedElementSelectionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class AssignComponentsCommandHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CPlusPlusCommandId.ASSIGN_UNBOUND_COMPONENTS;
    }

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return true;
            }
        };
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        ISoftwareSystemProvider provider;
        if (selection != null && this.isAvailable() && (provider = WorkbenchRegistry.getInstance().getProvider()).hasSoftwareSystem()) {
            return !((IComponentAssignmentProvider)provider.getSoftwareSystem().getExtension(IComponentAssignmentProvider.class)).getAssignableComponents(selection.getElements()).isEmpty();
        }
        return false;
    }

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        Interaction interaction = new Interaction(((IComponentAssignmentProvider)provider.getSoftwareSystem().getExtension(IComponentAssignmentProvider.class)).getAssignableComponents(selection.getElements()));
        UserInterfaceAdapter.getInstance().run((Command)new AssignUnboundComponentsToModuleCommand(WorkbenchRegistry.getInstance().getProvider(), (AssignUnboundComponentsToModuleCommand.IInteraction)interaction));
    }

    private static final class Interaction
    implements AssignUnboundComponentsToModuleCommand.IInteraction {
        private final List<CppComponent> m_selection;

        private Interaction(List<CppComponent> selection) {
            assert (selection != null && !selection.isEmpty()) : "Parameter 'selection' of method 'Interaction' must not be empty";
            this.m_selection = selection;
        }

        public INavigationState getNavigationState() {
            return ViewNavigationManager.getInstance().getCurrentNavigationState();
        }

        public void processOperationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean collect(final AssignUnboundComponentsToModuleCommand.AssignUnboundComponentsData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setComponents(this.m_selection);
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            final IComponentAssignmentProvider cap = (IComponentAssignmentProvider)provider.getSoftwareSystem().getExtension(IComponentAssignmentProvider.class);
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    NamedElementSelectionDialog dialog = new NamedElementSelectionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Select Target Module", cap.getValidTargetModules());
                    int reply = dialog.open();
                    if (reply == 0) {
                        data.setModule((CPlusPlusModule)dialog.getSelection());
                    }
                }
            });
            return data.hasModule();
        }
    }
}

