/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm;

import com.hello2morrow.sonargraph.scm.ConfigurationException;
import com.hello2morrow.sonargraph.scm.ICommitRetriever;
import com.hello2morrow.sonargraph.scm.ICommitRetrieverFactory;
import com.hello2morrow.sonargraph.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.sonargraph.scm.RetrieveException;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmManager {
    public static final String NO_SCM = "No SCM System";
    public static final String AUTO = "Auto Detect";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmManager.class);
    private static final String AUTO_KEY = "scm.auto";
    private static final String AUTO_DETECTION_DONE = "scm.auto.done";
    private static ScmManager s_instance;
    private final Map<String, ICommitRetrieverFactory> m_scmDrivers = new THashMap();

    private ScmManager() {
        LOGGER.debug("[" + String.valueOf(this) + "] Instantiated");
        assert (s_instance == null) : "'s_instance' of method 'SonargraphPluginManager' must be null";
    }

    public static ScmManager getInstance() {
        if (s_instance == null) {
            s_instance = new ScmManager();
        }
        return s_instance;
    }

    public boolean isAvailable(String scmName) {
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'isAvailable' must not be empty";
        return this.m_scmDrivers.containsKey(scmName);
    }

    public void addCommitRetrieverFactory(ICommitRetrieverFactory factory) {
        assert (factory != null) : "Parameter 'factory' of method 'addCommitRetrieverFactory' must not be null";
        this.m_scmDrivers.put(factory.getScmName(), factory);
    }

    public void removeCommitRetrieverFactory(ICommitRetrieverFactory factory) {
        assert (factory != null) : "Parameter 'factory' of method 'removeCommitRetrieverFactory' must not be null";
        this.m_scmDrivers.remove(factory.getScmName());
    }

    public Collection<String> getAvailableScmDrivers() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(AUTO);
        result.addAll(this.m_scmDrivers.keySet());
        return result;
    }

    private ICommitRetrieverFactory autoDetectScm(IScmDataAndConfigurationProvider scmDataAndConfigProvider) {
        if (scmDataAndConfigProvider.retrieveProperty(AUTO_DETECTION_DONE, Boolean.class) != null) {
            return scmDataAndConfigProvider.retrieveProperty(AUTO_KEY, ICommitRetrieverFactory.class);
        }
        ICommitRetrieverFactory factory = null;
        for (ICommitRetrieverFactory f : this.m_scmDrivers.values()) {
            if (!f.autoDetect(scmDataAndConfigProvider)) continue;
            scmDataAndConfigProvider.storeProperty(AUTO_KEY, f);
            factory = f;
            break;
        }
        scmDataAndConfigProvider.storeProperty(AUTO_DETECTION_DONE, Boolean.TRUE);
        return factory;
    }

    public List<File> getScmRootDirectories(IScmDataAndConfigurationProvider scmDataAndConfigProvider) {
        List<File> result = Collections.emptyList();
        try {
            ICommitRetrieverFactory factory = this.autoDetectScm(scmDataAndConfigProvider);
            if (factory != null) {
                result = factory.detectRepositoryRoots(scmDataAndConfigProvider);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return result;
    }

    public boolean canRun(String scmName, IScmDataAndConfigurationProvider scmDataAndConfigProvider) {
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'canRun' must not be empty";
        assert (scmDataAndConfigProvider != null) : "Parameter 'scmDataAndConfigProvider' of method 'canRun' must not be null";
        if (scmName.equals(AUTO)) {
            return this.autoDetectScm(scmDataAndConfigProvider) != null;
        }
        return this.m_scmDrivers.get(scmName) != null;
    }

    public ICommitRetriever getCommitRetriever(String scmName, IScmDataAndConfigurationProvider scmDataAndConfigProvider) throws ConfigurationException, RetrieveException {
        ICommitRetrieverFactory factory;
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'getCommitRetriver' must not be empty";
        assert (scmDataAndConfigProvider != null) : "Parameter 'scmDataAndConfigProvider' of method 'getCommitRetriver' must not be null";
        if (scmName.equals(AUTO)) {
            factory = this.autoDetectScm(scmDataAndConfigProvider);
            if (factory == null) {
                throw new ConfigurationException("Unable to auto-detect SCM system");
            }
        } else {
            factory = this.m_scmDrivers.get(scmName);
            if (factory == null) {
                throw new ConfigurationException("No driver for SCM '" + scmName + "'");
            }
        }
        return factory.create(scmDataAndConfigProvider);
    }
}

