/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.scm.DiffMode;
import java.io.IOException;

public final class Diff
implements IPersistable {
    private static final String MODE = "mode";
    private static final String PATH = "path";
    private static final String ORIGINAL_PATH = "originalPath";
    private static final String ADDED = "added";
    private static final String REMOVED = "removed";
    private DiffMode m_mode;
    private String m_path;
    private String m_originalPath;
    private int m_addedLines;
    private int m_removedLines;

    public Diff() {
    }

    public Diff(DiffMode mode, String path, String originalPath, int addedLines, int removedLines) {
        assert (mode != null) : "Parameter 'mode' of method 'Diff' must not be null";
        this.m_mode = mode;
        this.m_path = path;
        this.m_originalPath = mode != DiffMode.MODIFIED ? originalPath : null;
        this.m_addedLines = addedLines;
        this.m_removedLines = removedLines;
    }

    public DiffMode getMode() {
        return this.m_mode;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getOriginalPath() {
        return this.m_originalPath;
    }

    public int getAddedLines() {
        return this.m_addedLines;
    }

    public int getRemovedLines() {
        return this.m_removedLines;
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeOther(MODE, (Object)this.m_mode);
        writer.writeString(PATH, this.m_path);
        writer.writeString(ORIGINAL_PATH, this.m_originalPath);
        writer.writeInt(ADDED, this.m_addedLines);
        writer.writeInt(REMOVED, this.m_removedLines);
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        reader.readOther(MODE, DiffMode.class, m -> {
            DiffMode diffMode = this.m_mode = m;
        });
        this.m_path = reader.readString(PATH);
        this.m_originalPath = reader.readString(ORIGINAL_PATH);
        Integer added = reader.readInt(ADDED);
        if (added == null) {
            throw new RestoreException("Unknown attribute 'added'");
        }
        this.m_addedLines = added;
        Integer removed = reader.readInt(REMOVED);
        if (removed == null) {
            throw new RestoreException("Unknown attribute 'removed'");
        }
        this.m_removedLines = removed;
        ((ICommit)reader.getCurrentParent(ICommit.class)).addChange(this);
    }

    public boolean isEqualTo(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Diff other = (Diff)obj;
        if (this.m_addedLines != other.m_addedLines) {
            return false;
        }
        if (this.m_mode != other.m_mode) {
            return false;
        }
        if (this.m_originalPath == null ? other.m_originalPath != null : !this.m_originalPath.equals(other.m_originalPath)) {
            return false;
        }
        if (this.m_path == null ? other.m_path != null : !this.m_path.equals(other.m_path)) {
            return false;
        }
        return this.m_removedLines == other.m_removedLines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.m_mode).append(' ');
        sb.append("[+").append(this.m_addedLines).append(",-").append(this.m_removedLines).append("] ");
        if (this.m_mode == DiffMode.RENAMED) {
            sb.append(this.m_originalPath).append(" -> ");
        }
        if (this.m_mode != DiffMode.DELETED) {
            sb.append(this.m_path);
        } else {
            sb.append(this.m_originalPath);
        }
        return sb.toString();
    }

    public static interface ICommit
    extends IPersistable {
        public void addChange(Diff var1);
    }
}

