/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm.git.controller;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.scm.BranchCommits;
import com.hello2morrow.sonargraph.scm.ICommitRetriever;
import com.hello2morrow.sonargraph.scm.IScmDataProvider;
import com.hello2morrow.sonargraph.scm.RetrieveException;
import com.hello2morrow.sonargraph.scm.git.controller.GitLogExecution;
import com.hello2morrow.sonargraph.scm.git.controller.GitRepository;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;

final class GitCommitRetriever
implements ICommitRetriever {
    private List<GitRepository> m_repositories;
    private final TFile m_systemBaseDirectory;
    private final String[] m_extensions;

    public GitCommitRetriever(List<GitRepository> repositories, TFile systemBaseDir, String ... extensions) {
        assert (repositories != null && !repositories.isEmpty());
        assert (systemBaseDir != null) : "Parameter 'systemBaseDir' of method 'GitCommitRetriever' must not be null";
        this.m_repositories = repositories;
        this.m_systemBaseDirectory = systemBaseDir;
        this.m_extensions = extensions;
    }

    public BranchCommits retrieveCommits(IScmDataProvider scmDataProvider, Date after, IWorkerContext workerContext) throws RetrieveException, IWorkerContext.WorkerContextCancelledException {
        assert (scmDataProvider != null) : "Parameter 'scmDataProvider' of method 'retrieveCommits' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'retrieveCommits' must not be null";
        BranchCommits result = null;
        workerContext.setNumberOfSteps(this.m_repositories.size());
        for (GitRepository repo : this.m_repositories) {
            if (workerContext.hasBeenCanceled()) {
                throw new IWorkerContext.WorkerContextCancelledException();
            }
            GitLogExecution log = new GitLogExecution(scmDataProvider, repo.getFile(), this.m_systemBaseDirectory, repo.getRelPath(), repo.getBranch(), after, this.m_extensions);
            workerContext.beginSubTask("Scanning repo: " + repo.getRelPath());
            if (result == null) {
                result = (BranchCommits)log.execute(workerContext);
            } else {
                BranchCommits commits = (BranchCommits)log.execute(workerContext);
                BranchCommits thisResult = result;
                commits.getCommits().forEach(c -> thisResult.addCommit(c));
            }
            workerContext.endSubTask();
        }
        if (this.m_repositories.size() > 1) {
            result.sort();
        }
        return result;
    }
}

