/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm.git.controller;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.scm.BranchCommits;
import com.hello2morrow.sonargraph.scm.Commit;
import com.hello2morrow.sonargraph.scm.Diff;
import com.hello2morrow.sonargraph.scm.DiffMode;
import com.hello2morrow.sonargraph.scm.IScmDataProvider;
import com.hello2morrow.sonargraph.scm.git.controller.AbstractGitCommandExecution;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

final class GitLogExecution
extends AbstractGitCommandExecution<BranchCommits> {
    static final String SCM_NAME = "Git";
    private final Date m_after;
    private final String m_rootDirPrefix;
    private final TreeFilter m_filter;
    private final TFile m_systemRoot;

    GitLogExecution(IScmDataProvider scmDataProvider, File repositoryDir, TFile systemRoot, String rootDirPrefix, String branchName, Date after, String[] extensions) {
        super(scmDataProvider, repositoryDir, branchName);
        this.m_after = after;
        this.m_rootDirPrefix = rootDirPrefix;
        this.m_filter = this.getTreeFilter(extensions);
        this.m_systemRoot = systemRoot;
    }

    private TreeFilter getTreeFilter(String[] fileExtensions) {
        assert (fileExtensions != null) : "Parameter 'fileExtensions' of method 'getTreeFilter' must not be null";
        TreeFilter filter = TreeFilter.ANY_DIFF;
        if (fileExtensions.length > 0) {
            if (fileExtensions.length > 1) {
                TreeFilter[] suffixFilters = new TreeFilter[fileExtensions.length];
                int i = 0;
                while (i < fileExtensions.length) {
                    suffixFilters[i] = PathSuffixFilter.create((String)fileExtensions[i]);
                    ++i;
                }
                filter = AndTreeFilter.create((TreeFilter)filter, (TreeFilter)OrTreeFilter.create((TreeFilter[])suffixFilters));
            } else {
                filter = AndTreeFilter.create((TreeFilter)filter, (TreeFilter)PathSuffixFilter.create((String)fileExtensions[0]));
            }
        }
        return filter;
    }

    @Override
    BranchCommits internalExecute(IWorkerContext workerContext, Repository repository, Git git, ObjectId branch) throws GitAPIException, IOException, IWorkerContext.WorkerContextCancelledException {
        BranchCommits result = new BranchCommits(SCM_NAME, this.getBranchName());
        BranchCommits storedCommits = this.getScmDataProvider().readData(result.getScmName(), result.getBranchName());
        LogCommand log = git.log().add((AnyObjectId)branch);
        RevFilter revFilter = RevFilter.NO_MERGES;
        if (this.m_after != null) {
            revFilter = AndRevFilter.create((RevFilter)revFilter, (RevFilter)CommitTimeRevFilter.after((Date)this.m_after));
        }
        log.setRevFilter(revFilter);
        Iterable logsIterable = log.call();
        ArrayList logs = new ArrayList();
        logsIterable.forEach(rc -> {
            boolean bl = logs.add(rc);
        });
        workerContext.beginBlockOfWork(logs.size());
        for (RevCommit rev : logs) {
            if (workerContext.hasBeenCanceled()) {
                throw new IWorkerContext.WorkerContextCancelledException();
            }
            if (rev.getParentCount() == 1) {
                List<DiffEntry> diffs;
                Commit commit = storedCommits.getCommit(rev.getName());
                long ts = (long)rev.getCommitTime() * 1000L;
                if ((commit == null || commit.getTimeStamp() != ts) && (diffs = this.computeDifference(repository, rev)).size() > 0) {
                    ArrayList<Diff> diffList = new ArrayList<Diff>();
                    for (DiffEntry diff : diffs) {
                        Diff aDiff = this.processDiffEntry(repository, diff);
                        diffList.add(aDiff);
                    }
                    commit = new Commit(rev.getName(), rev.getAuthorIdent().getName(), rev.getShortMessage(), ts, diffList);
                }
                if (commit != null) {
                    result.addCommit(commit);
                }
            }
            workerContext.workItemCompleted();
        }
        result.sort();
        this.getScmDataProvider().storeData(result);
        return result;
    }

    private Diff processDiffEntry(Repository repository, DiffEntry diff) throws IOException {
        assert (repository != null) : "Parameter 'repository' of method 'processDiffEntry' must not be null";
        assert (diff != null) : "Parameter 'diff' of method 'processDiffEntry' must not be null";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)baos);){
            formatter.setRepository(repository);
            formatter.format(diff);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String diffText = new String(baos.toByteArray(), StandardCharsets.ISO_8859_1);
        int addedLines = 0;
        int removedLines = 0;
        Throwable throwable3 = null;
        Object var8_13 = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(diffText));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("+++") || line.startsWith("---")) continue;
                if (line.startsWith("+")) {
                    ++addedLines;
                    continue;
                }
                if (!line.startsWith("-")) continue;
                ++removedLines;
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        DiffMode mode = null;
        switch (diff.getChangeType()) {
            case ADD: 
            case COPY: {
                mode = DiffMode.ADDED;
                break;
            }
            case MODIFY: {
                mode = DiffMode.MODIFIED;
                break;
            }
            case DELETE: {
                mode = DiffMode.DELETED;
                break;
            }
            case RENAME: {
                mode = DiffMode.RENAMED;
            }
        }
        return new Diff(mode, this.translatePath(diff.getNewPath()), this.translatePath(diff.getOldPath()), addedLines, removedLines);
    }

    private String translatePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals("/dev/null")) {
            return null;
        }
        TFile file = new TFile((File)this.m_systemRoot, this.m_rootDirPrefix + path).getNormalizedAbsoluteFile();
        String result = FileUtility.calculateRelativePath((TFile)file, (TFile)this.m_systemRoot);
        return result;
    }

    private List<DiffEntry> computeDifference(Repository repository, RevCommit revision) throws IOException, GitAPIException {
        List diffs;
        assert (repository != null) : "Parameter 'repository' of method 'computeDifference' must not be null";
        assert (revision != null) : "Parameter 'revision' of method 'computeDifference' must not be null";
        RevTree current = revision.getTree();
        RevTree previous = revision.getParent(0).getTree();
        Throwable throwable = null;
        Object var7_7 = null;
        try (ObjectReader reader = repository.newObjectReader();){
            CanonicalTreeParser previousTreeIter = new CanonicalTreeParser();
            CanonicalTreeParser currentTreeIter = new CanonicalTreeParser();
            previousTreeIter.reset(reader, (AnyObjectId)previous);
            currentTreeIter.reset(reader, (AnyObjectId)current);
            Throwable throwable2 = null;
            Object var12_14 = null;
            try (Git git = new Git(repository);){
                diffs = git.diff().setNewTree((AbstractTreeIterator)currentTreeIter).setOldTree((AbstractTreeIterator)previousTreeIter).setPathFilter(this.m_filter).call();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            RenameDetector renameDetector = new RenameDetector(repository);
            renameDetector.addAll((Collection)diffs);
            diffs = renameDetector.compute(reader, null);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return diffs;
    }
}

