/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IExternalAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginLanguageBasedAccess;
import com.hello2morrow.sonargraph.api.IPluginProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.WebUtilities;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IJavaMethodAccess;
import com.hello2morrow.sonargraph.api.java.IJavaModuleAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.spring.microservices.IConfigurationProvider;
import com.hello2morrow.sonargraph.plugin.spring.microservices.SpringDetector;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FeignClientWebCallDetector
extends SpringDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeignClientWebCallDetector.class);
    private final String m_pluginId;
    private final PluginProgrammingElementMetaData m_webResourceMetaData;
    private final PluginProgrammingElementMetaData m_externalWebResourceMetaData;
    private final PluginProgrammingElementMetaData m_webCallMetaData;
    private final PluginDependencyMetaData m_httpCallMetaData;
    private final IConfigurationProvider m_configurationProvider;

    FeignClientWebCallDetector(String pluginId, IConfigurationProvider configurationProvider, PluginProgrammingElementMetaData webResourceMetaData, PluginProgrammingElementMetaData externalWebResourceMetaData, PluginProgrammingElementMetaData webCallMetaData, PluginDependencyMetaData httpCallMetaData) {
        assert (pluginId != null) : "Parameter 'pluginId' of method 'WebCallDetector' must not be null";
        assert (configurationProvider != null) : "Parameter 'configurationProvider' of method 'FeignClientWebCallDetector' must not be null";
        assert (webResourceMetaData != null) : "Parameter 'webResourceMetaMetaData' of method 'WebCallDetector' must not be null";
        assert (externalWebResourceMetaData != null) : "Parameter 'externalWebResourceMetaMetaData' of method 'WebCallDetector' must not be null";
        assert (webCallMetaData != null) : "Parameter 'webCallMetaMetaData' of method 'WebCallDetector' must not be null";
        assert (httpCallMetaData != null) : "Parameter 'httpCallMetaData' of method 'WebCallDetector' must not be null";
        this.m_pluginId = pluginId;
        this.m_configurationProvider = configurationProvider;
        this.m_webResourceMetaData = webResourceMetaData;
        this.m_externalWebResourceMetaData = externalWebResourceMetaData;
        this.m_webCallMetaData = webCallMetaData;
        this.m_httpCallMetaData = httpCallMetaData;
    }

    private IPluginProgrammingElementAccess getOrCreateExternalResource(IPluginLanguageBasedAccess coreAccess, String path, List<String> httpMethods) {
        assert (coreAccess != null) : "Parameter 'javaAccess' of method 'getOrCreateExternalResource' must not be null";
        assert (path != null) : "Parameter 'path' of method 'getOrCreateExternalResource' must not be null";
        assert (httpMethods != null && !httpMethods.isEmpty()) : "Parameter 'httpMethods' of method 'getOrCreateExternalResource' must not be empty";
        IExternalAccess externalRoot = coreAccess.getExternalRoot(coreAccess.getLanguageIdentifier(), this.m_pluginId);
        assert (externalRoot != null) : "ExternalRoot for plugin " + this.m_pluginId + ", language " + coreAccess.getLanguageIdentifier() + " must not be null";
        IPluginProgrammingElementAccess programmingElementAccess = (IPluginProgrammingElementAccess)coreAccess.findFirstMatchingElement((INamedElementAccess)externalRoot, e -> e.getShortName().equals(path));
        if (programmingElementAccess == null) {
            THashMap properties = new THashMap();
            properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(httpMethods));
            properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)WebUtilities.removeVariablesFromPath((String)path)));
            programmingElementAccess = coreAccess.createProgrammingElement(this.m_pluginId, this.m_externalWebResourceMetaData, (INamedElementAccess)externalRoot, path, -1, (Map)properties);
        }
        return programmingElementAccess;
    }

    private List<IAggregatedDependencyAccess> getFeignClientAnnotatedInterfaces(IPluginJavaAccess javaAccess) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getFeignClientAnnotatedInterfaces' must not be null";
        IJavaTypeAccess feignAnnotation = (IJavaTypeAccess)javaAccess.findElementByFqn("Workspace:External [Java]:[Unknown]:org:springframework:cloud:openfeign:FeignClient:FeignClient");
        if (feignAnnotation == null) {
            return Collections.emptyList();
        }
        return feignAnnotation.getIncomingDependenciesRecursively(Aggregator.TYPE, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
    }

    void detect(IModelPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detect' must not be null";
        Predicate<INamedElementAccess> predicate = element -> element instanceof IPluginProgrammingElementAccess && ((IPluginProgrammingElementAccess)element).getPluginElementType().equals(this.m_webResourceMetaData.getType());
        List webResources = javaAccess.findAllMatchingElementsRecursively(javaAccess.getWorkspaceRoot(), predicate).stream().filter(e -> e instanceof IPluginProgrammingElementAccess).map(e -> (IPluginProgrammingElementAccess)e).collect(Collectors.toList());
        List<IAggregatedDependencyAccess> feignClientAnnotatedInterfaces = this.getFeignClientAnnotatedInterfaces(javaAccess);
        for (IAggregatedDependencyAccess nextDependency : feignClientAnnotatedInterfaces) {
            assert (nextDependency.getNumberOfDependencies() == 1) : "Type must have exactly one dependency to FeignClient annotation, but has " + nextDependency.getNumberOfDependencies() + ", dep: " + String.valueOf(nextDependency);
            IDependencyAccess dep = (IDependencyAccess)nextDependency.getDependencies().get(0);
            assert (dep.getFrom() instanceof IJavaTypeAccess) : "Unexpected 'from' of dependency: " + String.valueOf(dep.getFrom());
            IJavaTypeAccess type = (IJavaTypeAccess)dep.getFrom();
            if (!type.isInterface()) {
                LOGGER.info("Skipping @FeignClient annotated type {}, because it is not an interface", (Object)type);
                continue;
            }
            IAnnotationAccess annotation = FeignClientWebCallDetector.findAnnotation((List<IAnnotationAccess>)type.getAnnotations(), "Workspace:External [Java]:[Unknown]:org:springframework:cloud:openfeign:FeignClient:FeignClient");
            if (annotation == null) continue;
            List<String> target = this.getValueFromAnnotation(annotation, Arrays.asList("path", "url"));
            String root = "";
            if (target.size() > 0) {
                root = target.get(0);
                root = this.m_configurationProvider.resolveVariables((IJavaModuleAccess)type.getParent(IJavaModuleAccess.class), root);
            }
            for (IJavaMethodAccess nextMethod : type.getMethods()) {
                IAnnotationAccess requestMappingAnnotation = FeignClientWebCallDetector.findAnnotation((List<IAnnotationAccess>)nextMethod.getAnnotations(), "Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:RequestMapping:RequestMapping");
                if (requestMappingAnnotation == null) {
                    LOGGER.debug("Skipping method '{}', because no @RequestMapping is found", (Object)nextMethod);
                    continue;
                }
                List<String> paths = this.getValueFromAnnotation(requestMappingAnnotation, Arrays.asList("path", "value"));
                for (String nextPath : paths) {
                    String resultingPath;
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    String resolvedPath = this.m_configurationProvider.resolveVariables((IJavaModuleAccess)type.getParent(IJavaModuleAccess.class), nextPath);
                    if (!root.isEmpty()) {
                        char lastRootChar = root.charAt(root.length() - 1);
                        char firstPathChar = resolvedPath.charAt(0);
                        resultingPath = lastRootChar == '/' && firstPathChar == '/' ? root.substring(0, root.length() - 1) + resolvedPath : root + resolvedPath;
                    } else {
                        resultingPath = root + resolvedPath;
                    }
                    if (!(resultingPath.startsWith("http://") || resultingPath.startsWith("https://") || resultingPath.startsWith("/"))) {
                        resultingPath = "/" + resultingPath;
                    }
                    THashMap properties = new THashMap();
                    ArrayList<String> httpMethodTypes = new ArrayList<String>(this.extractMethodFromRequestMapping(requestMappingAnnotation));
                    properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(httpMethodTypes));
                    properties.put(WebProperty.FRAMEWORK.getStandardName(), AnyFactory.createFrom((Object)"SpringFeign"));
                    String pathToMatch = WebUtilities.removeVariablesFromPath((String)resultingPath);
                    properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)pathToMatch));
                    IPluginProgrammingElementAccess call = javaAccess.createProgrammingElement(this.m_pluginId, this.m_webCallMetaData, (INamedElementAccess)nextMethod, resultingPath, nextMethod.getLineNumber(), (Map)properties);
                    boolean foundMatch = false;
                    for (IPluginProgrammingElementAccess webResource : webResources) {
                        if (context.hasBeenCanceled()) {
                            return;
                        }
                        if (!WebUtilities.match((IPluginProgrammingElementAccess)webResource, (String)pathToMatch, (String)resultingPath, httpMethodTypes)) continue;
                        javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)call, (IProgrammingElementAccess)webResource);
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    IPluginProgrammingElementAccess externalWebResource = this.getOrCreateExternalResource((IPluginLanguageBasedAccess)javaAccess, resultingPath, httpMethodTypes);
                    javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)call, (IProgrammingElementAccess)externalWebResource);
                }
            }
        }
    }
}

