/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.pmd;

import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.pmd.SourceFileRegistry;
import java.io.IOException;
import java.util.Map;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.util.datasource.DataSource;

final class SonargraphRenderer
extends AbstractRenderer {
    private final IAnalyzerPluginContext m_context;
    private final ResultSet m_resultSet;
    private final Map<RulePriority, IPluginIssueId> m_issueIds;
    private final SourceFileRegistry m_sourceFileRegistry;

    SonargraphRenderer(IAnalyzerPluginContext context, ResultSet resultSet, Map<RulePriority, IPluginIssueId> issueIds, SourceFileRegistry sourceFileRegistry) {
        super("Sonargraph Renderer", "Sonargraph Renderer");
        assert (context != null) : "Parameter 'context' of method 'SonargraphRenderer' must not be null";
        assert (resultSet != null) : "Parameter 'resultSet' of method 'SonargraphRenderer' must not be null";
        assert (issueIds != null) : "Parameter 'issueIds' of method 'SonargraphRenderer' must not be null";
        assert (sourceFileRegistry != null) : "Parameter 'sourceFileRegistry' of method 'SonargraphRenderer' must not be null";
        this.m_context = context;
        this.m_resultSet = resultSet;
        this.m_issueIds = issueIds;
        this.m_sourceFileRegistry = sourceFileRegistry;
    }

    public String defaultFileExtension() {
        return null;
    }

    public void start() throws IOException {
        this.checkContext();
    }

    public void startFileAnalysis(DataSource dataSource) {
        this.m_context.workItemCompleted();
        this.checkContext();
    }

    public void renderFileReport(Report report) throws IOException {
        assert (report != null) : "Parameter 'report' of method 'renderFileReport' must not be null";
        this.checkContext();
        for (RuleViolation ruleViolation : report) {
            ISourceFileAccess sourceFileAccess;
            String fileName;
            if (ruleViolation.isSuppressed() || (fileName = ruleViolation.getFilename()) == null || (sourceFileAccess = this.m_sourceFileRegistry.getSourceFileAccess(fileName)) == null) continue;
            Rule rule = ruleViolation.getRule();
            assert (rule != null) : "Parameter 'rule' of method 'renderFileReport' must not be null";
            IPluginIssueId pluginIssueId = this.m_issueIds.get(rule.getPriority());
            assert (pluginIssueId != null) : "Parameter 'pluginIssueId' of method 'renderFileReport' must not be null";
            String message = ruleViolation.getDescription();
            int startLine = ruleViolation.getBeginLine();
            int endLine = ruleViolation.getEndLine();
            this.m_resultSet.addElementIssue((INamedElementAccess)sourceFileAccess, pluginIssueId, message, startLine, endLine);
        }
    }

    public void end() throws IOException {
    }

    private void checkContext() {
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
    }

    public void flush() {
    }
}

