/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.api;

import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ResultSet {
    private final List<ElementIssue> m_elementIssues = new ArrayList<ElementIssue>();
    private final List<MetricValue> m_elementMetrics = new ArrayList<MetricValue>();

    public ElementIssue addElementIssue(INamedElementAccess namedElementAccess, IPluginIssueId pluginIssueId, String message, int startLine, int endLine) {
        assert (namedElementAccess != null) : "Parameter 'namedElementAccess' of method 'addElementIssue' must not be null";
        assert (pluginIssueId != null) : "Parameter 'pluginIssueId' of method 'addElementIssue' must not be null";
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'addElementIssue' must not be empty";
        ElementIssue issue = new ElementIssue(namedElementAccess, pluginIssueId, message, startLine, endLine);
        this.m_elementIssues.add(issue);
        return issue;
    }

    public List<ElementIssue> getElementIssues() {
        return Collections.unmodifiableList(this.m_elementIssues);
    }

    public List<MetricValue> getElementMetrics() {
        return Collections.unmodifiableList(this.m_elementMetrics);
    }

    public void addElementIssues(List<ElementIssue> elementIssues) {
        assert (elementIssues != null) : "Parameter 'elementIssues' of method 'addElementIssues' must not be null";
        this.m_elementIssues.addAll(elementIssues);
    }

    public void addMetricValue(INamedElementAccess element, IPluginMetricId metricId, int value) {
        this.m_elementMetrics.add(new MetricValue(element, metricId, value));
    }

    public void addMetricValue(INamedElementAccess element, IPluginMetricId metricId, float value) {
        this.m_elementMetrics.add(new MetricValue(element, metricId, value));
    }

    public static final class ElementIssue {
        private final INamedElementAccess m_namedElementAccess;
        private final IPluginIssueId m_pluginIssueId;
        private final String m_message;
        private final int m_startLine;
        private final int m_endLine;

        public ElementIssue(INamedElementAccess namedElementAccess, IPluginIssueId pluginIssueId, String message, int startLine, int endLine) {
            assert (namedElementAccess != null) : "Parameter 'namedElementAccess' of method 'ElementIssue' must not be null";
            assert (pluginIssueId != null) : "Parameter 'pluginIssueId' of method 'ElementIssue' must not be null";
            assert (PluginIssueType.ELEMENT.equals((Object)pluginIssueId.getType())) : "Must be of type: " + String.valueOf((Object)PluginIssueType.ELEMENT);
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'ElementIssue' must not be empty";
            this.m_namedElementAccess = namedElementAccess;
            this.m_pluginIssueId = pluginIssueId;
            this.m_message = message;
            this.m_startLine = startLine;
            this.m_endLine = endLine;
        }

        public INamedElementAccess getNamedElementAccess() {
            return this.m_namedElementAccess;
        }

        public IPluginIssueId getPluginIssueId() {
            return this.m_pluginIssueId;
        }

        public String getMessage() {
            return this.m_message;
        }

        public String getMessageWithLines() {
            if (this.m_startLine == this.m_endLine) {
                return this.getMessage();
            }
            return this.getMessage() + " [" + this.getStartLine() + "-" + this.getEndLine() + "]";
        }

        public int getStartLine() {
            return this.m_startLine;
        }

        public int getEndLine() {
            return this.m_endLine;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_namedElementAccess.hashCode();
            result = 31 * result + this.m_pluginIssueId.hashCode();
            result = 31 * result + this.m_message.hashCode();
            result = 31 * result + this.m_startLine;
            result = 31 * result + this.m_endLine;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof ElementIssue)) {
                return false;
            }
            ElementIssue other = (ElementIssue)obj;
            return this.m_namedElementAccess.equals(other.m_namedElementAccess) && this.m_pluginIssueId.equals(other.m_pluginIssueId) && this.m_message.equals(other.m_message) && this.m_startLine == other.m_startLine && this.m_endLine == other.m_endLine;
        }
    }

    public static final class MetricValue {
        private final INamedElementAccess m_element;
        private final IPluginMetricId m_metricId;
        private final Number m_value;

        private MetricValue(INamedElementAccess element, IPluginMetricId metricId, int value) {
            this.m_element = element;
            this.m_metricId = metricId;
            this.m_value = value;
        }

        private MetricValue(INamedElementAccess element, IPluginMetricId metricId, float value) {
            this.m_element = element;
            this.m_metricId = metricId;
            this.m_value = Float.valueOf(value);
        }

        public INamedElementAccess getElement() {
            return this.m_element;
        }

        public IPluginMetricId getMetricId() {
            return this.m_metricId;
        }

        public Number getValue() {
            return this.m_value;
        }
    }
}

