/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.TsConfigJsonFile;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

final class JsonFileManager
implements IJsonFileManager {
    private final THashMap<Path, IJsonFileManager.IJsonFile> m_JsonFiles = new THashMap();

    JsonFileManager() {
    }

    @Override
    public void put(Path path, IJsonFileManager.IJsonFile jsonFile) {
        this.m_JsonFiles.put((Object)path, (Object)jsonFile);
    }

    @Override
    public <F extends IJsonFileManager.IJsonFile> F computeIfAbsent(Path path, IJsonFileManager.JsonFileSupplier<F> supplier) throws IOException {
        assert (path != null) : "Parameter 'path' of method 'computeIfAbsent' must not be null";
        assert (supplier != null) : "Parameter 'supplier' of method 'computeIfAbsent' must not be null";
        Path normalizedPath = path.normalize();
        IJsonFileManager.IJsonFile result = (IJsonFileManager.IJsonFile)this.m_JsonFiles.get((Object)normalizedPath);
        if (result != null) {
            return (F)result;
        }
        if (!Files.exists(normalizedPath, new LinkOption[0])) {
            return null;
        }
        F value = supplier.get();
        this.m_JsonFiles.put((Object)normalizedPath, value);
        return value;
    }

    @Override
    public IJsonFileManager.IJsonFile createTsConfigJsonFile(Path path, IExecutionContext context) throws IOException {
        assert (path != null) : "Parameter 'path' of method 'createTsConfigJsonFile' must not be null";
        assert (context != null) : "Parameter 'context' of method 'createTsConfigJsonFile' must not be null";
        return new TsConfigJsonFile(path, this, context);
    }
}

