/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.Decommenter;
import com.hello2morrow.sonargraph.plugin.angular.ElementUsage;
import com.hello2morrow.sonargraph.plugin.angular.Field;
import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.PipeUsage;
import com.hello2morrow.sonargraph.plugin.angular.Usage;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypeScriptFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeScriptFile.class);
    private static final Pattern IS_COMPONENT_PATTERN = Pattern.compile("^\\s*(.*\\*/)?\\s*@Component", 8);
    private static final Pattern IS_DIRECTIVE_PATTERN = Pattern.compile("^\\s*(.*\\*/)?\\s*@Directive", 8);
    private static final Pattern IS_PIPE_PATTERN = Pattern.compile("^\\s*(.*\\*/)?\\s*@Pipe", 8);
    private static final Pattern COMPONENT_PROPERTIES_PATTERN = Pattern.compile("\\s*@(Component|Directive|Pipe)\\(\\{(?<props>(\\s*.*)*)\\s*}\\s*\\)(\\s*.*)*(?<name>class\\s+\\S*)", 8);
    private static final Pattern COMPONENT_SINGLE_PROPERTY_PATTERN = Pattern.compile("(?<property>\\S*)\\s*:\\s*(?<value>(\\s*.*)*),?");
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\s*(set|get|readonly)*\\s*(?<field>\\w*)");
    private static final Pattern SINGLE_LINE_INPUT_OUTPUT = Pattern.compile("@.*\\(.*\\)\\s*(set|get|readonly)*\\s*(?<field>\\w+)");
    private final Path m_path;
    private final Map<String, String> m_properties;
    private final Set<Usage> m_usages;
    private final Set<Dependency> m_dependencies;
    private final Map<String, Field> m_fields;
    private final boolean m_isComponent;
    private final boolean m_isDirective;
    private final boolean n_isPipe;
    private final int m_templateLineNumber;
    private final String m_className;
    private final int m_classLineNumber;

    TypeScriptFile(Path path, String content) {
        assert (path != null) : "Parameter 'path' of method 'TypescriptFile' must not be null";
        assert (content != null) : "Parameter 'content' of method 'TypescriptFile' must not be null";
        String decommentedContent = Decommenter.decomment(path, content);
        this.m_path = path;
        this.m_isComponent = IS_COMPONENT_PATTERN.matcher(decommentedContent).find();
        if (!this.m_isComponent && decommentedContent.contains("@Component")) {
            LOGGER.warn("Ignoring potentially commented out component in: " + String.valueOf(path));
        }
        this.m_isDirective = IS_DIRECTIVE_PATTERN.matcher(decommentedContent).find();
        if (!this.m_isDirective && decommentedContent.contains("@Directive")) {
            LOGGER.warn("Ignoring potentially commented out directive in: " + String.valueOf(path));
        }
        this.n_isPipe = IS_PIPE_PATTERN.matcher(decommentedContent).find();
        if (!this.n_isPipe && decommentedContent.contains("@Pipe")) {
            LOGGER.warn("Ignoring potentially commented out pipe in: " + String.valueOf(path));
        }
        this.m_usages = new THashSet();
        this.m_dependencies = new THashSet();
        boolean compute = this.m_isComponent || this.m_isDirective || this.n_isPipe;
        this.m_properties = compute ? this.computeProperties(decommentedContent) : Collections.emptyMap();
        this.m_className = compute ? this.computeClassName() : null;
        this.m_classLineNumber = compute ? this.computeClassLineNumber(decommentedContent) : 0;
        this.m_templateLineNumber = compute ? this.computeTemplateLineNumber(decommentedContent) : 0;
        this.m_fields = compute ? this.computeFields(decommentedContent) : Collections.emptyMap();
    }

    String getClassName() {
        return this.m_className;
    }

    int getClassLineNumber() {
        return this.m_classLineNumber;
    }

    private String computeClassName() {
        String classDefinition = this.m_properties.getOrDefault("componentClassDefinition", "- -");
        return classDefinition.split(" ")[1];
    }

    boolean isComponent() {
        return this.m_isComponent;
    }

    boolean isDirective() {
        return this.m_isDirective;
    }

    boolean isPipe() {
        return this.n_isPipe;
    }

    String getSelector() {
        String selector = this.m_properties.getOrDefault("selector", "");
        if (selector.isBlank() && (this.m_isComponent || this.m_isDirective)) {
            LOGGER.warn("Cannot find selector for: " + String.valueOf(this.m_path));
        }
        return this.isDirective() ? selector.toLowerCase() : selector;
    }

    String getName() {
        String name = this.m_properties.getOrDefault("name", "");
        if (name.isBlank() && this.n_isPipe) {
            LOGGER.warn("Cannot find name for pipe: " + String.valueOf(this.m_path));
        }
        return name;
    }

    String getTemplate() {
        return this.m_properties.get("template");
    }

    private String getTemplateUrl() {
        return this.m_properties.get("templateUrl");
    }

    private int computeTemplateLineNumber(String content) {
        String templateKey = this.getTemplate() != null ? "template" : "templateUrl";
        return this.getLineNumber(content, templateKey);
    }

    private int computeClassLineNumber(String content) {
        String classDefinition = this.m_properties.getOrDefault("componentClassDefinition", "- -");
        return this.getLineNumber(content, classDefinition);
    }

    private int getLineNumber(String content, String search) {
        String[] lines = content.split("\n");
        int number = 1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains(search)) {
                return number;
            }
            ++number;
            ++n2;
        }
        return 0;
    }

    void addUsedElements(List<Usage> elements) {
        this.m_usages.addAll(elements);
    }

    void computeDependencies(Map<String, TypeScriptFile> components, Map<String, TypeScriptFile> pipes, IExecutionContext context) {
        assert (components != null) : "Parameter 'components' of method 'computeDependencies' must not be null";
        assert (pipes != null) : "Parameter 'pipes' of method 'computeDependencies' must not be null";
        assert (context != null) : "Parameter 'context' of method 'computeDependencies' must not be null";
        for (Usage usage : this.m_usages) {
            ElementUsage elementUsage;
            TypeScriptFile component;
            if (context.hasBeenCanceled()) {
                return;
            }
            if (!(usage instanceof ElementUsage) || (component = (TypeScriptFile)components.getOrDefault((elementUsage = (ElementUsage)usage).getTag(), null)) == null) continue;
            Set<Field> fields = component.findFields(elementUsage.getProperties());
            this.m_dependencies.add(new Dependency(this, component, fields, this.m_templateLineNumber));
        }
        this.m_usages.stream().filter(u -> u instanceof ElementUsage).map(u -> (ElementUsage)u).filter(e -> e.getProperties().stream().anyMatch(components::containsKey)).forEach(element -> {
            List<String> properties = element.getProperties();
            properties.stream().filter(components::containsKey).map(components::get).forEach(directive -> {
                Set<Field> fields = directive.findFields(properties);
                this.m_dependencies.add(new Dependency(this, (TypeScriptFile)directive, fields, this.m_templateLineNumber));
            });
        });
        this.m_usages.stream().filter(u -> u instanceof PipeUsage).map(u -> (PipeUsage)u).map(PipeUsage::getName).filter(pipes::containsKey).forEach(name -> {
            TypeScriptFile pipe = (TypeScriptFile)pipes.get(name);
            this.m_dependencies.add(new Dependency(this, pipe, Collections.emptySet(), this.m_templateLineNumber));
        });
    }

    private Set<Field> findFields(List<String> properties) {
        return (Set)properties.stream().filter(this.m_fields::containsKey).map(this.m_fields::get).collect(Collectors.toCollection(THashSet::new));
    }

    Set<Dependency> getDependencies() {
        return this.m_dependencies;
    }

    String getTemplatePath() {
        String template = this.getTemplateUrl();
        return template == null ? null : this.m_path.toFile().getParentFile().getPath() + File.separator + this.getTemplateUrl();
    }

    private THashMap<String, String> computeProperties(String content) {
        THashMap properties = new THashMap();
        Matcher matcher = COMPONENT_PROPERTIES_PATTERN.matcher(content);
        if (!matcher.find()) {
            return properties;
        }
        String[] stringArray = matcher.group("props").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String it = stringArray[n2];
            Matcher propMatcher = COMPONENT_SINGLE_PROPERTY_PATTERN.matcher(it);
            if (propMatcher.find()) {
                String property = propMatcher.group("property");
                String value = propMatcher.group("value");
                properties.put((Object)property.trim(), (Object)value.replaceAll("[\"'\\[\\]]", "").trim());
            }
            ++n2;
        }
        properties.put((Object)"componentClassDefinition", (Object)matcher.group("name"));
        return properties;
    }

    private THashMap<String, Field> computeFields(String content) {
        THashMap fields = new THashMap();
        String[] lines = content.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].contains("@Input") || lines[i].contains("@Output")) {
                Matcher singleLineMatcher = SINGLE_LINE_INPUT_OUTPUT.matcher(lines[i]);
                if (singleLineMatcher.find()) {
                    String field = singleLineMatcher.group("field");
                    fields.put((Object)field.toLowerCase(), (Object)new Field(i + 1, field));
                } else {
                    Matcher matcher = FIELD_PATTERN.matcher(lines[i + 1]);
                    if (matcher.find()) {
                        String field = matcher.group("field");
                        fields.put((Object)field.toLowerCase(), (Object)new Field(i + 2, field));
                    }
                }
            }
            ++i;
        }
        return fields;
    }

    Map<String, Field> getFields() {
        return this.m_fields;
    }

    Path getPath() {
        return this.m_path;
    }

    public String toString() {
        return this.m_path.toString();
    }

    static final class Dependency {
        private final TypeScriptFile m_from;
        private final TypeScriptFile m_to;
        private final int m_lineNumber;
        private final Set<Field> m_fields;

        Dependency(TypeScriptFile from, TypeScriptFile to, Set<Field> fields, int line) {
            assert (from != null) : "Parameter 'from' of method 'Dependency' must not be null";
            assert (to != null) : "Parameter 'to' of method 'Dependency' must not be null";
            assert (fields != null) : "Parameter 'fields' of method 'Dependency' must not be null";
            this.m_from = from;
            this.m_lineNumber = line;
            this.m_to = to;
            this.m_fields = fields;
        }

        TypeScriptFile getFrom() {
            return this.m_from;
        }

        TypeScriptFile getTo() {
            return this.m_to;
        }

        int getLine() {
            return this.m_lineNumber;
        }

        Set<Field> getFields() {
            return this.m_fields;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Dependency that = (Dependency)obj;
            return Objects.equals(this.m_from, that.m_from) && Objects.equals(this.m_lineNumber, that.m_lineNumber) && Objects.equals(this.m_to, that.m_to) && Objects.equals(this.m_fields, that.m_fields);
        }

        public int hashCode() {
            return Objects.hash(this.m_from, this.m_lineNumber, this.m_to, this.m_fields);
        }

        public String toString() {
            return this.m_fields.isEmpty() ? String.format("%s:%s (%s:%s) -> %s:%s (%s)", this.m_from, this.m_lineNumber, this.m_from.getClassName(), this.m_from.getClassLineNumber(), this.m_to, this.m_to.getClassLineNumber(), this.m_to.getClassName()) : this.m_fields.stream().map(field -> String.format("%s:%s (%s:%s) -> %s:%s (%s:%s:%s)", this.m_from, this.m_lineNumber, this.m_from.getClassName(), this.m_from.getClassLineNumber(), this.m_to, field.line(), this.m_to.getClassName(), field.getName(), this.m_to.getClassLineNumber())).collect(Collectors.joining("\n"));
        }
    }
}

