/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.api.IDirectoryAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.ITypeAccess;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.typescript.ITypeScriptModuleAccess;
import com.hello2morrow.sonargraph.api.typescript.ITypeScriptSourceFileAccess;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.IModelPluginInfoConsumer;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.angular.DependencyRetriever;
import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.TypeScriptFile;
import com.hello2morrow.sonargraph.plugin.typescript.IPluginTypescriptAccess;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AngularPlugin
extends SonargraphPlugin
implements IPluginModelContributor {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.angular";
    private static final Logger LOGGER = LoggerFactory.getLogger(AngularPlugin.class);
    private PluginDependencyMetaData m_dependencyMetaData;

    public AngularPlugin() {
        LOGGER.debug("[" + this.getId() + "] Instantiated: " + this.getHexReference());
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Detects and adds Angular component dependencies.";
    }

    public String getPresentationName() {
        return "Sonargraph Angular Plugin";
    }

    public IPluginModelContributor getModelContributor() {
        return this;
    }

    public String getAvailableForLanguages() {
        return "TypeScript";
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton("Typescript");
    }

    public boolean createPluginExternal() {
        return false;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        LOGGER.debug("[" + this.getId() + "] Initialize: " + this.getHexReference());
        this.m_dependencyMetaData = contributor.createDependencyMetaData("Component", true, true, true);
        LOGGER.debug("[" + this.getId() + "] Initialize - done");
    }

    public void createModelElements(IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) {
        assert (context != null) : "Parameter 'context' of method 'createModelElements' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createModelElements' must not be null";
        LOGGER.debug("[" + this.getId() + "] Create model elements");
        LOGGER.debug("[" + this.getId() + "] Create model elements - done");
    }

    public void createDependencies(final IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) throws IOException {
        assert (context != null) : "Parameter 'context' of method 'createDependencies' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createDependencies' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.debug("[" + this.getId() + "] Create dependencies");
        try {
            String workingMessage = "[" + this.getPresentationName() + "] Detect component dependencies";
            context.working(workingMessage);
            IPluginTypescriptAccess typescriptAccess = (IPluginTypescriptAccess)context.getAccess(IPluginTypescriptAccess.class);
            assert (typescriptAccess != null) : "'typescriptAccess' of method 'createDependencies' must not be null";
            TFile tsConfigFile = typescriptAccess.getTsConfigFile();
            LOGGER.debug("Using TS config file: " + String.valueOf(tsConfigFile));
            LinkedHashSet<Path> sourceRoots = new LinkedHashSet<Path>();
            INamedElementAccess workspaceRoot = typescriptAccess.getWorkspaceRoot();
            for (INamedElementAccess nextChild : workspaceRoot.getChildren()) {
                if (!(nextChild instanceof IModuleAccess)) continue;
                for (INamedElementAccess nextModuleChild : nextChild.getChildren()) {
                    TFile nextSourceDirectory;
                    if (!(nextModuleChild instanceof IDirectoryAccess) || !((IDirectoryAccess)nextModuleChild).isRootDirectory() || (nextSourceDirectory = ((IDirectoryAccess)nextModuleChild).getFile()) == null || !nextSourceDirectory.exists()) continue;
                    sourceRoots.add(Path.of(nextSourceDirectory.getAbsolutePath(), new String[0]));
                }
            }
            IExecutionContext executionContext = new IExecutionContext(){

                @Override
                public boolean hasBeenCanceled() {
                    return context.hasBeenCanceled();
                }
            };
            try {
                Collection<Path> additionalSourceRoots = DependencyRetriever.detectSourceRoots(tsConfigFile.getAbsolutePath(), executionContext);
                sourceRoots.addAll(additionalSourceRoots);
            }
            catch (Throwable t2) {
                infoConsumer.error("Caught exception during additional source root detection. Using only default source roots.", t2);
            }
            if (!sourceRoots.isEmpty()) {
                LOGGER.debug("Retrieve dependencies from " + sourceRoots.size() + " source root directories");
                context.working(workingMessage + " in " + sourceRoots.size() + (sourceRoots.size() == 1 ? " directory" : " directories"));
                List<TypeScriptFile.Dependency> dependencies = DependencyRetriever.retrieveDependencies(sourceRoots, executionContext);
                LOGGER.debug("Retrieve dependencies from " + sourceRoots.size() + " source root directories - done [" + dependencies.size() + "]");
                if (!dependencies.isEmpty() && !context.hasBeenCanceled()) {
                    LOGGER.debug("Retrieve source files");
                    THashMap nameToSourceFile = new THashMap();
                    List children = workspaceRoot.getChildren();
                    for (INamedElementAccess nextChild : children) {
                        if (context.hasBeenCanceled()) {
                            return;
                        }
                        if (!ITypeScriptModuleAccess.class.isAssignableFrom(nextChild.getClass())) continue;
                        LOGGER.debug("Retrieve source files from module: " + nextChild.getName());
                        for (INamedElementAccess nextSourceFile : typescriptAccess.findAllMatchingElementsRecursively(nextChild, n -> ITypeScriptSourceFileAccess.class.isAssignableFrom(n.getClass()))) {
                            if (context.hasBeenCanceled()) {
                                return;
                            }
                            assert (nextSourceFile != null && nextSourceFile instanceof ITypeScriptSourceFileAccess) : "Unexpected class in method 'createDependencies': " + String.valueOf(nextSourceFile);
                            nameToSourceFile.put(((ITypeScriptSourceFileAccess)nextSourceFile).getPath(), (ITypeScriptSourceFileAccess)nextSourceFile);
                        }
                    }
                    LOGGER.debug("Retrieve source files - done [" + nameToSourceFile.size() + "]");
                    LOGGER.debug("Add dependencies to model");
                    int numberOfAddedDependencies = 0;
                    for (TypeScriptFile.Dependency nextDependency : dependencies) {
                        ITypeAccess nextToType;
                        ITypeAccess nextFromType;
                        TypeScriptFile nextTo;
                        ITypeScriptSourceFileAccess nextToFile;
                        if (context.hasBeenCanceled()) {
                            return;
                        }
                        boolean added = false;
                        TypeScriptFile nextFrom = nextDependency.getFrom();
                        ITypeScriptSourceFileAccess nextFromFile = (ITypeScriptSourceFileAccess)nameToSourceFile.get(nextFrom.getPath().toFile().getAbsolutePath());
                        if (nextFromFile != null && (nextToFile = (ITypeScriptSourceFileAccess)nameToSourceFile.get((nextTo = nextDependency.getTo()).getPath().toFile().getAbsolutePath())) != null && (nextFromType = typescriptAccess.findFirstMatchingType((INamedElementAccess)nextFromFile, t -> t.getName().equals(nextFrom.getClassName()))) != null && (nextToType = typescriptAccess.findFirstMatchingType((INamedElementAccess)nextToFile, t -> t.getName().equals(nextTo.getClassName()))) != null) {
                            typescriptAccess.addDependency(this.getId(), this.m_dependencyMetaData, (IProgrammingElementAccess)nextFromType, (IProgrammingElementAccess)nextToType);
                            ++numberOfAddedDependencies;
                            added = true;
                        }
                        if (added) continue;
                        LOGGER.warn("Unable to add detected dependency: " + String.valueOf(nextDependency));
                    }
                    LOGGER.debug("Add dependencies to model - done [" + numberOfAddedDependencies + "]");
                }
            }
        }
        finally {
            LOGGER.debug("[" + this.getId() + "] Create dependencies - done [" + (System.currentTimeMillis() - start) + " ms]");
        }
    }

    public void cleared(IPluginContext context) {
        LOGGER.debug("[" + this.getId() + "] Cleared");
    }
}

