/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.userfeedback.controller;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.userfeedback.controller.FeedbackSender;
import com.hello2morrow.sonargraph.userfeedback.model.ErrorFeedback;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import java.util.List;
import org.apache.http.entity.mime.MultipartEntityBuilder;

final class ErrorFeedbackSender
extends FeedbackSender {
    ErrorFeedbackSender(List<String> hosts, ProxySettings proxySettings) {
        super(hosts, proxySettings);
    }

    @Override
    protected void addAdditionalParameters(Feedback feedback) {
        assert (feedback != null) : "Parameter 'feedback' of method 'addAdditionalParameters' must not be null";
        assert (feedback instanceof ErrorFeedback) : "Unexpected class: " + feedback.getClass().getName();
        MultipartEntityBuilder builder = this.getBuilder();
        ErrorFeedback errorFeedback = (ErrorFeedback)feedback;
        if (errorFeedback.getException() != null) {
            builder.addTextBody("exception_class", errorFeedback.getException().getClass().getCanonicalName(), this.plainText());
            builder.addTextBody("stack_trace", ExceptionUtility.collectAll((Throwable)errorFeedback.getException()), this.plainText());
        } else if (errorFeedback.getStatusMessage() != null) {
            builder.addTextBody("exception_class", "Status Message", this.plainText());
            builder.addTextBody("stack_trace", errorFeedback.getStatusMessage(), this.plainText());
        }
        if (errorFeedback.getContextInfo() != null) {
            builder.addTextBody("context_info", errorFeedback.getContextInfo(), this.plainText());
        }
    }
}

