/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.userfeedback.controller;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.httpclient.controller.HttpClientWrapper;
import com.hello2morrow.sonargraph.httpclient.model.HttpClientInfo;
import com.hello2morrow.sonargraph.license.model.ProductDescriptor;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import com.hello2morrow.sonargraph.userfeedback.model.FeedbackMessageCause;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FeedbackSender
extends HttpClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackSender.class);
    private final ContentType m_contentTypePlainText = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    private final MultipartEntityBuilder m_builder = MultipartEntityBuilder.create();
    private String m_feedbackId;

    FeedbackSender(List<String> hosts, ProxySettings proxySettings) {
        super(hosts, proxySettings);
        this.m_builder.setCharset(StandardCharsets.UTF_8);
        this.m_builder.setLaxMode();
    }

    protected ContentType plainText() {
        return this.m_contentTypePlainText;
    }

    /*
     * Unable to fully structure code
     */
    private void analyzeReply(HttpEntity reply, OperationResult result) throws IOException, UnsupportedEncodingException {
        var3_3 = null;
        var4_5 = null;
        try {
            instream = reply.getContent();
            try {
                streamReader = new InputStreamReader(instream, StandardCharsets.UTF_8.name());
                try {
                    block32: {
                        reader = new LineNumberReader(streamReader);
                        try {
                            replyCode = reader.readLine();
                            dataBuffer = new StringBuffer(1024);
                            while ((c = reader.read()) != -1) {
                                dataBuffer.append((char)c);
                            }
                            if (replyCode == null) {
                                result.addError((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_SERVER_ERROR, "Invalid server reply", new Object[0]);
                                FeedbackSender.LOGGER.error("Invalid server reply: null");
                                break block32;
                            }
                            var11_15 = replyCode;
                            tmp = -1;
                            switch (var11_15.hashCode()) {
                                case 2524: {
                                    if (var11_15.equals("OK")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    this.m_feedbackId = dataBuffer.toString();
                                    ** break;
lbl34:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    result.addError((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_SERVER_ERROR);
                                    break;
                                }
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    ** if (streamReader == null) goto lbl-1000
                }
                catch (Throwable var4_6) {
                    if (var3_3 == null) {
                        var3_3 = var4_6;
                    } else if (var3_3 != var4_6) {
                        var3_3.addSuppressed(var4_6);
                    }
                    if (streamReader != null) {
                        streamReader.close();
                    }
                    throw var3_3;
                }
lbl-1000:
                // 1 sources

                {
                    streamReader.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (instream == null) goto lbl-1000
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                if (instream != null) {
                    instream.close();
                }
                throw var3_3;
            }
lbl-1000:
            // 1 sources

            {
                instream.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var4_8) {
            if (var3_3 == null) {
                var3_3 = var4_8;
            } else if (var3_3 != var4_8) {
                var3_3.addSuppressed(var4_8);
            }
            throw var3_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final OperationResult sendFeedback(Feedback feedback, ProductDescriptor productDescriptor) {
        assert (feedback != null) : "Parameter 'feedback' of method 'sendFeedback' must not be null";
        assert (productDescriptor != null) : "Parameter 'productDescriptor' of method 'sendFeedback' must not be null";
        OperationResult result = new OperationResult("Sending user feedback");
        HttpClientInfo httpClientInfo = this.getAvailableHost();
        if (httpClientInfo != null) {
            HttpClient httpClient = HttpClientWrapper.createHttpClient(httpClientInfo.getProxySettings(), 1);
            String host = httpClientInfo.getHost();
            HttpPost postRequest = new HttpPost(host + "/send_error_report");
            this.m_feedbackId = null;
            try {
                try {
                    this.addStandardTextInfo(feedback, productDescriptor);
                    this.addAdditionalParameters(feedback);
                    if (feedback.isTestOnly()) {
                        this.m_builder.addTextBody("test", "true", this.plainText());
                    }
                    File zip = null;
                    if (feedback.getLogFile() != null || feedback.getRootForZip() != null) {
                        zip = this.createZipFile(feedback);
                        this.m_builder.addBinaryBody("log_file", zip);
                    }
                    postRequest.setEntity(this.m_builder.build());
                    HttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
                    HttpEntity reply = response.getEntity();
                    this.removeZipFile(zip);
                    if (reply != null) {
                        this.analyzeReply(reply, result);
                        return result;
                    }
                    result.addError((OperationResult.IMessageCause)FeedbackMessageCause.NO_SERVER_REPLY);
                    return result;
                }
                catch (UnsupportedEncodingException ex) {
                    result.addError((OperationResult.IMessageCause)FeedbackMessageCause.UNABLE_TO_PERFORM_REQUEST, (Throwable)ex);
                    OperationResult operationResult = result;
                    if (!(httpClient instanceof Closeable)) return operationResult;
                    try {
                        ((Closeable)httpClient).close();
                        return operationResult;
                    }
                    catch (IOException ioe) {
                        result.addWarning((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_FEEDBACK_CLIENT_ERROR, (Throwable)ioe);
                    }
                    return operationResult;
                }
                catch (Exception e) {
                    result.addError((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_FEEDBACK_CLIENT_ERROR, (Throwable)e);
                    if (!(httpClient instanceof Closeable)) return result;
                    try {
                        ((Closeable)httpClient).close();
                        return result;
                    }
                    catch (IOException ioe) {
                        result.addWarning((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_FEEDBACK_CLIENT_ERROR, (Throwable)ioe);
                    }
                    return result;
                }
            }
            finally {
                if (httpClient instanceof Closeable) {
                    try {
                        ((Closeable)httpClient).close();
                    }
                    catch (IOException ioe) {
                        result.addWarning((OperationResult.IMessageCause)FeedbackMessageCause.INTERNAL_FEEDBACK_CLIENT_ERROR, (Throwable)ioe);
                    }
                }
            }
        }
        result.addError((OperationResult.IMessageCause)FeedbackMessageCause.UNABLE_TO_CONTACT_FEEDBACK_SERVER);
        return result;
    }

    private void addStandardTextInfo(Feedback feedback, ProductDescriptor productDescriptor) {
        this.m_builder.addTextBody("salutation", feedback.getSalutation().getPresentationName(), this.plainText());
        this.m_builder.addTextBody("contact_name", feedback.getContactName(), this.plainText());
        this.m_builder.addTextBody("email", feedback.getEmail(), this.plainText());
        this.m_builder.addTextBody("phone", feedback.getPhone(), this.plainText());
        this.m_builder.addTextBody("serial_number", feedback.getActivationCode(), this.plainText());
        this.m_builder.addTextBody("product", productDescriptor.getProduct(), this.plainText());
        this.m_builder.addTextBody("build_date", productDescriptor.getBuildDate(), this.plainText());
        this.m_builder.addTextBody("version", productDescriptor.getVersion(), this.plainText());
        this.m_builder.addTextBody("os_name", System.getProperty("os.name"), this.plainText());
        this.m_builder.addTextBody("os_version", System.getProperty("os.version"), this.plainText());
        this.m_builder.addTextBody("java_vendor", Platform.getJavaVendor(), this.plainText());
        this.m_builder.addTextBody("java_version", Platform.getJavaVersionAsString(), this.plainText());
    }

    private File createZipFile(Feedback feedback) throws IOException, FsSyncException {
        File zip = feedback.getLogFile() != null ? new File((File)feedback.getLogFile().getParentFile(), "sonargraph.log.zip") : new File((File)feedback.getRootForZip(), "sonargraph.log.zip");
        if (zip.exists()) {
            zip.delete();
        }
        TFile zipped = null;
        if (feedback.getLogFile() != null && feedback.getLogFile().exists()) {
            zipped = new TFile(zip, feedback.getLogFile().getName());
            feedback.getLogFile().cp_rp((File)zipped);
        }
        if (feedback.getRootForZip() != null) {
            String basePath = feedback.getRootForZip().getNormalizedAbsolutePath();
            List allFilesRecursively = FileUtility.getAllFilesRecursively((TFile)feedback.getRootForZip());
            for (TFile next : allFilesRecursively) {
                String path = next.getNormalizedAbsolutePath().substring(basePath.length());
                zipped = new TFile(zip, path);
                next.cp_rp((File)zipped);
            }
        }
        for (TFile next : feedback.getAdditionalFiles()) {
            if (!next.exists()) continue;
            zipped = new TFile(zip, next.getName());
            next.cp_rp((File)zipped);
        }
        TVFS.umount((TFile)new TFile(zip));
        return zip;
    }

    private void removeZipFile(File zip) {
        if (zip != null) {
            try {
                zip.delete();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to delete feedback zip file: " + zip.getAbsolutePath());
            }
        }
    }

    protected final MultipartEntityBuilder getBuilder() {
        assert (this.m_builder != null) : "'m_builder' must not be null";
        return this.m_builder;
    }

    protected void addAdditionalParameters(Feedback feedback) {
        assert (feedback != null) : "Parameter 'feedback' of method 'addAdditionalParameters' must not be null";
    }

    final String getFeedbackId() {
        return this.m_feedbackId;
    }
}

