/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethod;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethodKind;
import java.io.IOException;

public final class TypescriptFunctionOrMethodWithBody
extends TypescriptFunctionOrMethod {
    private int m_numberOfStatements = -1;
    private int m_cyclomaticComplexity = -1;
    private int m_modifiedCyclomaticComplexity = -1;
    private short m_numberOfLogicalOperations = (short)-1;
    private short m_maxNesting = (short)-1;
    private int m_serialNo = 0;

    public TypescriptFunctionOrMethodWithBody(NamedElement parent) {
        super(parent);
    }

    public TypescriptFunctionOrMethodWithBody(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int noParameters, boolean isAbstract, TypescriptFunctionOrMethodKind kind) {
        super(msp, parent, name, lineNumber, noParameters, isAbstract, kind);
    }

    @Override
    public String getImageResourceName() {
        String image = "MethodWithBody";
        switch (this.getKind()) {
            case FUNCTION: {
                image = "Function";
                break;
            }
            case METHOD: {
                break;
            }
            case CONSTRUCTOR: {
                break;
            }
            case GETTER: {
                break;
            }
        }
        return image;
    }

    @Override
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    @Override
    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    @Override
    public int getExtendedCyclomaticComplexity() {
        if (this.m_cyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_cyclomaticComplexity;
        }
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    public int getModifiedExtendedCyclomaticComplexity() {
        if (this.m_modifiedCyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_modifiedCyclomaticComplexity;
        }
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    @Override
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setNumberOfLogicalOperations(int numberOfLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)numberOfLogicalOperations;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    public void setCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity = cyclomaticComplexity;
    }

    public void setModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity = modifiedCyclomaticComplexity;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public void setSerialNo(int serialNo) {
        this.m_serialNo = serialNo;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getMethodName() + "--" + Integer.toString(this.m_serialNo);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfStatements = reader.readInt();
        this.m_cyclomaticComplexity = reader.readInt();
        this.m_modifiedCyclomaticComplexity = reader.readInt();
        this.m_numberOfLogicalOperations = (short)reader.readInt();
        this.m_maxNesting = reader.readShort();
        this.m_serialNo = reader.readInt();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfStatements);
        writer.writeInt(this.m_cyclomaticComplexity);
        writer.writeInt(this.m_modifiedCyclomaticComplexity);
        writer.writeInt((int)this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_maxNesting);
        writer.writeInt(this.m_serialNo);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptMethodWithBody(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitTypescriptMethodWithBody(TypescriptFunctionOrMethodWithBody var1);
    }
}

