/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.parser.AbstractSourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import java.util.function.Predicate;

public final class TypescriptSourceLineProcessor
extends AbstractSourceLineProcessor {
    private static String OPERATOR_CHARS = "+-*/%~^<>!=|&";
    private int m_lineOffset = 0;
    private int m_startOffset = 0;
    private int m_offset = 0;
    private String m_currentLine;
    private ISourceLineProcessor.SourceLineVisitor m_visitor;
    private int m_endOffset;
    private boolean m_sawCode = false;
    private State m_currentState;
    private final StringBuilder m_buffer = new StringBuilder();
    private boolean m_lineIsEmpty;

    public TypescriptSourceLineProcessor() {
        this.reset();
    }

    private int readNext() {
        if (this.m_offset >= this.m_endOffset) {
            return -1;
        }
        return this.m_currentLine.charAt(this.m_offset);
    }

    protected void processLine(String line, ISourceLineProcessor.SourceLineVisitor visitor) {
        this.m_currentLine = line + "\n";
        this.m_offset = 0;
        this.m_endOffset = this.m_currentLine.length();
        this.m_visitor = visitor;
        this.m_lineIsEmpty = true;
        int c = this.readNext();
        while (c != -1) {
            this.m_currentState.processCharacter(c);
            ++this.m_offset;
            c = this.readNext();
        }
        if (!this.m_lineIsEmpty) {
            this.m_visitor.visitEndOfLine();
        }
        this.m_lineOffset += this.m_endOffset;
    }

    protected void reset() {
        this.m_currentState = new DefaultState(null);
        this.m_lineOffset = 0;
    }

    class DefaultState
    implements State {
        private final State m_parent;
        private boolean m_sawSlash = false;

        DefaultState(State parent) {
            this.m_parent = parent;
        }

        @Override
        public void processCharacter(int c) {
            if (this.m_sawSlash) {
                this.m_sawSlash = false;
                if (c == 47) {
                    boolean notEmpty;
                    String comment = TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_endOffset - 1);
                    boolean bl = notEmpty = comment.strip().length() > 2;
                    if (notEmpty) {
                        if (TypescriptSourceLineProcessor.this.m_sawCode) {
                            TypescriptSourceLineProcessor.this.m_visitor.visitEndOfCodeCommentLine();
                        }
                        TypescriptSourceLineProcessor.this.m_visitor.visitEndOfCommentLine();
                    }
                    TypescriptSourceLineProcessor.this.m_visitor.visitSingleLineComment(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, comment);
                    TypescriptSourceLineProcessor.this.m_offset = TypescriptSourceLineProcessor.this.m_endOffset - 1;
                } else if (c == 42) {
                    TypescriptSourceLineProcessor.this.m_currentState = new MultilineCommentState(this);
                } else {
                    TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
                    TypescriptSourceLineProcessor.this.m_sawCode = true;
                    if (c != 61) {
                        if (TypescriptSourceLineProcessor.this.m_currentLine.indexOf(47, TypescriptSourceLineProcessor.this.m_offset) > 0) {
                            TypescriptSourceLineProcessor.this.m_startOffset = --TypescriptSourceLineProcessor.this.m_offset;
                            TypescriptSourceLineProcessor.this.m_currentState = new RegexState(TypescriptSourceLineProcessor.this.m_currentState);
                        } else {
                            TypescriptSourceLineProcessor.this.m_visitor.visitOther(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_startOffset + 1));
                            --TypescriptSourceLineProcessor.this.m_offset;
                        }
                    } else {
                        TypescriptSourceLineProcessor.this.m_visitor.visitOther(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_startOffset + 2));
                    }
                }
            } else if (!Character.isWhitespace(c)) {
                TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset;
                switch (c) {
                    case 47: {
                        this.m_sawSlash = true;
                        break;
                    }
                    case 34: 
                    case 39: {
                        TypescriptSourceLineProcessor.this.m_currentState = new SimpleStringState(this, c);
                        break;
                    }
                    case 96: {
                        TypescriptSourceLineProcessor.this.m_currentState = new MultilineStringState(this);
                        break;
                    }
                    case 125: {
                        if (this.m_parent != null) {
                            TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset;
                            TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                            TypescriptSourceLineProcessor.this.m_buffer.append('}');
                            this.m_parent.setOriginalLineOffset(TypescriptSourceLineProcessor.this.m_lineOffset);
                            break;
                        }
                    }
                    default: {
                        if (Character.isJavaIdentifierStart(c)) {
                            TypescriptSourceLineProcessor.this.m_currentState = new WordState(this);
                            break;
                        }
                        if (OPERATOR_CHARS.indexOf(c) >= 0) {
                            TypescriptSourceLineProcessor.this.m_currentState = new OtherState(this, ch -> OPERATOR_CHARS.indexOf((int)ch) >= 0);
                            break;
                        }
                        if (Character.isDigit(c)) {
                            TypescriptSourceLineProcessor.this.m_currentState = new OtherState(this, ch -> Character.isDigit(ch));
                            break;
                        }
                        TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
                        TypescriptSourceLineProcessor.this.m_sawCode = true;
                        TypescriptSourceLineProcessor.this.m_visitor.visitOther(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_startOffset + 1));
                    }
                }
            }
        }
    }

    class MultilineCommentState
    implements State {
        private final State m_parent;
        private boolean m_sawAsterisk = false;
        private boolean m_lineIsEmpty = true;
        private final int m_originalLineOffset;

        MultilineCommentState(State parent) {
            this.m_parent = parent;
            TypescriptSourceLineProcessor.this.m_buffer.append("/*");
            this.m_originalLineOffset = TypescriptSourceLineProcessor.this.m_lineOffset;
        }

        @Override
        public void processCharacter(int c) {
            TypescriptSourceLineProcessor.this.m_buffer.append((char)c);
            if (this.m_sawAsterisk && c == 47) {
                TypescriptSourceLineProcessor.this.m_visitor.visitMultiLineComment(this.m_originalLineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_buffer.toString());
                TypescriptSourceLineProcessor.this.m_buffer.setLength(0);
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset + 1;
            } else {
                boolean bl = this.m_sawAsterisk = c == 42;
                if (c == 10) {
                    if (!this.m_lineIsEmpty) {
                        if (TypescriptSourceLineProcessor.this.m_sawCode) {
                            TypescriptSourceLineProcessor.this.m_visitor.visitEndOfCodeCommentLine();
                        }
                        TypescriptSourceLineProcessor.this.m_visitor.visitEndOfCommentLine();
                    }
                    this.m_lineIsEmpty = true;
                } else if (!Character.isWhitespace(c) && !this.m_sawAsterisk) {
                    this.m_lineIsEmpty = false;
                }
            }
        }
    }

    class MultilineStringState
    implements State {
        private final State m_parent;
        private boolean m_sawDollar = false;
        private int m_originalLineOffset;

        public MultilineStringState(State parent) {
            this.m_parent = parent;
            TypescriptSourceLineProcessor.this.m_buffer.append("`");
            this.m_originalLineOffset = TypescriptSourceLineProcessor.this.m_lineOffset;
        }

        @Override
        public void setOriginalLineOffset(int offset) {
            this.m_originalLineOffset = offset;
        }

        @Override
        public void processCharacter(int c) {
            TypescriptSourceLineProcessor.this.m_buffer.append((char)c);
            TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
            TypescriptSourceLineProcessor.this.m_sawCode = true;
            if (this.m_sawDollar) {
                this.m_sawDollar = false;
                if (c == 123) {
                    TypescriptSourceLineProcessor.this.m_visitor.visitStringLiteral(this.m_originalLineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_buffer.toString());
                    TypescriptSourceLineProcessor.this.m_buffer.setLength(0);
                    TypescriptSourceLineProcessor.this.m_currentState = new DefaultState(this);
                    TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset + 1;
                }
            } else if (c == 36) {
                this.m_sawDollar = true;
            } else if (c == 96) {
                TypescriptSourceLineProcessor.this.m_visitor.visitStringLiteral(this.m_originalLineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_buffer.toString());
                TypescriptSourceLineProcessor.this.m_buffer.setLength(0);
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
            }
        }
    }

    class OtherState
    implements State {
        private final State m_parent;
        private final Predicate<Integer> m_included;

        public OtherState(State parent, Predicate<Integer> included) {
            this.m_parent = parent;
            this.m_included = included;
        }

        @Override
        public void processCharacter(int c) {
            if (!this.m_included.test(c)) {
                TypescriptSourceLineProcessor.this.m_visitor.visitOther(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_offset));
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
                TypescriptSourceLineProcessor.this.m_sawCode = true;
                --TypescriptSourceLineProcessor.this.m_offset;
            }
        }
    }

    class RegexState
    implements State {
        private final State m_parent;
        private boolean m_inCharClass = false;
        private boolean m_escaped = false;

        RegexState(State parent) {
            this.m_parent = parent;
        }

        @Override
        public void processCharacter(int c) {
            if (this.m_escaped) {
                this.m_escaped = false;
            } else if (c == 92) {
                this.m_escaped = true;
            } else if (this.m_inCharClass) {
                if (c == 93) {
                    this.m_inCharClass = false;
                }
            } else if (c == 91) {
                this.m_inCharClass = true;
            } else if (c == 47) {
                TypescriptSourceLineProcessor.this.m_visitor.visitStringLiteral(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_offset + 1));
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset + 1;
            }
        }
    }

    class SimpleStringState
    implements State {
        private final State m_parent;
        private final int m_terminator;
        private boolean m_sawBackslash = false;

        SimpleStringState(State parent, int terminator) {
            this.m_parent = parent;
            this.m_terminator = terminator;
        }

        @Override
        public void processCharacter(int c) {
            if (!this.m_sawBackslash && c == this.m_terminator) {
                String literal = TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_offset + 1);
                TypescriptSourceLineProcessor.this.m_visitor.visitStringLiteral(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, literal);
                TypescriptSourceLineProcessor.this.m_sawCode = true;
                TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                TypescriptSourceLineProcessor.this.m_startOffset = TypescriptSourceLineProcessor.this.m_offset + 1;
            } else {
                this.m_sawBackslash = this.m_sawBackslash ? false : c == 92;
            }
        }
    }

    static interface State {
        public void processCharacter(int var1);

        default public void setOriginalLineOffset(int offset) {
        }
    }

    class WordState
    implements State {
        private final State m_parent;

        WordState(State parent) {
            this.m_parent = parent;
        }

        @Override
        public void processCharacter(int c) {
            if (!Character.isJavaIdentifierPart(c)) {
                TypescriptSourceLineProcessor.this.m_visitor.visitWord(TypescriptSourceLineProcessor.this.m_lineOffset + TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_currentLine.substring(TypescriptSourceLineProcessor.this.m_startOffset, TypescriptSourceLineProcessor.this.m_offset));
                TypescriptSourceLineProcessor.this.m_lineIsEmpty = false;
                TypescriptSourceLineProcessor.this.m_sawCode = true;
                TypescriptSourceLineProcessor.this.m_currentState = this.m_parent;
                --TypescriptSourceLineProcessor.this.m_offset;
            }
        }
    }
}

