/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericField;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericScript;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericWeakRootDirectory;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.IModelBuilder;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.NodeParserScript;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.path.TypescriptDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.path.TypescriptSourceFile;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptClass;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptDependency;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptEnum;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptEnumMember;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethod;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethodKind;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethodWithBody;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptInterface;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptNamespace;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptProperty;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptTypeAlias;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptVariable;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptConfigFile;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptExternal;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelBuilder
implements IModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBuilder.class);
    private final int ID_OFFSET = 2;
    private final String MS_PER_FILE = "msPerFile";
    private final String DEFAULT_MS_PER_FILE = "26.5";
    private static final int SOURCE_PROCESSING_DAEMONS = 6;
    private final ExecutorService m_sourceProcessorService;
    private final IAddedOrChangedSourceFileProcessor m_sourceProcessor;
    private final SoftwareSystem m_softwareSystem;
    private final RootDirectoryPath m_rootPath;
    private final External m_external;
    private final Map<String, SourceFile> m_sourceMap = new THashMap();
    private final List<TFile> m_sourcesWithDifferentRoots = new ArrayList<TFile>();
    private final Map<String, RootDirectoryPath> m_rootMap = new THashMap();
    private final MultipleValueMap<String, SourceFile> m_nodeModulesFiles = new MultipleValueMap();
    private final List<SourceFile> m_internals = new ArrayList<SourceFile>();
    private ArrayList<NamedElement> m_elementList;
    private int m_nextId = 1;

    public ModelBuilder(IAddedOrChangedSourceFileProcessor sourceProcessor, SoftwareSystem system) {
        assert (sourceProcessor != null) : "Parameter 'sourceProcessor' of method 'ModelBuilder' must not be null";
        assert (system != null) : "Parameter 'system' of method 'ModelBuilder' must not be null";
        this.m_sourceProcessor = sourceProcessor;
        this.m_sourceProcessorService = Executors.newFixedThreadPool(6);
        this.m_softwareSystem = system;
        Workspace ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        TypescriptModule module = (TypescriptModule)((Object)ws.getFirstChild(TypescriptModule.class));
        assert (module != null);
        this.m_rootPath = (RootDirectoryPath)module.getFirstChild(RootDirectoryPath.class);
        this.m_external = (External)ws.getUniqueExistingChild(TypescriptExternal.class);
        this.m_rootPath.forgetChildren(true);
        this.m_external.forgetChildren(true);
        module.getChildren(GenericWeakRootDirectory.class).forEach(c -> c.remove());
    }

    private SourceFile createSourceFileElement(RootDirectoryPath rootDir, TFile sourceFilePath) {
        String relPath = FileUtility.calculateRelativePath((TFile)sourceFilePath.getParentFile(), (TFile)rootDir.getDirectoryFile());
        IDirectoryPath directoryPath = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)rootDir, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new TypescriptDirectoryFragment(msp, parent, name);
            }
        });
        TypescriptSourceFile source = new TypescriptSourceFile((IModelServiceProvider)this.m_softwareSystem, directoryPath.getNamedElement(), sourceFilePath.getNormalizedAbsoluteFile());
        directoryPath.getNamedElement().addChild((NamedElement)source);
        if (!source.isExternal()) {
            this.m_sourceProcessorService.submit(() -> this.lambda$1((SourceFile)source));
        }
        this.m_sourceMap.put(sourceFilePath.getPath(), (SourceFile)source);
        if (source.isExternal()) {
            if (sourceFilePath.getAbsolutePath().contains("node_modules")) {
                this.m_nodeModulesFiles.put((Object)source.getShortName(), (Object)source);
            }
        } else {
            this.m_internals.add((SourceFile)source);
        }
        return source;
    }

    @Override
    public void processSourceFile(String path) {
        TFile sourceFilePath = new TFile(path);
        if (this.m_rootPath.getDirectoryFile().isParentOf((File)sourceFilePath)) {
            this.createSourceFileElement(this.m_rootPath, sourceFilePath);
        } else {
            this.m_sourcesWithDifferentRoots.add(sourceFilePath);
        }
    }

    @Override
    public void finishSourceProcessing() {
        if (this.m_sourcesWithDifferentRoots.isEmpty()) {
            return;
        }
        TFile root = FileUtility.findCommonBaseDirectory(this.m_sourcesWithDifferentRoots);
        assert (root != null);
        GenericWeakRootDirectory rootDir = new GenericWeakRootDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)this.m_external, root);
        this.m_external.addChild((NamedElement)rootDir);
        for (TFile src : this.m_sourcesWithDifferentRoots) {
            this.createSourceFileElement((RootDirectoryPath)rootDir, src);
        }
    }

    public OperationResult buildModel(IWorkerContext workerContext, String nodePath) {
        Workspace ws;
        TypescriptSystemSettings settings;
        TypescriptConfigFile configFile;
        NodeParserScript parser;
        OperationResultWithOutcome<JSONObject> result;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'buildModel' must not be null";
        assert (nodePath != null && nodePath.length() > 0) : "Parameter 'nodePath' of method 'buildModel' must not be empty";
        String msPerFile = this.m_softwareSystem.getSystemProperty("msPerFile");
        if (msPerFile == null) {
            msPerFile = "26.5";
        }
        if ((result = (parser = new NodeParserScript(this, nodePath)).run(workerContext, (configFile = (TypescriptConfigFile)((Object)(settings = (TypescriptSystemSettings)((Object)(ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(TypescriptSystemSettings.class))).getUniqueExistingChild(TypescriptConfigFile.class))).getAbsolutePath(), Double.valueOf(msPerFile))).isSuccess()) {
            this.m_softwareSystem.setSystemProperty("msPerFile", Double.toString(parser.getMsPerFile()));
            JSONObject modelRoot = (JSONObject)result.getOutcome();
            JSONArray children = (JSONArray)modelRoot.get((Object)"children");
            assert (children != null);
            int numberOfElements = ((Number)modelRoot.get((Object)"numberOfElements")).intValue();
            this.m_elementList = new ArrayList(numberOfElements);
            int i = 0;
            while (i < numberOfElements) {
                this.m_elementList.add(null);
                ++i;
            }
            children.forEach(c -> this.buildModelFor((JSONObject)c, null));
            JSONArray dependencies = (JSONArray)modelRoot.get((Object)"dependencies");
            assert (dependencies != null);
            for (Object dep : dependencies) {
                this.handleDependency((JSONArray)dep);
            }
            this.processInternalizedNodeModules();
        }
        this.m_sourceProcessorService.shutdown();
        try {
            this.m_sourceProcessorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private void processInternalizedNodeModules() {
        for (SourceFile src : this.m_internals) {
            ArrayList<SourceFile> merged = new ArrayList<SourceFile>();
            TFile srcFile = src.getFile();
            for (SourceFile externalSrc : this.m_nodeModulesFiles.get((Object)src.getShortName())) {
                TFile externalFile = externalSrc.getFile();
                long length = srcFile.length();
                if (length <= 0L || length != externalFile.length() || !FileUtility.filesHaveSameContent((TFile)srcFile, (TFile)externalFile)) continue;
                this.mergeFiles(src, externalSrc);
                merged.add(externalSrc);
            }
            merged.forEach(extSrc -> {
                boolean bl = this.m_nodeModulesFiles.remove((Object)src.getShortName(), extSrc);
            });
        }
    }

    private void merge(NamedElement e1, NamedElement e2) {
        int count1 = e1.getNumberOfChildren();
        int count2 = e2.getNumberOfChildren();
        assert (count1 == count2 || count1 - 1 == count2);
        List list1 = e1.getChildrenList();
        List list2 = e2.getChildrenList();
        int i = 0;
        while (i < count2) {
            this.merge((NamedElement)list1.get(i), (NamedElement)list2.get(i));
            ++i;
        }
        if (e1 instanceof ProgrammingElement) {
            ProgrammingElement p1 = (ProgrammingElement)e1;
            ProgrammingElement p2 = (ProgrammingElement)e2;
            p1.mergeDependenciesFrom(p2);
        }
    }

    private void mergeFiles(SourceFile internal, SourceFile external) {
        this.merge((NamedElement)internal, (NamedElement)external);
        external.remove();
    }

    private void handleDependency(JSONArray dep) {
        int fromId = ((Number)dep.get(0)).intValue();
        int toId = ((Number)dep.get(1)).intValue();
        int line = ((Number)dep.get(2)).intValue();
        String type = (String)dep.get(3);
        NamedElement from = this.m_elementList.get(fromId - 2);
        NamedElement to = this.m_elementList.get(toId - 2);
        ProgrammingElement fromElement = null;
        if (from == null || to == null) {
            return;
        }
        if (from instanceof SourceFile) {
            SourceFile sf = (SourceFile)from;
            GenericScript gs = (GenericScript)from.getUniqueChild(GenericScript.class);
            if (gs == null) {
                gs = new GenericScript((IModelServiceProvider)this.m_softwareSystem, (NamedElement)sf, FileUtility.getFileNameWithoutExtension((TFile)sf.getFile()));
                sf.addChild((NamedElement)gs);
            }
            fromElement = gs;
        } else if (from instanceof ProgrammingElement) {
            fromElement = (ProgrammingElement)from;
        } else {
            LOGGER.warn(String.format("Unexpected from of type '%s' (%s:%d)", from.getClass().getName(), ((SourceFile)from.getParent(SourceFile.class, new Class[0])).getName(), line));
        }
        if (fromElement != null && to instanceof ProgrammingElement) {
            ProgrammingElement toElement = (ProgrammingElement)to;
            TypescriptDependency pd = new TypescriptDependency(fromElement, toElement, type, line);
            fromElement.addDependencyIfNotPresent((ParserDependency)pd);
        }
    }

    private NamedElement handleSourceFile(JSONObject sourceFileObj, int id, String name) {
        Boolean isExternal = (Boolean)sourceFileObj.get((Object)"isExternal");
        SourceFile result = null;
        if (isExternal.booleanValue()) {
            TFile sourceFile = new TFile(name);
            boolean fileExists = sourceFile.canRead();
            int pos = name.indexOf("/node_modules/");
            RootDirectoryPath root = null;
            String rootPath = null;
            if (pos >= 0) {
                rootPath = name.substring(0, pos + 13);
                if (!fileExists) {
                    rootPath = rootPath.replace("node_modules", "node_runtime");
                    name = name.replace("node_modules", "node_runtime");
                    sourceFile = new TFile(name);
                }
            } else {
                pos = name.lastIndexOf(47);
                assert (pos > 0);
                rootPath = name.substring(0, pos);
            }
            if ((root = this.m_rootMap.get(rootPath)) == null) {
                root = new GenericWeakRootDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)this.m_external, new TFile(rootPath));
                this.m_external.addChild((NamedElement)root);
                this.m_rootMap.put(rootPath, root);
            }
            result = this.createSourceFileElement(root, sourceFile);
        } else {
            result = this.m_sourceMap.get(new TFile(name).getPath());
            JSONArray bodyMetrics = (JSONArray)sourceFileObj.get((Object)"bodyMetrics");
            if (bodyMetrics != null) {
                GenericScript gs = new GenericScript((IModelServiceProvider)this.m_softwareSystem, (NamedElement)result, FileUtility.getFileNameWithoutExtension((TFile)result.getFile()));
                result.addChild((NamedElement)gs);
                gs.setNumberOfStatements(((Number)bodyMetrics.get(0)).intValue());
                gs.setCyclomaticComplexity(((Number)bodyMetrics.get(1)).intValue());
                gs.setModifiedCyclomaticComplexity(((Number)bodyMetrics.get(2)).intValue());
                gs.setNumberOfLogicalOperations(((Number)bodyMetrics.get(3)).intValue());
                gs.setMaxNesting(((Number)bodyMetrics.get(4)).intValue());
            }
        }
        return result;
    }

    private void buildModelFor(JSONObject obj, NamedElement parent) {
        NamedElement result;
        int id;
        block52: {
            String kind;
            String name;
            block51: {
                JSONArray idNameKind = (JSONArray)obj.get((Object)"idNameKind");
                id = ((Number)idNameKind.get(0)).intValue();
                name = (String)idNameKind.get(1);
                kind = (String)idNameKind.get(2);
                result = null;
                boolean isSource = kind.equals("SourceFile");
                if (!isSource) break block51;
                result = this.handleSourceFile(obj, id, name);
                break block52;
            }
            int line = ((Number)obj.get((Object)"line")).intValue();
            assert (parent != null);
            switch (kind) {
                case "Class": {
                    result = this.handleClass(obj, parent, name, line);
                    break;
                }
                case "Interface": {
                    result = this.handleInterface(obj, parent, name, line);
                    break;
                }
                case "Property": {
                    result = this.handleProperty(obj, parent, name, line);
                    break;
                }
                case "Variable": {
                    result = this.handleVariable(obj, parent, name, line);
                    break;
                }
                case "Function": {
                    result = this.handleFunction(obj, parent, name, line);
                    break;
                }
                case "Method": {
                    result = this.handleMethod(obj, parent, name, line);
                    break;
                }
                case "Constructor": {
                    result = this.handleConstructor(obj, parent, name, line);
                    break;
                }
                case "Setter": {
                    result = this.handleSetter(obj, parent, name, line);
                    break;
                }
                case "Getter": {
                    result = this.handleGetter(obj, parent, name, line);
                    break;
                }
                case "Enum": {
                    result = this.handleEnum(obj, parent, name, line);
                    break;
                }
                case "EnumMember": {
                    result = this.handleEnumMember(obj, parent, name, line);
                    break;
                }
                case "Namespace": {
                    result = this.handleNamespace(obj, parent, name, line);
                    break;
                }
                case "TypeAlias": {
                    result = this.handleTypeAlias(obj, parent, name, line);
                    break;
                }
                default: {
                    LOGGER.error("Unexpected element: " + kind);
                }
            }
        }
        if (result == null) {
            return;
        }
        if (parent != null) {
            String fqnPart = result.getFullyQualifiedNamePart();
            NamedElement match = parent.getChildren().stream().filter(c -> c.getFullyQualifiedNamePart().equals(fqnPart)).findFirst().orElse(null);
            if (match != null) {
                this.m_elementList.set(id - 2, match);
                result = match;
            } else {
                parent.addChild(result);
                this.m_elementList.set(id - 2, result);
            }
        } else {
            this.m_elementList.set(id - 2, result);
        }
        JSONArray children = (JSONArray)obj.get((Object)"children");
        assert (children != null);
        for (Object child : children) {
            this.buildModelFor((JSONObject)child, result);
        }
    }

    private NamedElement handleTypeAlias(JSONObject obj, NamedElement parent, String name, int line) {
        String typeParams = (String)obj.get((Object)"typeParameters");
        assert (typeParams != null);
        TypescriptTypeAlias ta = new TypescriptTypeAlias((IModelServiceProvider)this.m_softwareSystem, parent, name, line);
        ta.setTypeParameters(typeParams);
        return ta;
    }

    private NamedElement handleNamespace(JSONObject obj, NamedElement parent, String name, int line) {
        TypescriptNamespace ns = new TypescriptNamespace((IModelServiceProvider)this.m_softwareSystem, parent, name, line);
        return ns;
    }

    private NamedElement handleEnumMember(JSONObject obj, NamedElement parent, String name, int line) {
        TypescriptEnumMember result = new TypescriptEnumMember((IModelServiceProvider)this.m_softwareSystem, parent, name, line);
        return result;
    }

    private NamedElement handleEnum(JSONObject obj, NamedElement parent, String name, int line) {
        TypescriptEnum result = new TypescriptEnum((IModelServiceProvider)this.m_softwareSystem, parent, name, line);
        return result;
    }

    private NamedElement createMethod(JSONObject obj, NamedElement parent, String name, int line, TypescriptFunctionOrMethodKind kind) {
        Boolean isAbstract = (Boolean)obj.get((Object)"isAbstract");
        Number noParameters = (Number)obj.get((Object)"numberOfParameters");
        Boolean hasBody = (Boolean)obj.get((Object)"hasBody");
        String parameters = (String)obj.get((Object)"parameters");
        String typeParameters = (String)obj.get((Object)"typeParameters");
        String returnType = (String)obj.get((Object)"returnType");
        assert (isAbstract != null);
        assert (noParameters != null);
        assert (hasBody != null);
        TypescriptFunctionOrMethod result = null;
        if (hasBody.booleanValue()) {
            TypescriptFunctionOrMethodWithBody funct = new TypescriptFunctionOrMethodWithBody((IModelServiceProvider)this.m_softwareSystem, parent, name, line, noParameters.intValue(), isAbstract, kind);
            JSONArray bodyMetrics = (JSONArray)obj.get((Object)"bodyMetrics");
            funct.setNumberOfStatements(((Number)bodyMetrics.get(0)).intValue());
            funct.setCyclomaticComplexity(((Number)bodyMetrics.get(1)).intValue());
            funct.setModifiedCyclomaticComplexity(((Number)bodyMetrics.get(2)).intValue());
            funct.setNumberOfLogicalOperations(((Number)bodyMetrics.get(3)).intValue());
            funct.setMaxNesting(((Number)bodyMetrics.get(4)).intValue());
            funct.setSerialNo(this.m_nextId++);
            result = funct;
        } else {
            result = new TypescriptFunctionOrMethod((IModelServiceProvider)this.m_softwareSystem, parent, name, line, noParameters.intValue(), isAbstract, kind);
        }
        result.setParameters(parameters);
        result.setTypeParameters(typeParameters);
        result.setReturnType(returnType);
        return result;
    }

    private NamedElement handleSetter(JSONObject obj, NamedElement parent, String name, int line) {
        return this.createMethod(obj, parent, name, line, TypescriptFunctionOrMethodKind.SETTER);
    }

    private NamedElement handleGetter(JSONObject obj, NamedElement parent, String name, int line) {
        return this.createMethod(obj, parent, name, line, TypescriptFunctionOrMethodKind.GETTER);
    }

    private NamedElement handleConstructor(JSONObject obj, NamedElement parent, String name, int line) {
        return this.createMethod(obj, parent, name, line, TypescriptFunctionOrMethodKind.CONSTRUCTOR);
    }

    private NamedElement handleMethod(JSONObject obj, NamedElement parent, String name, int line) {
        return this.createMethod(obj, parent, name, line, TypescriptFunctionOrMethodKind.METHOD);
    }

    private NamedElement handleFunction(JSONObject obj, NamedElement parent, String name, int line) {
        return this.createMethod(obj, parent, name, line, TypescriptFunctionOrMethodKind.FUNCTION);
    }

    private NamedElement handleVariable(JSONObject obj, NamedElement parent, String name, int line) {
        Object result = parent instanceof IType ? new GenericField((IModelServiceProvider)this.m_softwareSystem, parent, name, false, line) : new TypescriptVariable((IModelServiceProvider)this.m_softwareSystem, parent, name, line, this.m_nextId++);
        return result;
    }

    private NamedElement handleProperty(JSONObject obj, NamedElement parent, String name, int line) {
        TypescriptProperty prop = new TypescriptProperty((IModelServiceProvider)this.m_softwareSystem, parent, name, line);
        return prop;
    }

    private NamedElement handleInterface(JSONObject obj, NamedElement parent, String name, int line) {
        TypescriptInterface result = new TypescriptInterface((IModelServiceProvider)this.m_softwareSystem, parent, name, line, this.m_nextId++);
        String typeParams = (String)obj.get((Object)"typeParameters");
        result.setTypeParameters(typeParams);
        return result;
    }

    private NamedElement handleClass(JSONObject obj, NamedElement parent, String name, int line) {
        Boolean isAbstract = (Boolean)obj.get((Object)"isAbstract");
        String typeParams = (String)obj.get((Object)"typeParameters");
        assert (isAbstract != null);
        assert (typeParams != null);
        TypescriptClass result = new TypescriptClass((IModelServiceProvider)this.m_softwareSystem, parent, name, line, isAbstract);
        result.setTypeParameters(typeParams);
        return result;
    }

    private /* synthetic */ void lambda$1(SourceFile sourceFile) {
        this.m_sourceProcessor.processAddedOrChangedSourceFile(sourceFile);
    }
}

