/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture.TypescriptTypeHierarchyRetriever;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptDependencyType;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptInterface;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Set;

public final class TypescriptImplementsInterfaceRetriever
extends TypescriptTypeHierarchyRetriever {
    public String getName() {
        return "TypescriptImplementsInterface";
    }

    public String getShortName() {
        return "ImplementsInterface";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified name of any direct or indirect base interface.\n\nPlease note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    @Override
    protected void collect(IWorkerContext workerContext, ProgrammingElement type, Set<String> collector) {
        THashSet visited = new THashSet();
        this.collect(workerContext, type, collector, (Set<ProgrammingElement>)visited);
    }

    private void collect(IWorkerContext workerContext, ProgrammingElement type, Set<String> collector, Set<ProgrammingElement> visited) {
        if (!visited.add(type)) {
            return;
        }
        Set data = this.getData((NamedElement)type);
        if (data == null) {
            List deps = type.getOutgoingDependencies(new IParserDependencyType[]{TypescriptDependencyType.EXTENDS, TypescriptDependencyType.IMPLEMENTS});
            data = new THashSet();
            for (ParserDependency dep : deps) {
                ProgrammingElement baseType = dep.getTo();
                if (baseType instanceof TypescriptInterface) {
                    data.add(this.cutOffGenericParameters(baseType.getName()));
                }
                this.collect(workerContext, baseType, data, visited);
            }
            this.setData((NamedElement)type, data);
        }
        collector.addAll(data);
    }
}

