/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.DirectoryDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.CoreInternalDirectoryProcessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.DirectoryCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.element.TypescriptProviderId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptMetricLevel;
import java.util.Collection;
import java.util.List;

public final class TypescriptDirectoryCyclesInModulesAnalyzerAdapter
extends CyclesAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = TypescriptAnalyzerId.TYPESCRIPT_DIRECTORY_CYCLES_MODULE;
    private final IMetricDescriptor m_numberOfIncomingDependencies;
    private final IMetricDescriptor m_numberOfOutgoingDependencies;
    private final IMetricDescriptor m_instability;
    private final IMetricDescriptor m_abstractnessDescriptor;
    private final IMetricDescriptor m_distanceDescriptor;

    public TypescriptDirectoryCyclesInModulesAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = ((IMetricsProvider)this.getInstallation().getExtension(IMetricsProvider.class)).getMetricProvider((IProviderId)TypescriptProviderId.INSTANCE);
        this.m_numberOfIncomingDependencies = this.addMetricDescriptorIfNotExistent(mp, (IMetricId)CoreMetricId.CORE_INCOMING_DEPENDENCIES_MODULE, TypescriptMetricLevel.TYPESCRIPT_DIRECTORY);
        this.m_numberOfOutgoingDependencies = this.addMetricDescriptorIfNotExistent(mp, (IMetricId)CoreMetricId.CORE_OUTGOING_DEPENDENCIES_MODULE, TypescriptMetricLevel.TYPESCRIPT_DIRECTORY);
        this.m_instability = this.addMetricDescriptorIfNotExistent(mp, (IMetricId)CoreMetricId.CORE_INSTABILITY_MODULE, TypescriptMetricLevel.TYPESCRIPT_DIRECTORY);
        this.m_abstractnessDescriptor = this.addMetricDescriptorIfNotExistent(mp, (IMetricId)CoreMetricId.CORE_ABSTRACTNESS_MODULE, TypescriptMetricLevel.TYPESCRIPT_DIRECTORY);
        this.m_distanceDescriptor = this.addMetricDescriptorIfNotExistent(mp, (IMetricId)CoreMetricId.CORE_DISTANCE_MODULE, TypescriptMetricLevel.TYPESCRIPT_DIRECTORY);
    }

    protected IIssueId getIssueId() {
        return DirectoryCycleGroup.ISSUE_ID;
    }

    protected void runJobs(AnalyzerResult result) {
        DirectoryCyclesInModulesJob job = new DirectoryCyclesInModulesJob(this.getGroup(), result, this.getController(), (Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class));
        job.start();
    }

    private class DirectoryCyclesInModulesJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJobOnModules {
        private final DirectoryDependencyEndpointCollector m_collector;
        private final ValueList m_abstractness;
        private final ValueList m_distance;

        DirectoryCyclesInModulesJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Workspace workspace) {
            super((CyclesAnalyzerAdapter)TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this, group, result, controller, workspace);
            this.m_collector = new DirectoryDependencyEndpointCollector();
            this.setInstabilityMetric(TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.m_instability);
            this.setNumberOfIncomingDependenciesMetric(TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.m_numberOfIncomingDependencies);
            this.setNumberOfOutgoingDependenciesMetric(TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.m_numberOfOutgoingDependencies);
            this.m_abstractness = TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.createValueList(result, TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.m_abstractnessDescriptor, null);
            this.m_distance = TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.createValueList(result, TypescriptDirectoryCyclesInModulesAnalyzerAdapter.this.m_distanceDescriptor, null);
        }

        protected Language getLanguage() {
            return TypescriptLanguage.INSTANCE;
        }

        protected Collection<? extends NamedElement> getNamedElements() {
            CoreInternalDirectoryProcessor processor = new CoreInternalDirectoryProcessor();
            this.getScope().accept((NamedElement.INamedElementVisitor)processor);
            processor.getDirectoriesWithComponents().forEach(d -> this.m_collector.addDirectory(d));
            return processor.getDirectoriesWithComponentsAsNamedElements();
        }

        protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Collection<? extends NamedElement> elements) {
            assert (elements != null) : "Parameter 'elements' of method 'createNodeAdapterSet' must not be null";
            return new ParserDependencyNodeAdapterSet(this.getWorkerContext(), elements, (DependencyEndpointCollector)this.m_collector, PE, PD);
        }

        protected List<IType> getTypes(NamedElement namedElement) {
            assert (namedElement != null && namedElement instanceof IDirectoryPath) : "Unexpected class in method 'getTypes': " + String.valueOf(namedElement);
            return CoreInternalDirectoryProcessor.collectTypesFromInternalDirectory((IDirectoryPath)((IDirectoryPath)namedElement));
        }

        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new DirectoryCycleGroup(null, this.getScope(), isCritical);
        }

        protected boolean discardIfContainedInOneModule() {
            return false;
        }

        protected void setDistance(NamedElement e, float value) {
            this.m_distance.addValue(e, (Number)Float.valueOf(value));
        }

        protected void setAbstractness(NamedElement e, float value) {
            this.m_abstractness.addValue(e, (Number)Float.valueOf(value));
        }
    }
}

