/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.typescript.command.system.TypescriptCommandId;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptWorkspaceExtension;
import de.schlichtherle.truezip.file.TFile;

public final class CreateNewTypescriptSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    public static final ICommandId ID = TypescriptCommandId.CREATE_SOFTWARE_SYSTEM_FROM_TS_CONFIG_FILE;
    private final IInteraction m_interaction;

    public CreateNewTypescriptSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewTypescriptSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return ID;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        TsConfigFileData data = new TsConfigFileData();
        if (!this.m_interaction.collectTsConfigData(data)) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            return;
        }
        SoftwareSystem system = this.getController().getSoftwareSystem();
        TypescriptWorkspaceExtension wsExt = (TypescriptWorkspaceExtension)system.getExtension(TypescriptWorkspaceExtension.class);
        OperationResult result = new OperationResult("Initializing Typescript System");
        wsExt.initTypescriptSoftwareSystem(result, data.getTsConfigFile());
        if (!result.isFailure()) {
            OperationResult saveResult = this.getController().saveSoftwareSystem();
            result.addMessagesFrom(saveResult);
        }
        if (result.isFailure()) {
            this.m_interaction.processResult(result);
        }
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collectTsConfigData(TsConfigFileData var1);

        public void processResult(OperationResult var1);
    }

    public static class TsConfigFileData
    implements ICommandInteractionData {
        private TFile m_tsconfigFile;

        public TFile getTsConfigFile() {
            return this.m_tsconfigFile;
        }

        public void setTsConfigFile(TFile tsConfigFile) {
            assert (tsConfigFile != null) : "Parameter 'tsConfigFile' of method 'setTsConfigFile' must not be null";
            this.m_tsconfigFile = tsConfigFile;
        }
    }
}

