/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.text.CommentRemover;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptMessageCause;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

final class TsConfigFileHelper {
    private TsConfigFileHelper() {
    }

    private static TFile doExtractRootDirectorFromTsConfig(OperationResult result, TFile tsConfigFile) {
        String rootDir;
        block7: {
            String jsonContent = FileUtility.getFileContent((TFile)tsConfigFile);
            jsonContent = CommentRemover.removeJavaStyleComments((String)jsonContent);
            JSONParser parser = new JSONParser();
            JSONObject configData = (JSONObject)parser.parse(jsonContent);
            JSONObject options = (JSONObject)configData.get((Object)"compilerOptions");
            if (options == null) {
                result.addWarning((OperationResult.IMessageCause)TypescriptMessageCause.MALFORMED_TSCONFIG_FILE, "The field 'compilerOptions' is missing in tsconfig.json", new Object[0]);
                return tsConfigFile.getParentFile();
            }
            rootDir = (String)options.get((Object)"rootDir");
            if (rootDir != null) break block7;
            return null;
        }
        try {
            if (rootDir.startsWith("./")) {
                rootDir = rootDir.substring(2);
            }
            return new TFile((File)tsConfigFile.getParentFile(), rootDir).getNormalizedAbsoluteFile();
        }
        catch (ClassCastException ex) {
            result.addError((OperationResult.IMessageCause)TypescriptMessageCause.MALFORMED_TSCONFIG_FILE, "Unexpected content in tsconfig.json", new Object[0]);
            return null;
        }
        catch (ParseException ex) {
            result.addError((OperationResult.IMessageCause)TypescriptMessageCause.MALFORMED_TSCONFIG_FILE, "Syntax error in tsconfig.json: " + ex.getMessage(), new Object[0]);
            return null;
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, ex.getMessage(), new Object[0]);
            return null;
        }
    }

    static TFile extractRootDirectorFromTsConfig(OperationResult result, TFile tsConfigFile) {
        TFile rootDir = TsConfigFileHelper.doExtractRootDirectorFromTsConfig(result, tsConfigFile);
        if (rootDir == null && !(rootDir = new TFile((File)tsConfigFile.getParentFile(), "src")).isDirectory()) {
            rootDir = tsConfigFile.getParentFile();
        }
        return rootDir;
    }

    static String removeComments(String input) {
        assert (input != null) : "Parameter 'input' of method 'removeComments' must not be null";
        StringReader reader = new StringReader(input);
        StringBuilder result = new StringBuilder();
        State state = State.DEFAULT;
        try {
            int c;
            while ((c = reader.read()) != -1) {
                switch (state) {
                    case DEFAULT: {
                        if (c == 47) {
                            state = State.SAW_SLASH;
                            break;
                        }
                        if (c == 34) {
                            state = State.IN_STRING;
                            result.append((char)c);
                            break;
                        }
                        result.append((char)c);
                        break;
                    }
                    case IN_STRING: {
                        result.append((char)c);
                        if (c == 34) {
                            state = State.DEFAULT;
                            break;
                        }
                        if (c != 92) break;
                        state = State.ESCAPED;
                        break;
                    }
                    case ESCAPED: {
                        result.append((char)c);
                        state = State.IN_STRING;
                        break;
                    }
                    case SAW_SLASH: {
                        if (c == 42) {
                            state = State.IN_COMMENT;
                            break;
                        }
                        result.append('/').append((char)c);
                        state = State.DEFAULT;
                        break;
                    }
                    case IN_COMMENT: {
                        if (c != 42) break;
                        state = State.SAW_ASTERISK;
                        break;
                    }
                    case SAW_ASTERISK: {
                        if (c == 47) {
                            state = State.DEFAULT;
                            break;
                        }
                        if (c == 42) break;
                        state = State.IN_COMMENT;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    private static enum State {
        DEFAULT,
        IN_STRING,
        ESCAPED,
        IN_COMMENT,
        SAW_SLASH,
        SAW_ASTERISK;

    }
}

