/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.persistence.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.XmlAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptConfigFile;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptModuleType;
import com.hello2morrow.sonargraph.languageprovider.typescript.persistence.system.ObjectFactory;
import com.hello2morrow.sonargraph.languageprovider.typescript.persistence.system.XsdTypescriptSystemConfiguration;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class TypescriptPersistenceProvider
extends XmlAdditionalInfoProvider {
    private final XmlPersistenceContext m_persistenceContext = new XmlPersistenceContext("com.hello2morrow.sonargraph.languageprovider.typescript.persistence.system", TypescriptResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, "com/hello2morrow/sonargraph/languageprovider/typescript/persistence/system/typescriptSoftwareSystem"));

    public TypescriptPersistenceProvider(Installation installation) {
        super(installation);
    }

    public XmlPersistenceContext getPersistentContext() {
        return this.m_persistenceContext;
    }

    public Language getLanguage() {
        return TypescriptLanguage.INSTANCE;
    }

    protected XsdAbstractModule createXmlModule(Module.IModuleType moduleType) {
        return new XsdAbstractModule();
    }

    protected XsdAbstractModuleDependency createWorkspaceDependency(Module origin, WorkspaceDependency dependency) {
        return null;
    }

    public WorkspaceDependency.IWorkspaceDependencyType getWorkspaceDependencyType(Class<? extends XsdAbstractModuleDependency> clazz) {
        return null;
    }

    public Module.IModuleType getModuleType(Class<? extends XsdAbstractModule> clazz) {
        return TypescriptModuleType.TYPESCRIPT_MODULE;
    }

    private void addConfigFileToSystem(SoftwareSystem softwareSystem, TFile configFilePath) {
        TypescriptConfigFile configFile;
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        TypescriptSystemSettings settings = (TypescriptSystemSettings)((Object)ws.getUniqueChild(TypescriptSystemSettings.class));
        if (settings == null) {
            settings = new TypescriptSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)settings);
        }
        if ((configFile = (TypescriptConfigFile)((Object)settings.getUniqueChild(TypescriptConfigFile.class))) == null) {
            configFile = new TypescriptConfigFile((NamedElement)settings, configFilePath);
            settings.addChild((NamedElement)configFile);
        }
    }

    public void getSystemDetailsFromXml(SoftwareSystem softwareSystem, XsdAbstractSystemExtension systemExtension, OperationResult result) {
        super.getSystemDetailsFromXml(softwareSystem, systemExtension, result);
        assert (systemExtension.getLanguage().equals(TypescriptLanguage.INSTANCE.getStandardName())) : "Language '" + systemExtension.getLanguage() + "' of systemExtension does not match '" + TypescriptLanguage.INSTANCE.getStandardName();
        if (systemExtension instanceof XsdTypescriptSystemConfiguration) {
            XsdTypescriptSystemConfiguration config = (XsdTypescriptSystemConfiguration)systemExtension;
            String solutionPath = config.getTypescriptConfigFilePath();
            this.addConfigFileToSystem(softwareSystem, new TFile((File)softwareSystem.getDirectoryFile(), solutionPath));
        }
    }

    public void addSystemDetailsToXml(SoftwareSystem softwareSystem, com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem systemXml) {
        super.addSystemDetailsToXml(softwareSystem, systemXml);
        if (!softwareSystem.getUsedLanguages().contains(this.getLanguage())) {
            return;
        }
        XsdTypescriptSystemConfiguration xmlSystemConfig = new ObjectFactory().createXsdTypescriptSystemConfiguration();
        systemXml.getSystemExtension().add(xmlSystemConfig);
        xmlSystemConfig.setLanguage(TypescriptLanguage.INSTANCE.getStandardName());
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        TypescriptSystemSettings settings = (TypescriptSystemSettings)((Object)ws.getUniqueExistingChild(TypescriptSystemSettings.class));
        TypescriptConfigFile configFile = (TypescriptConfigFile)((Object)settings.getUniqueExistingChild(TypescriptConfigFile.class));
        xmlSystemConfig.setTypescriptConfigFilePath(configFile.getPath());
    }
}

