/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;

final class TypescriptInterpreterValidator
implements IPathValidator {
    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.FILE;
    }

    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (newInput == null || newInput.getPath().isEmpty()) {
            result.addError("Must not be empty");
            return result;
        }
        if (!newInput.isFile()) {
            result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not a file.");
            return result;
        }
        if (!newInput.canExecute()) {
            result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not executable.");
            return result;
        }
        if (Platform.isWindows()) {
            if (!newInput.getName().equalsIgnoreCase("node.exe")) {
                result.addError("File name should be node.exe");
            }
        } else if (!newInput.getName().equalsIgnoreCase("node")) {
            result.addError("File name should be node");
        }
        return result;
    }
}

