/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CycleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.element.TypescriptProviderId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptMetricId;
import java.util.Arrays;

public final class TypeScriptDirectoryCyclesInSystemMetricsAnalyzerAdapter
extends CycleMetricsAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = TypescriptAnalyzerId.TYPESCRIPT_DIRECTORY_CYCLES_SYSTEM_METRICS;
    private final IMetricDescriptor m_numberOfDirectoryCycleGroups;
    private final IMetricDescriptor m_numberOfCriticalDirectoryCycleGroups;
    private final IMetricDescriptor m_numberOfCyclicDirectories;
    private final IMetricDescriptor m_ignoredCyclicDirectories;
    private final IMetricDescriptor m_biggestDirectoryCycleGroup;
    private final IMetricDescriptor m_referencesToCut;
    private final IMetricDescriptor m_dependenciesToCut;
    private final IMetricDescriptor m_sdi;
    private final IMetricDescriptor m_cyclicity;
    private final IMetricDescriptor m_relativeCyclicity;

    public TypeScriptDirectoryCyclesInSystemMetricsAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID, Arrays.asList(new IAnalyzerId[]{TypescriptAnalyzerId.TYPESCRIPT_DIRECTORY_CYCLES_SYSTEM, TypescriptAnalyzerId.TYPESCRIPT_DIRECTORY_CYCLES_MODULE}));
        MetricProvider mp = ((IMetricsProvider)this.getInstallation().getExtension(IMetricsProvider.class)).getMetricProvider((IProviderId)TypescriptProviderId.INSTANCE);
        this.m_numberOfDirectoryCycleGroups = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_DIRECTORY_CYCLE_GROUPS, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_numberOfCriticalDirectoryCycleGroups = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_CRITICAL_DIRECTORY_CYCLE_GROUPS, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_numberOfCyclicDirectories = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_CYCLIC_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_ignoredCyclicDirectories = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_IGNORED_CYCLIC_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_biggestDirectoryCycleGroup = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_BIGGEST_DIRECTORY_CYCLE_GROUP, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_referencesToCut = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_PARSER_DEPENDENCIES_TO_REMOVE_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_dependenciesToCut = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_COMPONENT_DEPENDENCIES_TO_REMOVE_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_sdi = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_STRUCTURAL_DEBT_INDEX_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_cyclicity = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_CYCLICITY_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
        this.m_relativeCyclicity = this.addMetricDescriptorIfNotExistent(mp, TypescriptMetricId.TYPESCRIPT_RELATIVE_CYCLICITY_DIRECTORIES, (IMetricLevel)CoreMetricLevel.SYSTEM, null);
    }

    protected IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric() {
        return this.m_ignoredCyclicDirectories;
    }

    protected IMetricDescriptor getNumberOfCycleGroupsMetric() {
        return this.m_numberOfDirectoryCycleGroups;
    }

    protected IMetricDescriptor getNumberOfCriticalCycleGroupsMetric() {
        return this.m_numberOfCriticalDirectoryCycleGroups;
    }

    protected IMetricDescriptor getNumberOfCyclicElementsMetric() {
        return this.m_numberOfCyclicDirectories;
    }

    protected IMetricDescriptor getBiggestCycleGroupMetric() {
        return this.m_biggestDirectoryCycleGroup;
    }

    protected IMetricDescriptor getReferencesToCutMetric() {
        return this.m_referencesToCut;
    }

    protected IMetricDescriptor getComponentDependenciesToCutMetric() {
        return this.m_dependenciesToCut;
    }

    protected IMetricDescriptor getStructuralDebtIndexMetric() {
        return this.m_sdi;
    }

    protected IMetricDescriptor getCyclicityMetric() {
        return this.m_cyclicity;
    }

    protected IMetricDescriptor getRelativeCyclicityMetric() {
        return this.m_relativeCyclicity;
    }

    protected IMetricId getNumberOfElementsMetricId() {
        return TypescriptMetricId.TYPESCRIPT_DIRECTORIES_FULLY_ANALYZED;
    }

    protected Language getLanguage() {
        return TypescriptLanguage.INSTANCE;
    }

    protected boolean runOnSystemLevel() {
        return true;
    }
}

