/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.AbstractPythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ClassScope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import org.antlr.v4.runtime.tree.TerminalNode;

final class TypeVisitor
extends AbstractPythonVisitor<Void> {
    private final boolean m_createUsesDependency;
    private ClassScope m_result;
    private Scope m_scope;
    private int m_line = -1;

    TypeVisitor(Scope currentScope, PythonSourceFile source, boolean createIssues, boolean createUsesDependency) {
        super(currentScope, source, createIssues);
        this.m_createUsesDependency = createUsesDependency;
    }

    private void processResolvedMember(ScopeItem resolved, int line) {
        assert (resolved != null) : "Parameter 'resolved' of method 'processResolvedMember' must not be null";
        if (resolved instanceof ClassScope) {
            this.m_result = (ClassScope)resolved;
            this.m_line = line;
            this.m_scope = this.m_result;
        } else if (resolved instanceof Scope) {
            this.m_scope = (Scope)resolved;
        } else {
            ScopeItem.ITypeHint hint = resolved.getTypeHint();
            if (hint != null && hint.getScope() instanceof Scope) {
                this.m_scope = (Scope)hint.getScope();
            }
        }
    }

    @Override
    public Void visitPrimary(PythonParser.PrimaryContext ctx) {
        if (ctx.primary() != null) {
            int line;
            if (ctx.NAME() == null) {
                this.m_result = null;
                return null;
            }
            ctx.primary().accept(this);
            if (this.m_scope == null) {
                this.m_result = null;
                return null;
            }
            String name = ctx.NAME().getText();
            ScopeItem member = this.m_scope.lookupMember(name, this.m_source, line = ctx.NAME().getSymbol().getLine(), this.m_currentScope.isFunctionScope());
            if (member != null) {
                this.processResolvedMember(member, line);
            } else {
                this.unresolvedName(name, line);
            }
        } else {
            ctx.atom().accept(this);
        }
        return null;
    }

    @Override
    public Void visitAtom(PythonParser.AtomContext ctx) {
        TerminalNode nameNode = ctx.NAME();
        if (nameNode != null) {
            int line;
            String name = nameNode.getText();
            ScopeItem resolved = this.m_currentScope.lookup(name, this.m_source, line = nameNode.getSymbol().getLine(), this.m_currentScope.isFunctionScope());
            if (resolved != null) {
                this.processResolvedMember(resolved, line);
            } else {
                this.unresolvedName(name, line);
            }
        }
        return null;
    }

    ClassScope getResult() {
        if (this.m_createUsesDependency && this.m_result != null) {
            DependencyCreator.createDependency(this.m_currentScope.getModelObject(), this.m_result.getModelObject(), PythonDependencyType.USES, this.m_line);
        }
        return this.m_result;
    }
}

