/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.ExternalGenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.SmartReader;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.CleanupVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.IPythonImporter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.InitializationVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonLexer;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonSearchPath;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonVisitor2;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonIssueId;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonParserError;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonParserWarning;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonExternal;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PythonRefreshJob
implements IPythonImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonRefreshJob.class);
    private final MultipleValueMap<String, Scope> m_moduleDirectory = new MultipleValueMap();
    private final List<SourceFile> m_filesToParse = new ArrayList<SourceFile>();
    private final Map<Scope, ParseTree> m_parseTreeMap = new THashMap();
    private final Map<NamedElement, Scope> m_scopeMap = new THashMap();
    private final Set<Scope> m_parsedScopes = new THashSet();
    private final List<IPythonImporter.IProcessor> m_processors = new ArrayList<IPythonImporter.IProcessor>();
    private final IAddedOrChangedSourceFileProcessor m_sourceProcessor;
    private final PythonInterpreter m_interpreter;
    private final IFilePathListener m_listener;
    private final SoftwareSystem m_softwareSystem;
    private final PythonSearchPath m_searchPath;
    private final PythonExternal m_pythonExternal;
    private Scope m_builtins;

    public PythonRefreshJob(SoftwareSystem system, IAddedOrChangedSourceFileProcessor sourceFileProcessor, PythonInterpreter interpreter, IFilePathListener listener) {
        assert (system != null) : "Parameter 'system' of method 'PythonRefreshJob' must not be null";
        assert (sourceFileProcessor != null) : "Parameter 'sourceFileProcessor' of method 'PythonRefreshJob' must not be null";
        assert (interpreter != null) : "Parameter 'interpreter' of method 'PythonRefreshJob' must not be null";
        this.m_softwareSystem = system;
        this.m_listener = listener;
        this.m_sourceProcessor = sourceFileProcessor;
        this.m_interpreter = interpreter;
        this.m_searchPath = new PythonSearchPath(this.m_interpreter);
        this.m_interpreter.getPythonPaths().stream().filter(dir -> dir.length() > 0).forEach(dir -> this.m_searchPath.add((String)dir));
        Workspace workspace = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        this.m_pythonExternal = (PythonExternal)((Object)workspace.getUniqueExistingChild(PythonExternal.class));
        this.m_searchPath.add(this.m_interpreter.getSkeletonDir().getNormalizedAbsolutePath());
        assert (this.m_pythonExternal != null) : "Missing PythonExternal!";
    }

    public void init(IWorkerContext workerContext, List<ModuleDelta> moduleDeltas) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initBuiltIns' must not be null";
        assert (moduleDeltas != null) : "Parameter 'moduleDeltas' of method 'initBuiltIns' must not be null";
        workerContext.working("Initializing Python refresh", true);
        moduleDeltas.forEach(delta -> this.cleanup((ModuleDelta)delta));
        Workspace workspace = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        workspace.accept((NamedElement.INamedElementVisitor)new InitializationVisitor(workerContext, this.m_moduleDirectory, this.m_scopeMap, this.m_searchPath));
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.working("Loading builtin modules", true);
        this.m_builtins = this.m_moduleDirectory.get((Object)"builtins").stream().filter(scope -> scope.isPythonModule()).findFirst().orElse(null);
        if (this.m_builtins == null) {
            this.m_builtins = this.locateAndReadModule(workerContext, null, "builtins", null);
        }
        if (this.m_builtins != null) {
            this.m_moduleDirectory.values().stream().filter(s -> s != this.m_builtins).forEach(scope -> scope.setParent(this.m_builtins));
        }
    }

    public PythonInterpreter getInterpreter() {
        return this.m_interpreter;
    }

    private void cleanup(ModuleDelta delta) {
        CleanupVisitor cleanup = new CleanupVisitor((IModelServiceProvider)this.m_softwareSystem, this.m_listener);
        delta.visitDeleted((ModuleDelta.IVisitor)cleanup);
        delta.visitModified((ModuleDelta.IVisitor)cleanup);
    }

    private RootDirectoryPath getOrCreateRootDirectoryPath(IModelServiceProvider msp, TFile file) {
        assert (msp != null) : "Parameter 'msp' of method 'getOrcreateRootDirectoryPath' must not be null";
        assert (file != null) : "Parameter 'file' of method 'getOrcreateRootDirectoryPath' must not be null";
        for (RootDirectoryPath root : this.m_pythonExternal.getChildren(RootDirectoryPath.class)) {
            if (!FileUtility.areEqual((TFile)root.getFile(), (TFile)file)) continue;
            return root;
        }
        ExternalGenericRootDirectory result = new ExternalGenericRootDirectory(msp, (NamedElement)this.m_pythonExternal, file);
        this.m_pythonExternal.addChild((NamedElement)result);
        return result;
    }

    private Scope locateAndReadModule(IWorkerContext workerContext, RootDirectoryPath root, String name, Scope parentScope) {
        RootDirectoryPath parent;
        TFile module;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'locateAndReadModule' must not be null";
        assert (name != null) : "Parameter 'name' of method 'locateAndReadModule' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        if (root == null) {
            module = this.m_searchPath.locateModule(name);
        } else if (name.endsWith(".__init__")) {
            module = new TFile((File)root.getDirectoryFile(), name.replace('.', '/') + ".py");
            if (!module.isFile() || !module.canRead()) {
                module = this.m_searchPath.locateModule(name);
            }
        } else {
            module = new TFile((File)root.getDirectoryFile(), name);
            if (!(module.isDirectory() || (module = new TFile((File)root.getDirectoryFile(), name + ".py")).isFile() && module.canRead())) {
                module = this.m_searchPath.locateModule(name);
            }
        }
        if (module == null) {
            return null;
        }
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        if (module.isDirectory()) {
            String pkgInitializerModuleName = name + ".__init__";
            Scope scope = (Scope)this.m_moduleDirectory.getFirstValue((Object)pkgInitializerModuleName);
            if (scope == null) {
                scope = this.locateAndReadModule(workerContext, root, pkgInitializerModuleName, parentScope);
            }
            return scope;
        }
        TFile dir = module.getParentFile();
        int dots = StringUtility.countChar((char)'.', (String)name);
        String pkgName = null;
        String moduleName = name;
        if (dots > 0) {
            do {
                dir = dir.getParentFile();
            } while (--dots > 0);
            int lastDot = name.lastIndexOf(46);
            pkgName = name.substring(0, lastDot);
            moduleName = name.substring(lastDot + 1);
        }
        if (root == null || !FileUtility.areEqual((TFile)root.getDirectoryFile(), (TFile)dir)) {
            root = this.getOrCreateRootDirectoryPath((IModelServiceProvider)this.m_softwareSystem, dir);
        }
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        if (pkgName != null) {
            parent = this.getParentPackage((NamedElement)root, pkgName, module);
            parentScope = this.m_scopeMap.get(parent);
            assert (parentScope != null);
        } else {
            parent = root;
        }
        PythonSourceFile source = new PythonSourceFile((IModelServiceProvider)this.m_softwareSystem, (NamedElement)parent, module);
        parent.addChild((NamedElement)source);
        Scope scope = parentScope == null || parentScope == this.m_builtins ? new Scope(moduleName, parentScope, (NamedElement)source) : parentScope.addScope(moduleName, (NamedElement)source);
        this.m_scopeMap.put((NamedElement)source, scope);
        this.m_moduleDirectory.put((Object)name, (Object)scope);
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.working(String.format("Parsing file '%s'", source.getName()), true);
        ParseTree ast = this.parseFile(workerContext, (SourceFile)source);
        if (ast != null) {
            ast.accept((ParseTreeVisitor)new PythonVisitor(workerContext, (IModelServiceProvider)this.m_softwareSystem, this, scope));
        }
        return scope;
    }

    private List<String> enumerateModules(String dottedName) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder partialName = new StringBuilder();
        String[] stringArray = dottedName.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String namePart = stringArray[n2];
            if (partialName.length() > 0) {
                partialName.append('.');
            }
            partialName.append(namePart);
            result.add(partialName.toString());
            ++n2;
        }
        return result;
    }

    private List<Scope> importModules(IWorkerContext workerContext, Scope fromScope, RootDirectoryPath parent, List<String> moduleNames, int lineNumber) {
        NamedElement element;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importModules' must not be null";
        assert (fromScope != null) : "Parameter 'fromScope' of method 'importModule' must not be null";
        assert (moduleNames != null) : "Parameter 'moduleNames' of method 'importModule' must not be null";
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (String name : moduleNames) {
            Scope module;
            if (!Platform.isOperatingSystemCaseSensitive()) {
                name = name.toLowerCase();
            }
            if ((module = (Scope)this.m_moduleDirectory.getFirstValue((Object)name)) == null) {
                module = this.locateAndReadModule(workerContext, parent, name, this.m_builtins);
                if (module == null) {
                    break;
                }
            } else {
                ParseTree ast = this.m_parseTreeMap.get(module);
                if (ast != null && this.m_parsedScopes.add(module)) {
                    ast.accept((ParseTreeVisitor)new PythonVisitor(workerContext, (IModelServiceProvider)this.m_softwareSystem, this, module));
                }
            }
            if (module.isPackage()) {
                module = (Scope)module.lookupLocal("__init__");
            }
            if (module != null) {
                DependencyCreator.createDependency(fromScope.getModelObject(), module.getModelObject(), PythonDependencyType.IMPORT, lineNumber);
            }
            result.add(module);
        }
        while (result.size() < moduleNames.size()) {
            result.add(null);
        }
        int lastIndex = moduleNames.size() - 1;
        if (result.get(lastIndex) == null && !(element = fromScope.getModelObject()).isExternal()) {
            element.addIssue((Issue)new PythonParserWarning(element, "Cannot resolve import of '" + moduleNames.get(lastIndex) + "'", lineNumber));
        }
        return result;
    }

    @Override
    public void importModule(IWorkerContext workerContext, Scope scope, RootDirectoryPath parent, String name, String asName, int line) {
        Scope importedScope = null;
        for (Scope moduleScope : this.m_moduleDirectory.get((Object)name)) {
            NamedElement modelObject = moduleScope.getModelObject();
            if (modelObject.getParent() != parent) continue;
            importedScope = moduleScope;
            DependencyCreator.createDependency(scope.getModelObject(), importedScope.getModelObject(), PythonDependencyType.IMPORT, line);
            break;
        }
        if (importedScope == null) {
            List<String> moduleNames = Arrays.asList(name);
            List<Scope> modules = this.importModules(workerContext, scope, parent, moduleNames, line);
            importedScope = modules.get(0);
        }
        if (importedScope != null) {
            scope.importScopeItem(asName, importedScope);
        }
    }

    @Override
    public void importModule(IWorkerContext workerContext, Scope scope, String dottedName, String asName, int lineNumber) {
        assert (scope != null) : "Parameter 'scope' of method 'importModule' must not be null";
        assert (dottedName != null && dottedName.length() > 0) : "Parameter 'dottedName' of method 'importModule' must not be empty";
        List<String> moduleNames = this.enumerateModules(dottedName);
        List<Scope> modules = this.importModules(workerContext, scope, null, moduleNames, lineNumber);
        Scope lastModule = modules.get(modules.size() - 1);
        if (asName == null) {
            if (modules.get(0) != null) {
                scope.importScopeItem(moduleNames.get(0), modules.get(0));
            }
        } else if (lastModule != null) {
            scope.importScopeItem(asName, lastModule);
        }
    }

    @Override
    public Scope importModule(IWorkerContext workerContext, Scope scope, RootDirectoryPath parent, String dottedName, int line) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importModule' must not be null";
        assert (scope != null) : "Parameter 'scope' of method 'importModule' must not be null";
        assert (dottedName != null && dottedName.length() > 0) : "Parameter 'dottedName' of method 'importModule' must not be empty";
        List<String> moduleNames = this.enumerateModules(dottedName);
        List<Scope> modules = this.importModules(workerContext, scope, parent, moduleNames, line);
        Scope lastModule = modules.get(modules.size() - 1);
        return lastModule;
    }

    @Override
    public void addProcessor(IPythonImporter.IProcessor processor) {
        assert (processor != null) : "Parameter 'processor' of method 'addProcessor' must not be null";
        this.m_processors.add(processor);
    }

    private NamedElement getParentPackage(NamedElement root, String name, TFile sourceForPackage) {
        Scope currentScope = null;
        NamedElement parent = root;
        StringBuilder packageName = new StringBuilder();
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericPackage pkg;
            String fragment = stringArray[n2];
            assert (fragment.length() > 0) : "Unexpected empty fragment in name " + name;
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(fragment);
            PythonSourceFile src = (PythonSourceFile)((Object)parent.getFirstChild(c -> c.getShortName().equals(fragment + ".py"), PythonSourceFile.class));
            if (src != null) {
                Scope srcScope = this.m_scopeMap.get((Object)src);
                this.m_moduleDirectory.remove((Object)src.getPythonModuleName(), (Object)srcScope);
                this.m_scopeMap.remove((Object)src);
                this.m_filesToParse.remove((Object)src);
                src.remove();
                Scope parentScope = srcScope.getParent();
                if (parentScope != null && parentScope != this.m_builtins) {
                    parentScope.removeEntry(srcScope.getName());
                }
            }
            if ((pkg = (GenericPackage)parent.getFirstChild(c -> c.getShortName().equals(fragment), GenericPackage.class)) == null) {
                pkg = new GenericPackage((IModelServiceProvider)this.m_softwareSystem, parent, fragment);
                parent.addChild((NamedElement)pkg);
                currentScope = currentScope == null ? new Scope(this.m_builtins, (NamedElement)pkg, this.getPackageScope(packageName.toString(), sourceForPackage), false) : new Scope(currentScope, (NamedElement)pkg, this.getPackageScope(packageName.toString(), sourceForPackage), true);
                this.m_moduleDirectory.put((Object)packageName.toString(), (Object)currentScope);
                this.m_scopeMap.put((NamedElement)pkg, currentScope);
            } else {
                currentScope = this.m_scopeMap.get(pkg);
                assert (currentScope != null);
            }
            parent = pkg;
            ++n2;
        }
        return parent;
    }

    private Scope getPackageScope(String name, TFile source) {
        Scope scope = (Scope)this.m_moduleDirectory.getFirstValue((Object)name);
        assert (scope == null || scope.isPackage()) : "Invalid scope for: " + name + ". Source = " + source.getPath() + ". Scope: " + scope.toString();
        return scope;
    }

    private void runProcessors(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'runProcessors' must not be null";
        this.m_processors.forEach(p -> p.process(workerContext));
        this.m_processors.clear();
    }

    public void refreshModule(IWorkerContext workerContext, ModuleDelta delta, IFilePathListener listener) {
        ParseTree ast;
        Scope scope;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshModule' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshModule' must not be null";
        DeltaVisitor visitor = new DeltaVisitor(workerContext, listener);
        workerContext.setNumberOfSteps(4, new int[]{5, 30, 60, 20});
        workerContext.working(String.format("Collecting delta for module '%s'", delta.getModule().getShortName()), true);
        delta.visitAdded((ModuleDelta.IVisitor)visitor);
        delta.visitModified((ModuleDelta.IVisitor)visitor);
        delta.visitDeleted((ModuleDelta.IVisitor)visitor);
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.working("Parsing Python sources of module " + delta.getModule().getShortName() + ".", true);
        workerContext.beginBlockOfWork(this.m_filesToParse.size());
        for (SourceFile source : this.m_filesToParse) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.working(String.format("Parsing module '%s', file '%s'", delta.getModule().getShortName(), source.getName()), true);
            ParseTree ast2 = this.parseFile(workerContext, source);
            PythonParser.finishParsing();
            PythonLexer.finishParsing();
            if (ast2 != null) {
                Scope scope2 = this.m_scopeMap.get(source);
                assert (scope2 != null);
                this.m_parseTreeMap.put(scope2, ast2);
                source.setTimestamp(source.getFile().lastModified());
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        workerContext.working("Processing Python sources of module " + delta.getModule().getShortName() + ".", true);
        workerContext.beginBlockOfWork(this.m_filesToParse.size());
        for (SourceFile source : this.m_filesToParse) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            scope = this.m_scopeMap.get(source);
            assert (scope != null);
            if (this.m_parsedScopes.add(scope) && (ast = this.m_parseTreeMap.get(scope)) != null) {
                ast.accept((ParseTreeVisitor)new PythonVisitor(workerContext, (IModelServiceProvider)this.m_softwareSystem, this, scope));
            }
            workerContext.workItemCompleted();
        }
        this.runProcessors(workerContext);
        workerContext.endStep();
        workerContext.working("Resolving dependencies of module " + delta.getModule().getShortName() + ".", true);
        workerContext.beginBlockOfWork(this.m_filesToParse.size());
        for (SourceFile source : this.m_filesToParse) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            if (!source.isExternal()) {
                scope = this.m_scopeMap.get(source);
                assert (scope != null);
                ast = this.m_parseTreeMap.get(scope);
                if (ast != null) {
                    ast.accept((ParseTreeVisitor)new PythonVisitor2(scope));
                    this.m_parseTreeMap.remove(scope);
                }
            }
            workerContext.workItemCompleted();
        }
        this.runProcessors(workerContext);
        workerContext.endStep();
        this.m_filesToParse.clear();
        this.m_parseTreeMap.clear();
    }

    private ParseTree parseFile(final IWorkerContext workerContext, SourceFile source) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'parseFile' must not be null";
        assert (source != null) : "Parameter 'source' of method 'parseFile' must not be null";
        PythonParser.File_inputContext result = null;
        try {
            CodePointCharStream inputStream = CharStreams.fromReader((Reader)new SmartReader((InputStream)new FileInputStream((File)source.getFile())), (String)source.getName());
            PythonLexer lexer = new PythonLexer((CharStream)inputStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PythonParser parser = new PythonParser((TokenStream)tokens);
            source.removeIssues(new IIssueId[]{PythonIssueId.PYTHON_PARSER_ERROR, PythonIssueId.PYTHON_PARSER_WARNING});
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ErrorListener(source));
            parser.addParseListener(new ParseTreeListener(){

                public void enterEveryRule(ParserRuleContext arg0) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new PythonParserInterruptedException();
                    }
                }

                public void exitEveryRule(ParserRuleContext arg0) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new PythonParserInterruptedException();
                    }
                }

                public void visitErrorNode(ErrorNode arg0) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new PythonParserInterruptedException();
                    }
                }

                public void visitTerminal(TerminalNode arg0) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new PythonParserInterruptedException();
                    }
                }
            });
            result = parser.file_input();
        }
        catch (PythonParserInterruptedException ex) {
            LOGGER.debug("Python refresh cancelled");
        }
        catch (IOException e) {
            LOGGER.error("IO Error while parsing " + source.getAbsolutePath(), (Throwable)e);
            source.addIssue((Issue)new PythonParserError((NamedElement)source, "IO Error: " + e.getMessage(), -1));
        }
        return result;
    }

    private class DeltaVisitor
    implements ModuleDelta.IVisitor {
        private final IFilePathListener m_listener;
        private final IWorkerContext m_workerContext;

        private DeltaVisitor(IWorkerContext workerContext, IFilePathListener listener) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'DeltaVisitor' must not be null";
            this.m_workerContext = workerContext;
            this.m_listener = listener;
        }

        public void deleted(ModuleDelta delta, FilePath filePath) {
        }

        public void modified(ModuleDelta delta, FilePath filePath) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            PythonRefreshJob.this.m_filesToParse.add((SourceFile)filePath);
            PythonRefreshJob.this.m_sourceProcessor.processAddedOrChangedSourceFile((SourceFile)filePath);
        }

        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
            Scope scope;
            PythonSourceFile source;
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            String pathWithoutExtension = FileUtility.removeExtension((String)file.getPath());
            if (new TFile(pathWithoutExtension).isDirectory()) {
                return;
            }
            String relPath = FileUtility.calculateRelativePath((TFile)file.getParentFile(), (TFile)root.getFile());
            if (relPath.startsWith("./")) {
                relPath = relPath.substring("./".length());
            }
            String name = FileUtility.removeExtension((String)file.getName());
            if (!Platform.isOperatingSystemCaseSensitive()) {
                name = name.toLowerCase();
            }
            if (relPath.equals(".")) {
                source = new PythonSourceFile((IModelServiceProvider)PythonRefreshJob.this.m_softwareSystem, (NamedElement)root, file);
                root.addChild((NamedElement)source);
                scope = new Scope(name, PythonRefreshJob.this.m_builtins, (NamedElement)source);
                PythonRefreshJob.this.m_moduleDirectory.put((Object)name, (Object)scope);
            } else {
                relPath = relPath.replace('/', '.');
                NamedElement parent = PythonRefreshJob.this.getParentPackage((NamedElement)root, relPath, file);
                source = new PythonSourceFile((IModelServiceProvider)PythonRefreshJob.this.m_softwareSystem, parent, file);
                parent.addChild((NamedElement)source);
                Scope currentScope = PythonRefreshJob.this.m_scopeMap.get(parent);
                assert (currentScope != null);
                scope = currentScope.addScope(name, (NamedElement)source);
                PythonRefreshJob.this.m_moduleDirectory.put((Object)source.getPythonModuleName(), (Object)scope);
            }
            PythonRefreshJob.this.m_scopeMap.put((NamedElement)source, scope);
            PythonRefreshJob.this.m_sourceProcessor.processAddedOrChangedSourceFile((SourceFile)source);
            PythonRefreshJob.this.m_filesToParse.add((SourceFile)source);
            if (this.m_listener != null) {
                this.m_listener.filePathCreated((IModule)root.getParent(Module.class, new Class[0]), (FilePath)source);
            }
        }
    }

    private static class ErrorListener
    extends BaseErrorListener {
        private final SourceFile m_source;

        private ErrorListener(SourceFile source) {
            this.m_source = source;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.m_source.addIssue((Issue)new PythonParserWarning((NamedElement)this.m_source, msg, line));
        }
    }

    private static class PythonParserInterruptedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

