/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunctionWithBody;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.IPythonRoutine;
import java.io.IOException;

public class PythonFunction
extends GenericFunctionWithBody
implements IPythonRoutine {
    private int m_serialNumber = 0;
    private boolean m_isAsync;

    public PythonFunction(NamedElement parent) {
        super(parent);
    }

    public PythonFunction(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int serialNumber) {
        super(msp, parent, name, lineNumber);
        assert (serialNumber >= 0);
        this.m_serialNumber = serialNumber;
    }

    public String getFullyQualifiedNamePart() {
        if (this.m_serialNumber == 0) {
            return super.getFullyQualifiedNamePart();
        }
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.m_serialNumber);
    }

    @Override
    public boolean isAsync() {
        return this.m_isAsync;
    }

    @Override
    public void markAsAsync() {
        this.m_isAsync = true;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_serialNumber = reader.readInt();
        this.m_isAsync = reader.readBoolean();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_serialNumber);
        writer.writeBoolean(this.m_isAsync);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPythonFunction(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitPythonFunction(PythonFunction var1);
    }
}

