/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericClass;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import java.io.IOException;

public final class PythonClass
extends GenericClass {
    private int m_serialNumber;
    private int m_numberOfStatements;

    public PythonClass(NamedElement parent) {
        super(parent);
    }

    public PythonClass(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int serialNumber) {
        super(msp, parent, name, lineNumber, false);
        this.m_serialNumber = serialNumber;
    }

    public String getFullyQualifiedNamePart() {
        if (this.m_serialNumber == 0) {
            return super.getFullyQualifiedNamePart();
        }
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.m_serialNumber);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_serialNumber = reader.readInt();
        this.m_numberOfStatements = reader.readInt();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_serialNumber);
        writer.writeInt(this.m_numberOfStatements);
    }

    @IntProperty
    public int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1 + this.m_numberOfStatements;
    }

    @IntProperty
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPythonClass(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitPythonClass(PythonClass var1);
    }
}

