/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunctionWithBody;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericScript;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.AbstractPythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ClassScope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.NameCollectionVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.NameResolver;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.TypeClass;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.TypeVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.IPythonRoutine;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonClass;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonMethod;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

final class PythonVisitor2
extends AbstractPythonVisitor<Void> {
    private NestingInfo m_currentNesting;
    private int m_parameterCount;

    PythonVisitor2(Scope currentScope) {
        super(currentScope, (PythonSourceFile)currentScope.getModelObject());
    }

    @Override
    public Void visitFile_input(PythonParser.File_inputContext ctx) {
        NestingInfo oldNestingInfo = this.m_currentNesting;
        this.m_currentNesting = new NestingInfo();
        super.visitFile_input(ctx);
        GenericScript script = this.m_source.getScript();
        if (!script.isExternal()) {
            script.setCyclomaticComplexity(this.m_currentScope.getCcn());
            script.setModifiedCyclomaticComplexity(this.m_currentScope.getCcn());
            script.setNumberOfLogicalOperations(this.m_currentScope.getAndOrCount());
            script.setNumberOfStatements(this.m_currentScope.getNumberOfStatements());
            script.setMaxNesting(this.m_currentNesting.m_maxNesting);
        }
        this.m_currentNesting = oldNestingInfo;
        return null;
    }

    @Override
    public Void visitFunction_def_raw(PythonParser.Function_def_rawContext ctx) {
        assert (ctx.m_scope != null);
        Scope parentScope = this.m_currentScope;
        NestingInfo oldNestingInfo = this.m_currentNesting;
        this.m_currentScope = ctx.m_scope;
        this.m_currentNesting = new NestingInfo();
        this.visitChildren((RuleNode)ctx);
        GenericFunctionWithBody funct = (GenericFunctionWithBody)this.m_currentScope.getModelObject();
        if (!funct.isExternal()) {
            funct.setCyclomaticComplexity(this.m_currentScope.getCcn());
            funct.setModifiedCyclomaticComplexity(this.m_currentScope.getCcn());
            funct.setNumberOfLogicalOperations(this.m_currentScope.getAndOrCount());
            funct.setNumberOfStatements(this.m_currentScope.getNumberOfStatements());
            funct.setMaxNesting(this.m_currentNesting.m_maxNesting);
        }
        if (ctx.ASYNC() != null) {
            ((IPythonRoutine)funct).markAsAsync();
        }
        this.m_currentScope = parentScope;
        this.m_currentNesting = oldNestingInfo;
        return null;
    }

    @Override
    public Void visitClass_def_raw(PythonParser.Class_def_rawContext ctx) {
        assert (ctx.m_scope != null);
        assert (this.m_currentScope == ctx.m_scope.getParent());
        Scope parentScope = this.m_currentScope;
        this.m_currentScope = ctx.m_scope;
        this.visitChildren((RuleNode)ctx);
        PythonClass cls = (PythonClass)this.m_currentScope.getModelObject();
        cls.setNumberOfStatements(this.m_currentScope.getNumberOfStatements());
        this.m_currentScope = parentScope;
        return null;
    }

    @Override
    public Void visitParameters(PythonParser.ParametersContext ctx) {
        this.m_parameterCount = 0;
        this.visitChildren((RuleNode)ctx);
        GenericFunctionWithBody function = (GenericFunctionWithBody)this.m_currentScope.getModelObject();
        function.setNumberOfParameters(this.m_parameterCount);
        return null;
    }

    @Override
    public Void visitStar_etc(PythonParser.Star_etcContext ctx) {
        this.visitChildren((RuleNode)ctx);
        --this.m_parameterCount;
        return null;
    }

    @Override
    public Void visitParam(PythonParser.ParamContext ctx) {
        NamedElement modelObject;
        String name = ctx.NAME().getText();
        ScopeItem param = this.m_currentScope.lookupLocal(name);
        if (param == null) {
            param = this.m_currentScope.addLocalName(name, ctx.NAME().getSymbol().getLine());
        }
        boolean typeHintGiven = false;
        if (this.m_parameterCount == 0 && (modelObject = this.m_currentScope.getModelObject()) instanceof PythonMethod) {
            PythonMethod method = (PythonMethod)modelObject;
            switch (method.getKind()) {
                case METHOD: {
                    typeHintGiven = true;
                    param.setTypeHint(new TypeClass(this.m_currentScope.getParent()));
                    break;
                }
                case CLASS_METHOD: {
                    typeHintGiven = true;
                    param.setTypeHint(new TypeClass(this.m_currentScope.getParent().getParent()));
                    break;
                }
            }
        }
        if (!typeHintGiven && ctx.annotation() != null) {
            TypeVisitor tv = new TypeVisitor(this.m_currentScope, this.m_source, false, true);
            ctx.annotation().accept(tv);
            if (tv.getResult() != null) {
                param.setTypeHint(new TypeClass(tv.getResult()));
            }
        }
        ++this.m_parameterCount;
        return null;
    }

    @Override
    public Void visitParam_star_annotation(PythonParser.Param_star_annotationContext ctx) {
        this.m_currentScope.addLocalName(ctx.NAME().getText(), ctx.NAME().getSymbol().getLine());
        ++this.m_parameterCount;
        return (Void)super.visitParam_star_annotation(ctx);
    }

    @Override
    public Void visitLambda_param(PythonParser.Lambda_paramContext ctx) {
        this.m_currentScope.addLocalName(ctx.NAME().getText(), ctx.NAME().getSymbol().getLine());
        return null;
    }

    @Override
    public Void visitAssignment(PythonParser.AssignmentContext ctx) {
        NamedElement fromObject;
        if (ctx.annotated_rhs() != null) {
            ctx.annotated_rhs().accept(this);
        }
        if (ctx.yield_expr() != null) {
            ctx.yield_expr().accept(this);
        }
        if (ctx.star_expressions() != null) {
            ctx.star_expressions().accept(this);
        }
        if ((fromObject = this.getFromObject()) == null) {
            return null;
        }
        int line = ctx.start.getLine();
        if (ctx.star_targets() != null) {
            for (PythonParser.Star_targetsContext stsc : ctx.star_targets()) {
                for (PythonParser.Star_targetContext stc : stsc.star_target()) {
                    NameResolver resolver = new NameResolver(this.m_currentScope, this.m_source, true);
                    stc.accept(resolver);
                    this.processResolverResult(fromObject, resolver, true, line);
                }
            }
        } else if (ctx.single_target() != null) {
            NameResolver resolver = new NameResolver(this.m_currentScope, this.m_source, true);
            ctx.single_target().accept(resolver);
            this.processResolverResult(fromObject, resolver, true, line);
        } else if (ctx.single_subscript_attribute_target() != null) {
            NameResolver resolver = new NameResolver(this.m_currentScope, this.m_source, true);
            ctx.single_subscript_attribute_target().accept(resolver);
            this.processResolverResult(fromObject, resolver, true, line);
        }
        return null;
    }

    @Override
    public Void visitAssignment_expression(PythonParser.Assignment_expressionContext ctx) {
        this.visitChildren((RuleNode)ctx);
        this.m_currentScope.addLocalName(ctx.NAME().getText(), ctx.NAME().getSymbol().getLine());
        return null;
    }

    @Override
    public Void visitFor_if_clause(PythonParser.For_if_clauseContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        NameCollectionVisitor v = new NameCollectionVisitor(this.m_currentScope, this.m_source, names);
        ctx.star_targets().accept(v);
        for (String name : names) {
            this.m_currentScope.addLocalName(name, ctx.start.getLine());
        }
        ctx.disjunction().get(0).accept(this);
        if (ctx.disjunction().size() > 1) {
            ctx.disjunction().get(1).accept(this);
        }
        return null;
    }

    private void handleComprehensions(PythonParser.Named_expressionContext nec, PythonParser.For_if_clausesContext fic) {
        Scope parentScope = this.m_currentScope;
        this.m_currentScope = new Scope(parentScope);
        fic.accept(this);
        nec.accept(this);
        this.m_currentScope = this.m_currentScope.getParent();
    }

    @Override
    public Void visitListcomp(PythonParser.ListcompContext ctx) {
        this.handleComprehensions(ctx.named_expression(), ctx.for_if_clauses());
        return null;
    }

    @Override
    public Void visitSetcomp(PythonParser.SetcompContext ctx) {
        this.handleComprehensions(ctx.named_expression(), ctx.for_if_clauses());
        return null;
    }

    @Override
    public Void visitGenexp(PythonParser.GenexpContext ctx) {
        this.handleComprehensions(ctx.named_expression(), ctx.for_if_clauses());
        return null;
    }

    @Override
    public Void visitDictcomp(PythonParser.DictcompContext ctx) {
        Scope parentScope = this.m_currentScope;
        this.m_currentScope = new Scope(parentScope);
        ctx.for_if_clauses().accept(this);
        ctx.kvpair().accept(this);
        this.m_currentScope = this.m_currentScope.getParent();
        return null;
    }

    @Override
    public Void visitFor_stmt(PythonParser.For_stmtContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        NameCollectionVisitor v = new NameCollectionVisitor(this.m_currentScope, this.m_source, names);
        ctx.star_targets().accept(v);
        ctx.star_expressions().accept(this);
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentScope.incrementCcn();
        names.forEach(name -> {
            ScopeItem scopeItem = this.m_currentScope.addLocalName((String)name, ctx.getStart().getLine());
        });
        this.m_currentNesting.increment();
        ctx.block().accept(this);
        if (ctx.else_block() != null) {
            ctx.else_block().accept(this);
        }
        this.m_currentNesting.decrement();
        return null;
    }

    @Override
    public Void visitLambdef(PythonParser.LambdefContext ctx) {
        this.m_currentScope = new Scope(this.m_currentScope);
        this.visitChildren((RuleNode)ctx);
        this.m_currentScope = this.m_currentScope.getParent();
        return null;
    }

    @Override
    public Void visitSimple_stmt(PythonParser.Simple_stmtContext ctx) {
        this.m_currentScope.incrementNumberOfStatements();
        return (Void)super.visitSimple_stmt(ctx);
    }

    @Override
    public Void visitIf_stmt(PythonParser.If_stmtContext ctx) {
        this.m_currentScope.incrementCcn();
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentNesting.increment();
        Void result = (Void)super.visitIf_stmt(ctx);
        this.m_currentNesting.decrement();
        return result;
    }

    @Override
    public Void visitWhile_stmt(PythonParser.While_stmtContext ctx) {
        this.m_currentScope.incrementCcn();
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentNesting.increment();
        Void result = (Void)super.visitWhile_stmt(ctx);
        this.m_currentNesting.decrement();
        return result;
    }

    @Override
    public Void visitTry_stmt(PythonParser.Try_stmtContext ctx) {
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentNesting.increment();
        Void result = (Void)super.visitTry_stmt(ctx);
        this.m_currentNesting.decrement();
        return result;
    }

    @Override
    public Void visitWith_stmt(PythonParser.With_stmtContext ctx) {
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentNesting.increment();
        this.visitChildren((RuleNode)ctx);
        this.m_currentNesting.decrement();
        return null;
    }

    @Override
    public Void visitWith_item(PythonParser.With_itemContext ctx) {
        ctx.expression().accept(this);
        if (ctx.star_target() != null) {
            ArrayList<String> names = new ArrayList<String>();
            NameCollectionVisitor v = new NameCollectionVisitor(this.m_currentScope, this.m_source, names);
            int line = ctx.star_target().start.getLine();
            ctx.star_target().accept(v);
            for (String name : names) {
                this.m_currentScope.addLocalName(name, line);
            }
        }
        return null;
    }

    private void handleExceptBlock(PythonParser.BlockContext blockContext, PythonParser.ExpressionContext ctx, TerminalNode nameNode) {
        ScopeItem item = null;
        Scope parent = this.m_currentScope;
        this.m_currentScope = new Scope(parent);
        if (nameNode != null) {
            item = this.m_currentScope.addLocalName(nameNode.getText(), nameNode.getSymbol().getLine());
        }
        if (ctx != null) {
            TypeVisitor tv = new TypeVisitor(this.m_currentScope, this.m_source, true, true);
            ctx.accept(tv);
            ClassScope typeHint = tv.getResult();
            if (typeHint != null && item != null) {
                item.setTypeHint(new TypeClass(typeHint));
            }
        }
        if (blockContext != null) {
            blockContext.accept(this);
        }
        this.m_currentScope = parent;
    }

    @Override
    public Void visitExcept_block(PythonParser.Except_blockContext ctx) {
        this.handleExceptBlock(ctx.block(), ctx.expression(), ctx.NAME());
        return null;
    }

    @Override
    public Void visitExcept_star_block(PythonParser.Except_star_blockContext ctx) {
        this.handleExceptBlock(ctx.block(), ctx.expression(), ctx.NAME());
        return null;
    }

    @Override
    public Void visitMatch_stmt(PythonParser.Match_stmtContext ctx) {
        this.m_currentScope.incrementNumberOfStatements();
        this.m_currentNesting.increment();
        Void result = (Void)super.visitMatch_stmt(ctx);
        this.m_currentNesting.decrement();
        return result;
    }

    @Override
    public Void visitCase_block(PythonParser.Case_blockContext ctx) {
        this.m_currentNesting.increment();
        this.m_currentScope.incrementCcn();
        super.visitCase_block(ctx);
        this.m_currentNesting.decrement();
        return null;
    }

    @Override
    public Void visitDisjunction(PythonParser.DisjunctionContext ctx) {
        int i = 0;
        while (i < ctx.getChildCount()) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof TerminalNode) {
                this.m_currentScope.incrementAndOrCount();
            }
            ++i;
        }
        return (Void)super.visitDisjunction(ctx);
    }

    @Override
    public Void visitConjunction(PythonParser.ConjunctionContext ctx) {
        int i = 0;
        while (i < ctx.getChildCount()) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof TerminalNode) {
                this.m_currentScope.incrementAndOrCount();
            }
            ++i;
        }
        return (Void)super.visitConjunction(ctx);
    }

    @Override
    public Void visitPrimary(PythonParser.PrimaryContext ctx) {
        NamedElement fromObject;
        if (ctx.atom() != null) {
            ctx.atom().accept(this);
        }
        if (ctx.genexp() != null) {
            ctx.genexp().accept(this);
        }
        if (ctx.arguments() != null) {
            ctx.arguments().accept(this);
        }
        if (ctx.slices() != null) {
            ctx.slices().accept(this);
        }
        if ((fromObject = this.getFromObject()) == null) {
            return null;
        }
        NameResolver resolver = new NameResolver(this.m_currentScope, this.m_source, true);
        int line = ctx.start.getLine();
        ctx.accept(resolver);
        this.processResolverResult(fromObject, resolver, false, line);
        return null;
    }

    private void processResolverResult(NamedElement fromObject, NameResolver resolver, boolean isLhs, int line) {
        assert (resolver != null) : "Parameter 'resolver' of method 'processResolverResult' must not be null";
        List<ScopeItem> items = resolver.getResolvedItems();
        if (resolver.getUnresolvedNames().size() > 0) {
            for (ScopeItem item : items) {
                if (item.getModelObject() == null) continue;
                DependencyCreator.createDependency(fromObject, item.getModelObject(), PythonDependencyType.READ, line);
            }
        } else {
            int lastIndex = items.size() - 1;
            int i = 0;
            while (i <= lastIndex) {
                ScopeItem item = items.get(i);
                if (item.getModelObject() != null) {
                    if (i == lastIndex) {
                        PythonDependencyType type = isLhs ? PythonDependencyType.WRITE : PythonDependencyType.READ;
                        NamedElement toObject = item.getModelObject();
                        if (resolver.isCall()) {
                            type = PythonDependencyType.CALL;
                        } else if (resolver.isSlice()) {
                            type = isLhs ? PythonDependencyType.WRITE_INDEX : PythonDependencyType.READ_INDEX;
                        } else if (toObject instanceof PythonClass) {
                            type = PythonDependencyType.USES;
                        }
                        if (type == PythonDependencyType.CALL && toObject instanceof PythonClass) {
                            type = PythonDependencyType.NEW;
                        }
                        DependencyCreator.createDependency(fromObject, toObject, type, line);
                    } else {
                        DependencyCreator.createDependency(fromObject, item.getModelObject(), PythonDependencyType.READ, line);
                    }
                }
                ++i;
            }
        }
    }

    private static class NestingInfo {
        private int m_nesting = 0;
        private int m_maxNesting = 0;

        private NestingInfo() {
        }

        private void increment() {
            ++this.m_nesting;
            this.m_maxNesting = Math.max(this.m_nesting, this.m_maxNesting);
        }

        private void decrement() {
            --this.m_nesting;
            assert (this.m_nesting >= 0);
        }
    }
}

