/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.settings;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonCause;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonIssueId;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreterErrorIssue;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreterPathInvalidIssue;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PythonInterpreterCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonInterpreterCreator.class);
    private static final String INTERPRETER_PATH_FILE = "interpreter_path.txt";
    private static final String GENERATOR_PATH = "/python/generator3.py";

    public OperationResultWithOutcome<PythonInterpreter> create(NamedElement parent, String interpreterPath) {
        OperationResultWithOutcome result;
        block25: {
            assert (interpreterPath != null && interpreterPath.length() > 0) : "Parameter 'interpreterPath' of method 'create' must not be empty";
            result = new OperationResultWithOutcome("Create PythonInterpreter");
            File path = new File(interpreterPath);
            String name = path.getName().toLowerCase();
            if (parent != null) {
                parent.removeIssues(new IIssueId[]{PythonIssueId.PYTHON_INTERPRETER_NOT_FOUND, PythonIssueId.PYTHON_INTERPRETER_PATH_INVALID, PythonIssueId.PYTHON_INTERPRETER_ERROR});
            }
            if (!name.startsWith("python") || !path.canExecute()) {
                if (parent != null) {
                    parent.addIssue((Issue)new PythonInterpreterPathInvalidIssue(parent, "Invalid path: " + String.valueOf(path)));
                }
                result.addError((OperationResult.IMessageCause)PythonCause.INVALID_PYTHON_INTERPRETER_PATH);
                return result;
            }
            String[] command = new String[]{interpreterPath, "-c", "import sys; import keyword; print(sys.version_info[0]); print(sys.path); print(keyword.kwlist); print(sys.builtin_module_names)"};
            LOGGER.debug("Executing {}", (Object)StringUtility.concat((char)' ', (String[])command));
            ProcessBuilder pb = new ProcessBuilder(command);
            try {
                String builtinModulesString;
                String keywordsString;
                String pythonPathString;
                int majorVersion;
                Process proc = pb.start();
                boolean isValid = false;
                Throwable throwable = null;
                Object var15_13 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    String majorVersionString = reader.readLine();
                    majorVersion = Integer.valueOf(majorVersionString);
                    pythonPathString = reader.readLine();
                    keywordsString = reader.readLine();
                    builtinModulesString = reader.readLine();
                    while (reader.readLine() != null) {
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ArrayList<String> pythonPaths = new ArrayList<String>();
                JSONArray list = (JSONArray)JSONValue.parse((String)pythonPathString.replace('\'', '\"'));
                if (list != null) {
                    for (Object obj : list) {
                        pythonPaths.add(obj.toString());
                    }
                }
                THashSet keywords = new THashSet();
                list = (JSONArray)JSONValue.parse((String)keywordsString.replace('\'', '\"'));
                if (list != null) {
                    for (Object obj : list) {
                        keywords.add(obj.toString());
                    }
                }
                ArrayList<String> builtinModules = new ArrayList<String>();
                list = (JSONArray)JSONValue.parse((String)builtinModulesString.replace('\'', '\"').replace('(', '[').replace(')', ']'));
                if (list != null) {
                    for (Object obj : list) {
                        builtinModules.add(obj.toString());
                        isValid = true;
                    }
                }
                proc.waitFor();
                if (!isValid) {
                    String message = "No builtin Python modules found for using interpreter path '" + interpreterPath + "'";
                    result.addError((OperationResult.IMessageCause)PythonCause.INVALID_PYTHON_INTERPRETER_PATH, message, new Object[0]);
                    if (parent != null) {
                        parent.addIssue((Issue)new PythonInterpreterPathInvalidIssue(parent, message));
                    }
                    return result;
                }
                PythonInterpreter interpreter = new PythonInterpreter(parent, interpreterPath);
                interpreter.setMajorVersion(majorVersion);
                interpreter.setPythonPathString(pythonPathString);
                interpreter.setPythonPaths(pythonPaths);
                interpreter.setKeywords((Set<String>)keywords);
                interpreter.setBuiltinModules(builtinModules);
                result.setOutcome((Object)interpreter);
            }
            catch (IOException | InterruptedException | NumberFormatException ex) {
                result.addError((OperationResult.IMessageCause)PythonCause.FAILED_TO_CREATE_PYTHON_INTERPRETER, (Throwable)ex);
                if (parent == null) break block25;
                parent.addIssue((Issue)new PythonInterpreterErrorIssue(parent, "Failed to create Python interpreter: " + ex.getMessage()));
            }
        }
        return result;
    }

    public OperationResultWithOutcome<PythonInterpreter> create(IWorkerContext workerContext, NamedElement parent, String interpreterPath, TFile skeletonBaseDir, TFile pythonUserHome, SkeletonGeneration skeletonGeneration) {
        boolean mustGenerate;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'create' must not be null";
        assert (interpreterPath != null && interpreterPath.length() > 0) : "Parameter 'interpreterPath' of method 'create' must not be empty";
        assert (skeletonBaseDir != null) : "Parameter 'skeletonBaseDir' of method 'create' must not be null";
        assert (pythonUserHome != null) : "Parameter 'pythonUserHome' of method 'create' must not be null";
        assert (skeletonGeneration != null) : "Parameter 'skeletonGeneration' of method 'create' must not be null";
        workerContext.working("Extracting basic interpreter information", true);
        LOGGER.info("Create python interpreter for " + interpreterPath);
        OperationResultWithOutcome<PythonInterpreter> result = this.create(parent, interpreterPath);
        if (result.isFailure()) {
            return result;
        }
        PythonInterpreter interpreter = (PythonInterpreter)((Object)result.getOutcome());
        interpreter.setPythonUserHome(pythonUserHome);
        TFile skeletonDir = new TFile((File)skeletonBaseDir, "Skeletons");
        interpreter.setSkeletonDir(skeletonDir);
        TFile interpreterPathFile = new TFile((File)skeletonDir, INTERPRETER_PATH_FILE);
        boolean bl = mustGenerate = skeletonGeneration == SkeletonGeneration.GENERATE;
        if (!mustGenerate && skeletonDir.isDirectory()) {
            long interpreterTimeStamp;
            long timeStamp;
            try {
                Throwable throwable = null;
                Object var13_18 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader((File)interpreterPathFile));){
                    String fileName = reader.readLine();
                    String path = reader.readLine();
                    mustGenerate = !fileName.equals(interpreter.getInterpreterPath()) || !interpreter.getPythonPathString().equals(path);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                mustGenerate = true;
            }
            if (!mustGenerate && (timeStamp = interpreterPathFile.lastModified()) < (interpreterTimeStamp = new TFile(interpreter.getInterpreterPath()).lastModified())) {
                mustGenerate = true;
            }
            if (!mustGenerate) {
                TFile builtins = new TFile((File)skeletonDir, "builtins.py");
                mustGenerate = !builtins.canRead();
            }
        } else {
            mustGenerate = true;
        }
        if (mustGenerate) {
            OperationResult skeletonGenerationResult = this.generateSkeletons(workerContext, parent, interpreter, skeletonDir, pythonUserHome);
            if (skeletonGenerationResult.isSuccess()) {
                interpreter.addPythonPath(skeletonDir.getNormalizedAbsolutePath());
            } else {
                result.addMessagesFrom(skeletonGenerationResult);
            }
        }
        return result;
    }

    private OperationResult generateSkeletons(IWorkerContext workerContext, NamedElement parent, PythonInterpreter interpreter, TFile skeletonDir, TFile pythonUserHome) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generateSkeletons' must not be null";
        assert (interpreter != null) : "Parameter 'interpreter' of method 'generateSkeletons' must not be null";
        assert (skeletonDir != null) : "Parameter 'skeletonDir' of method 'generateSkeletons' must not be null";
        assert (pythonUserHome != null) : "Parameter 'pythonUserHome' of method 'generateSkeletons' must not be null";
        TFile generatorPath = new TFile((File)pythonUserHome, GENERATOR_PATH);
        assert (generatorPath.canRead()) : "No permisson to read: " + generatorPath.getAbsolutePath();
        OperationResult result = new OperationResult("Generating Python skeletons");
        workerContext.working("Generating Python skeletons", true);
        LOGGER.debug("Start generating Python skeletons...");
        try {
            Object writer;
            if (skeletonDir.isDirectory()) {
                skeletonDir.rm_r();
            }
            if (!skeletonDir.isDirectory()) {
                skeletonDir.mkdirs();
            }
            String[] cmd1 = new String[]{interpreter.getInterpreterPath(), "-B", generatorPath.getNormalizedAbsolutePath(), "-b", "-q", "-d", skeletonDir.getNormalizedAbsolutePath()};
            ProcessBuilder pb = new ProcessBuilder(cmd1);
            LOGGER.debug("Executing {}", (Object)StringUtility.concat((char)' ', (String[])cmd1));
            Process proc = pb.start();
            proc.waitFor();
            Throwable throwable = null;
            Object var12_15 = null;
            try {
                writer = new BufferedWriter(new FileWriter((File)new TFile((File)skeletonDir, INTERPRETER_PATH_FILE)));
                try {
                    ((Writer)writer).write(interpreter.getInterpreterPath());
                    ((BufferedWriter)writer).newLine();
                    ((Writer)writer).write(interpreter.getPythonPathString());
                    ((BufferedWriter)writer).newLine();
                }
                finally {
                    if (writer != null) {
                        ((BufferedWriter)writer).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            workerContext.working("Analyzing binary modules", true);
            String[] cmd2 = new String[]{interpreter.getInterpreterPath(), "-B", generatorPath.getNormalizedAbsolutePath(), "-L"};
            pb = new ProcessBuilder(cmd2);
            LOGGER.debug("Executing {}", (Object)StringUtility.concat((char)' ', (String[])cmd2));
            proc = pb.start();
            ArrayList<String> binaryModules = new ArrayList<String>();
            writer = null;
            Iterator iterator = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int tabPos = line.indexOf(9);
                    if (tabPos <= 0) continue;
                    line = line.substring(0, tabPos);
                    binaryModules.add(line);
                }
            }
            catch (Throwable throwable3) {
                if (writer == null) {
                    writer = throwable3;
                } else if (writer != throwable3) {
                    ((Throwable)writer).addSuppressed(throwable3);
                }
                throw writer;
            }
            proc.waitFor();
            for (String binaryModule : binaryModules) {
                workerContext.working("Analyzing module '" + binaryModule + "'", true);
                String[] cmd3 = new String[]{interpreter.getInterpreterPath(), "-B", generatorPath.getNormalizedAbsolutePath(), "-q", "-d", skeletonDir.getNormalizedAbsolutePath(), binaryModule};
                LOGGER.debug("Executing {}", (Object)StringUtility.concat((char)' ', (String[])cmd3));
                pb = new ProcessBuilder(cmd3);
                proc = pb.start();
                proc.waitFor();
            }
        }
        catch (IOException | InterruptedException e) {
            result.addError((OperationResult.IMessageCause)PythonCause.FAILED_TO_GENERATE_SKELETONS, (Throwable)e);
            parent.addIssue((Issue)new PythonInterpreterErrorIssue(parent, "Failed to generate skeletons: " + e.getMessage()));
            return result;
        }
        workerContext.working("Postprocessing of skeletons", true);
        try {
            this.cleanupSkeletons(skeletonDir, result);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)PythonCause.SKELETON_CLEANUP_FAILED, (Throwable)ex);
            parent.addIssue((Issue)new PythonInterpreterErrorIssue(parent, "Failed to cleanup skeletons: " + ex.getMessage()));
        }
        LOGGER.debug("Finished generating Python skeletons");
        return result;
    }

    private void cleanupSkeletons(TFile dir, OperationResult result) throws IOException {
        assert (dir != null) : "Parameter 'dir' of method 'cleanupSkeletons' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleanupSkeletons' must not be null";
        TFile[] tFileArray = dir.listFiles();
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TFile file = tFileArray[n2];
            if (file.isDirectory()) {
                this.cleanupSkeletons(file, result);
            } else if (file.isFile() && file.getName().endsWith(".py")) {
                this.cleanupSkeleton(file, result);
            }
            ++n2;
        }
    }

    private void cleanupSkeleton(TFile file, OperationResult result) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'cleanupSkeleton' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleanupSkeleton' must not be null";
        StringBuilder sb = new StringBuilder();
        boolean foundProblem = false;
        List lines = FileUtility.getFileLinesWithLineBreaks((TFile)file);
        for (String line : lines) {
            if (line.trim().startsWith("def ")) {
                int c;
                StringReader lineReader = new StringReader(line);
                int parentheses = 0;
                boolean skipRest = false;
                boolean skipUntilCommaOrRp = false;
                while ((c = lineReader.read()) > 0) {
                    if (skipRest) {
                        sb.append((char)c);
                        continue;
                    }
                    if (skipUntilCommaOrRp) {
                        sb.append((char)c);
                        if (c == 40) {
                            ++parentheses;
                            continue;
                        }
                        if (c == 41) {
                            if (--parentheses != 0) continue;
                            skipUntilCommaOrRp = false;
                            continue;
                        }
                        if (c != 44 || parentheses != 1) continue;
                        skipUntilCommaOrRp = false;
                        continue;
                    }
                    if (c == 61) {
                        sb.append((char)c);
                        skipUntilCommaOrRp = true;
                        continue;
                    }
                    if (c == 40) {
                        if (++parentheses == 1) {
                            sb.append((char)c);
                            continue;
                        }
                        foundProblem = true;
                        continue;
                    }
                    if (c == 41) {
                        if (--parentheses == 0) {
                            sb.append((char)c);
                            continue;
                        }
                        foundProblem = true;
                        continue;
                    }
                    if (c == 35) {
                        skipRest = true;
                    }
                    sb.append((char)c);
                }
                continue;
            }
            sb.append(line);
        }
        if (foundProblem) {
            FileUtility.writeFileContent((String)sb.toString(), (TFile)file);
        }
    }

    public static enum SkeletonGeneration {
        GENERATE,
        USE_EXISTING;

    }
}

