/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.system;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.MetricCategory;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonProviderId;
import java.util.Arrays;
import java.util.List;

public final class PythonMetricId
extends Enum<PythonMetricId>
implements IMetricId {
    public static final /* enum */ PythonMetricId PYTHON_PACKAGE_CYCLE_GROUPS = new PythonMetricId("Number of all Python Package Cycle Groups", "Number of all Python package cycle groups, errors and warnmings.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_CRITICAL_PACKAGE_CYCLE_GROUPS = new PythonMetricId("Number of Critical Python Package Cycle Groups", "Number of Python package cycle groups marked as errors.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_CYCLIC_PACKAGES = new PythonMetricId("Number of Cyclic Python Packages", "Number of cyclic Python packages.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_IGNORED_CYCLIC_PACKAGES = new PythonMetricId("Number of Ignored Cyclic Python Packages", "Number of ignored cyclic Python packages.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_BIGGEST_PACKAGE_CYCLE_GROUP = new PythonMetricId("Biggest Python Package Cycle Group", "Biggest Python package cycle group.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_PACKAGES = new PythonMetricId("Number of Python Packages", "Number of Python packages containing types in fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ PythonMetricId PYTHON_PACKAGES_FULLY_ANALYZED = new PythonMetricId("Number of Python Packages (Full Analysis)", "Number of Python packages containing fully analyzed types.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ PythonMetricId PYTHON_STRUCTURAL_DEBT_INDEX_PACKAGES = new PythonMetricId("Structural Debt Index (Python Packages)", "Cumulative structural debt index of all Python package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ PythonMetricId PYTHON_PARSER_DEPENDENCIES_TO_REMOVE_PACKAGES = new PythonMetricId("Parser Dependencies to Remove (Python Packages)", "Number of code lines to change to break up all Python package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ PythonMetricId PYTHON_COMPONENT_DEPENDENCIES_TO_REMOVE_PACKAGES = new PythonMetricId("Component Dependencies to Remove (Python Packages)", "Number of component dependencies to remove to break up all Python package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ PythonMetricId PYTHON_CYCLICITY_PACKAGES = new PythonMetricId("Cyclicity (Python Packages)", "Cumulated cyclicity of Python package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_RELATIVE_CYCLICITY_PACKAGES = new PythonMetricId("Relative Cyclicity (Python Packages)", "Relative Python package cyclicity in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ PythonMetricId PYTHON_AVERAGE_RELATIVE_CYCLICITY_PACKAGES = new PythonMetricId("Average Relative Cyclicity (Python Packages)", "Weighted average of relative Python package cyclicity of modules in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    private final String m_presentationName;
    private final String m_description;
    private final boolean m_isFloat;
    private final IMetricId.StandardSorting m_sorting;
    private final IMetricId.MetricRange m_range;
    private final IMetricCategory[] m_categories;
    private final MetricScope m_metricScope;
    private static final /* synthetic */ PythonMetricId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new PythonMetricId[]{PYTHON_PACKAGE_CYCLE_GROUPS, PYTHON_CRITICAL_PACKAGE_CYCLE_GROUPS, PYTHON_CYCLIC_PACKAGES, PYTHON_IGNORED_CYCLIC_PACKAGES, PYTHON_BIGGEST_PACKAGE_CYCLE_GROUP, PYTHON_PACKAGES, PYTHON_PACKAGES_FULLY_ANALYZED, PYTHON_STRUCTURAL_DEBT_INDEX_PACKAGES, PYTHON_PARSER_DEPENDENCIES_TO_REMOVE_PACKAGES, PYTHON_COMPONENT_DEPENDENCIES_TO_REMOVE_PACKAGES, PYTHON_CYCLICITY_PACKAGES, PYTHON_RELATIVE_CYCLICITY_PACKAGES, PYTHON_AVERAGE_RELATIVE_CYCLICITY_PACKAGES};
    }

    private PythonMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, IMetricCategory ... category) {
        this(presentationName, description, isFloat, sorting, range, MetricScope.SYSTEM, category);
    }

    private PythonMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, MetricScope metricScope, IMetricCategory ... category) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CoreMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'CoreMetricId' must not be empty";
        assert (metricScope != null) : "Parameter 'metricScope' of method 'PythonMetricId' must not be null";
        this.m_presentationName = presentationName;
        this.m_description = description;
        this.m_isFloat = isFloat;
        this.m_metricScope = metricScope;
        this.m_categories = category;
        this.m_sorting = sorting;
        this.m_range = range;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public IProviderId getProvider() {
        return PythonProviderId.INSTANCE;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isFloat() {
        return this.m_isFloat;
    }

    public List<IMetricCategory> getCategories() {
        return Arrays.asList(this.m_categories);
    }

    public IMetricId.IMetricRange getRange() {
        return this.m_range;
    }

    public IMetricId.StandardSorting getSorting() {
        return this.m_sorting;
    }

    public MetricScope getMetricScope() {
        return this.m_metricScope;
    }

    public static PythonMetricId[] values() {
        PythonMetricId[] pythonMetricIdArray = ENUM$VALUES;
        int n = pythonMetricIdArray.length;
        PythonMetricId[] pythonMetricIdArray2 = new PythonMetricId[n];
        System.arraycopy(ENUM$VALUES, 0, pythonMetricIdArray2, 0, n);
        return pythonMetricIdArray2;
    }

    public static PythonMetricId valueOf(String string) {
        return Enum.valueOf(PythonMetricId.class, string);
    }
}

